/*
 * Decompiled with CFR 0.152.
 */
package com.chongaibao.cabpub.sdk;

import com.alibaba.fastjson.JSONObject;
import com.chongaibao.cabpub.sdk.common.ChongaibaoEnvEnum;
import com.chongaibao.cabpub.sdk.common.ChongaibaoSdkErrorEnum;
import com.chongaibao.cabpub.sdk.common.ChongaibaoSdkException;
import com.chongaibao.cabpub.sdk.common.CommonResponse;
import com.chongaibao.cabpub.sdk.common.DefaultRequest;
import com.chongaibao.cabpub.sdk.common.DefaultResponse;
import com.chongaibao.cabpub.sdk.common.ProtocolParameterEnum;
import com.chongaibao.cabpub.sdk.signature.SignatureUtils;
import com.chongaibao.cabpub.sdk.signature.StringUtils;
import com.chongaibao.cabpub.sdk.util.ChongaibaoSdkHttpUtils;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChongaibaoClient {
    private int connectTimeout = 3000;
    private int readTimeout = 80000;
    private String env;
    private String appKey;
    private String privateKey;
    private String url;
    private String zaPublicKey;
    private String charset = "UTF-8";
    private String signType = "RSA";
    private String version = "1.0.0";
    private String format = "json";
    private String timestamp;

    public ChongaibaoClient(String env, String url, String appKey, String privateKey, String version) {
        this.env = env;
        this.url = url;
        this.appKey = appKey;
        this.privateKey = privateKey;
        this.version = version;
    }

    public ChongaibaoClient(String env, String url, String appKey, String privateKey, String charset, String signType, String version, String format, int connectTimeout, int readTimeout) {
        this.url = url;
        this.env = env;
        this.appKey = appKey;
        this.privateKey = privateKey;
        this.charset = charset;
        this.signType = signType;
        this.version = version;
        this.format = format;
        this.connectTimeout = connectTimeout;
        this.readTimeout = readTimeout;
    }

    private void init() throws ChongaibaoSdkException {
        this.timestamp = System.currentTimeMillis() + "";
        ChongaibaoEnvEnum envEnum = ChongaibaoEnvEnum.get(this.env);
        if (envEnum == null) {
            if (!this.env.startsWith("uat")) {
                throw new ChongaibaoSdkException(ChongaibaoSdkErrorEnum.ARGUMENTS_ILLEGAL.getCode(), "env\u5fc5\u987b\u662fdev,iTest,uat,prd\u4e2d\u7684\u4e00\u4e2a");
            }
            envEnum = ChongaibaoEnvEnum.get("uat");
        }
        if (StringUtils.isBlank(this.url) || "prd".equals(this.env)) {
            this.url = envEnum.getUrl();
        }
        this.zaPublicKey = envEnum.getPublicKey();
    }

    public DefaultResponse invoke(DefaultRequest req) throws ChongaibaoSdkException {
        Object response;
        this.init();
        req.init();
        req.checkSysParams();
        req.checkBizParams();
        JSONObject encryptSignJSON = req.buildEncryptSignParamMap();
        encryptSignJSON.put(ProtocolParameterEnum.APP_KEY.getCode(), (Object)this.appKey);
        encryptSignJSON.put(ProtocolParameterEnum.TIME_STAMP.getCode(), (Object)this.timestamp);
        encryptSignJSON.put(ProtocolParameterEnum.FORMAT.getCode(), (Object)this.format);
        encryptSignJSON.put(ProtocolParameterEnum.SIGN_TYPE.getCode(), (Object)this.signType);
        encryptSignJSON.put(ProtocolParameterEnum.CHARSET.getCode(), (Object)this.charset);
        encryptSignJSON.put(ProtocolParameterEnum.VERSION.getCode(), (Object)this.version);
        Map<String, Object> rt = this.doPost(encryptSignJSON);
        if (rt == null) {
            return null;
        }
        if (rt.get("bizContent") != null) {
            if (CommonResponse.class.getName().equals(req.getResponse().getClass().getName())) {
                response = new CommonResponse();
                ((DefaultResponse)response).setBizContent((String)rt.get("bizContent"));
            } else {
                response = JSONObject.parseObject((String)((String)rt.get("bizContent")), req.getResponse().getClass());
            }
        } else {
            response = req.getResponse();
        }
        if (rt.get("errorCode") != null) {
            ((DefaultResponse)response).setErrorCode((String)rt.get("errorCode"));
        }
        if (rt.get("errorMsg") != null) {
            ((DefaultResponse)response).setErrorMsg((String)rt.get("errorMsg"));
        }
        ((DefaultResponse)response).setCharset((String)rt.get("charset"));
        ((DefaultResponse)response).setFormat((String)rt.get("format"));
        ((DefaultResponse)response).setSignType((String)rt.get("signType"));
        ((DefaultResponse)response).setTimestamp((String)rt.get("timestamp"));
        return (DefaultResponse)response;
    }

    protected Map<String, Object> doPost(JSONObject paramJSON) throws ChongaibaoSdkException {
        JSONObject responseJson1;
        String gatewayResponse1;
        Map<String, Object> encryptMap;
        try {
            encryptMap = SignatureUtils.encryptAndSign((Map<String, Object>)paramJSON, this.zaPublicKey, this.privateKey, "utf-8", true, true);
        }
        catch (Exception var11) {
            throw new ChongaibaoSdkException(ChongaibaoSdkErrorEnum.ENCRYPT_SIGN_FAILED.getCode(), var11.getMessage(), var11);
        }
        HashMap<String, String> params = new HashMap<String, String>();
        for (Map.Entry<String, Object> gatewayResponse : encryptMap.entrySet()) {
            params.put(gatewayResponse.getKey(), (String)gatewayResponse.getValue());
        }
        try {
            gatewayResponse1 = ChongaibaoSdkHttpUtils.doPost(this.url, params, this.connectTimeout, this.readTimeout);
        }
        catch (IOException var10) {
            throw new ChongaibaoSdkException(var10);
        }
        try {
            responseJson1 = JSONObject.parseObject((String)gatewayResponse1);
        }
        catch (Exception var9) {
            throw new ChongaibaoSdkException(ChongaibaoSdkErrorEnum.ERROR_RESPONSE.getCode(), ChongaibaoSdkErrorEnum.ERROR_RESPONSE.getDescription());
        }
        boolean isDecrypt = !StringUtils.isBlank(responseJson1.getString("bizContent"));
        try {
            String errorCode = responseJson1.getString("errorCode");
            String errorMsg = responseJson1.getString("errorMsg");
            String e = SignatureUtils.checkSignAndDecrypt((Map<String, Object>)responseJson1, this.zaPublicKey, this.privateKey, true, isDecrypt);
            responseJson1.put("bizContent", (Object)e);
            responseJson1.put("errorCode", (Object)errorCode);
            responseJson1.put("errorMsg", (Object)errorMsg);
            return responseJson1;
        }
        catch (Exception var8) {
            throw new ChongaibaoSdkException(var8);
        }
    }
}

