/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.explorer.ui;

import com.vaadin.ui.AbstractSelect;
import com.vaadin.ui.Table;
import org.activiti.explorer.ui.AbstractPage;

public abstract class AbstractTablePage
extends AbstractPage {
    private static final long serialVersionUID = 1L;
    protected Table table;

    @Override
    protected AbstractSelect createSelectComponent() {
        this.table = this.createList();
        this.table.setEditable(false);
        this.table.setImmediate(true);
        this.table.setSelectable(true);
        this.table.setNullSelectionAllowed(false);
        this.table.setSortDisabled(true);
        this.table.setSizeFull();
        return this.table;
    }

    protected abstract Table createList();

    @Override
    public void refreshSelectNext() {
        Integer pageIndex = (Integer)this.table.getCurrentPageFirstItemId();
        Integer selectedIndex = (Integer)this.table.getValue();
        this.table.removeAllItems();
        this.table.getContainerDataSource().removeAllItems();
        Integer max = this.table.getContainerDataSource().size();
        if (max != 0) {
            if (pageIndex > max) {
                pageIndex = max - 1;
            }
            if (selectedIndex > max) {
                selectedIndex = max - 1;
            }
            this.table.setCurrentPageFirstItemIndex(pageIndex.intValue());
            this.selectElement(selectedIndex);
        } else {
            this.table.setCurrentPageFirstItemIndex(0);
        }
    }

    @Override
    public void selectElement(int index) {
        if (this.table.getContainerDataSource().size() > index) {
            this.table.select((Object)index);
            this.table.setCurrentPageFirstItemId((Object)index);
        }
    }
}

