package com.cab.passport.votes.pub.web;

import com.alibaba.fastjson.JSON;
import com.cab.passport.votes.service.SchoolService;
import com.cab.passport.votes.service.VotesService;
import com.thinkgem.jeesite.common.utils.RESTResponse;
import com.thinkgem.jeesite.common.web.BaseController;
import com.thinkgem.jeesite.modules.sys.entity.BaseFile;
import com.thinkgem.jeesite.modules.sys.service.FileService;
import org.apache.commons.io.IOUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.HashMap;

@Controller
@RequestMapping(value = "pub/vote")
public class PubVotesController extends BaseController {
    @Autowired
    private SchoolService schoolService;
    @Autowired
    private VotesService votesService;
    @Autowired
    private  FileService fileService;

    @RequestMapping(value = "/getList", method = RequestMethod.GET)
    @ResponseBody
    public RESTResponse getList(HttpServletRequest request) {
        return schoolService.getList(request);
    }

    @RequestMapping(value = "/saveVotes", method = RequestMethod.POST)
    @ResponseBody
    public RESTResponse saveVotes(HttpServletRequest request,@RequestBody String json) {
        return votesService.saveVotes(request,json);
    }

    @RequestMapping("/getTicket")
    @ResponseBody
    public RESTResponse getTicket(@RequestBody String json, HttpServletRequest request) throws Exception {
        HashMap<String, String> map = JSON.parseObject(json, HashMap.class);
        String url = map.get("url");
        try {
            return new RESTResponse(votesService.getTicket(url));
        } catch (Exception e) {
            logger.error(e.getMessage(), e);
            return new RESTResponse(10001, e.getMessage());
        }

    }
    @RequestMapping(value = "/getUserInfo", method = RequestMethod.POST)
    @ResponseBody
    public RESTResponse getUserInfo(HttpServletRequest request,@RequestBody String json) {
        try {
            return new RESTResponse(votesService.getUserInfo(json,request));
        } catch (Exception e) {
            return new RESTResponse(10001, e.getMessage());
        }
    }

    @RequestMapping(value = "/image/{id}")
    public void image(@PathVariable String id, HttpServletResponse response) throws IOException {
        BaseFile file = fileService.get(id);
        FileInputStream fis = new FileInputStream(FileService.fileDir + File.separator + file.getLocation() + File.separator + file.getName());
        response.setContentType("image/png");
        byte[] b = new byte[fis.available()];
        IOUtils.read(fis, b);
        fis.close();
        IOUtils.write(b, response.getOutputStream());
    }
}
