/*
 * Decompiled with CFR 0.152.
 */
package math.geom2d.polygon;

import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import math.geom2d.AffineTransform2D;
import math.geom2d.Box2D;
import math.geom2d.GeometricObject2D;
import math.geom2d.Point2D;
import math.geom2d.circulinear.CirculinearBoundary2D;
import math.geom2d.circulinear.CirculinearContourArray2D;
import math.geom2d.circulinear.CirculinearCurve2D;
import math.geom2d.circulinear.CirculinearDomain2D;
import math.geom2d.circulinear.GenericCirculinearDomain2D;
import math.geom2d.circulinear.buffer.BufferCalculator;
import math.geom2d.curve.CurveArray2D;
import math.geom2d.domain.ContourArray2D;
import math.geom2d.line.LineSegment2D;
import math.geom2d.polygon.LinearRing2D;
import math.geom2d.polygon.Polygon2D;
import math.geom2d.polygon.Polygons2D;
import math.geom2d.polygon.SimplePolygon2D;
import math.geom2d.transform.CircleInversion2D;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Deprecated
public class HRectangle2D
extends Rectangle2D.Double
implements Polygon2D {
    private static final long serialVersionUID = 1L;

    public HRectangle2D(double x0, double y0, double w, double h) {
        super(x0, y0, w, h);
    }

    public HRectangle2D() {
        super(0.0, 0.0, 0.0, 0.0);
    }

    public HRectangle2D(Rectangle2D rect) {
        super(rect.getX(), rect.getY(), rect.getWidth(), rect.getHeight());
    }

    public HRectangle2D(Point2D point, double w, double h) {
        super(point.getX(), point.getY(), w, h);
    }

    @Override
    public Collection<Point2D> vertices() {
        ArrayList<Point2D> points = new ArrayList<Point2D>(4);
        points.add(new Point2D(this.x, this.y));
        points.add(new Point2D(this.x + this.width, this.y));
        points.add(new Point2D(this.x + this.width, this.y + this.height));
        points.add(new Point2D(this.x, this.y + this.height));
        return points;
    }

    @Override
    public Point2D vertex(int i) {
        switch (i) {
            case 0: {
                return new Point2D(this.x, this.y);
            }
            case 1: {
                return new Point2D(this.x + this.width, this.y);
            }
            case 2: {
                return new Point2D(this.x + this.width, this.y + this.height);
            }
            case 3: {
                return new Point2D(this.x, this.y + this.height);
            }
        }
        throw new IndexOutOfBoundsException();
    }

    @Override
    public void setVertex(int i, Point2D point) {
        throw new UnsupportedOperationException("Vertices of HRectangle objects can not be modified");
    }

    @Override
    public void addVertex(Point2D point) {
        throw new UnsupportedOperationException("Vertices of HRectangle objects can not be modified");
    }

    @Override
    public void insertVertex(int i, Point2D point) {
        throw new UnsupportedOperationException("Vertices of HRectangle objects can not be modified");
    }

    @Override
    public void removeVertex(int i) {
        throw new UnsupportedOperationException("Vertices of HRectangle objects can not be modified");
    }

    @Override
    public int vertexNumber() {
        return 4;
    }

    @Override
    public int closestVertexIndex(Point2D point) {
        double minDist = Double.POSITIVE_INFINITY;
        int index = -1;
        int i = 0;
        for (Point2D vertex : this.vertices()) {
            double dist = vertex.distance(point);
            if (dist < minDist) {
                index = i;
                minDist = dist;
            }
            ++i;
        }
        return index;
    }

    public Collection<LineSegment2D> edges() {
        ArrayList<LineSegment2D> edges = new ArrayList<LineSegment2D>(4);
        edges.add(new LineSegment2D(this.x, this.y, this.x + this.width, this.y));
        edges.add(new LineSegment2D(this.x + this.width, this.y, this.x + this.width, this.y + this.height));
        edges.add(new LineSegment2D(this.x + this.width, this.y + this.height, this.x, this.y + this.height));
        edges.add(new LineSegment2D(this.x, this.y + this.height, this.x, this.y));
        return edges;
    }

    @Override
    public int edgeNumber() {
        return 4;
    }

    @Override
    public double area() {
        return Polygons2D.computeArea(this);
    }

    @Override
    public Point2D centroid() {
        return Polygons2D.computeCentroid(this);
    }

    @Override
    public CirculinearDomain2D transform(CircleInversion2D inv) {
        return new GenericCirculinearDomain2D((CirculinearBoundary2D)((CirculinearContourArray2D)this.boundary()).transform(inv));
    }

    @Override
    public CirculinearDomain2D buffer(double dist) {
        BufferCalculator bc = BufferCalculator.getDefaultInstance();
        return bc.computeBuffer((CirculinearCurve2D)((Object)this.boundary()), dist);
    }

    @Override
    public Polygon2D asPolygon(int n) {
        return this;
    }

    @Override
    public CirculinearContourArray2D<LinearRing2D> boundary() {
        return new CirculinearContourArray2D<LinearRing2D>(this.asRing());
    }

    public Collection<LinearRing2D> contours() {
        ArrayList<LinearRing2D> rings = new ArrayList<LinearRing2D>(1);
        rings.add(this.asRing());
        return rings;
    }

    private LinearRing2D asRing() {
        Point2D[] pts = new Point2D[]{new Point2D(this.x, this.y), new Point2D(this.width + this.x, this.y), new Point2D(this.width + this.x, this.y + this.height), new Point2D(this.x, this.y + this.height)};
        return new LinearRing2D(pts);
    }

    @Override
    public Polygon2D complement() {
        Point2D[] pts = new Point2D[]{new Point2D(this.x, this.y), new Point2D(this.x, this.y + this.height), new Point2D(this.width + this.x, this.y + this.height), new Point2D(this.width + this.x, this.y)};
        return new SimplePolygon2D(pts);
    }

    @Override
    public double distance(Point2D p) {
        return this.distance(p.getX(), p.getY());
    }

    @Override
    public double distance(double x, double y) {
        double dist = ((ContourArray2D)this.boundary()).signedDistance(x, y);
        return Math.max(dist, 0.0);
    }

    @Override
    public HRectangle2D clip(Box2D box) {
        double xmin = Math.max(this.getMinX(), box.getMinX());
        double xmax = Math.min(this.getMaxX(), box.getMaxX());
        double ymin = Math.max(this.getMinY(), box.getMinY());
        double ymax = Math.min(this.getMaxY(), box.getMaxY());
        if (xmin > xmax || ymin > ymax) {
            return new HRectangle2D(xmin, ymin, 0.0, 0.0);
        }
        return new HRectangle2D(xmin, xmax, xmax - xmin, ymax - ymin);
    }

    @Override
    public boolean isBounded() {
        return true;
    }

    @Override
    public Box2D boundingBox() {
        return new Box2D(this.getMinX(), this.getMaxX(), this.getMinY(), this.getMaxY());
    }

    @Override
    public SimplePolygon2D transform(AffineTransform2D trans) {
        int nPoints = 4;
        Point2D[] array = new Point2D[nPoints];
        Point2D[] res = new Point2D[nPoints];
        Iterator<Point2D> iter = this.vertices().iterator();
        int i = 0;
        while (i < nPoints) {
            array[i] = iter.next();
            res[i] = new Point2D();
            ++i;
        }
        trans.transform(array, res);
        return new SimplePolygon2D(res);
    }

    @Override
    public void draw(Graphics2D g2) {
        g2.draw(((CurveArray2D)((Object)this.boundary())).getGeneralPath());
    }

    @Override
    public void fill(Graphics2D g2) {
        g2.fill(((CurveArray2D)((Object)this.boundary())).getGeneralPath());
    }

    @Override
    public boolean almostEquals(GeometricObject2D obj, double eps) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof HRectangle2D)) {
            return false;
        }
        HRectangle2D rect = (HRectangle2D)obj;
        for (Point2D point : this.vertices()) {
            boolean ok = false;
            for (Point2D point2 : rect.vertices()) {
                if (!point.almostEquals(point2, eps)) continue;
                ok = true;
            }
            if (ok) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof HRectangle2D)) {
            return false;
        }
        HRectangle2D rect = (HRectangle2D)obj;
        for (Point2D point : this.vertices()) {
            boolean ok = false;
            for (Point2D point2 : rect.vertices()) {
                if (!point.equals(point2)) continue;
                ok = true;
            }
            if (ok) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean contains(Point2D p) {
        return this.contains(p.getX(), p.getY());
    }
}

