package com.cab.passport.awards.service;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import com.cab.passport.awards.dao.AwardsClassifyDao;
import com.cab.passport.awards.dao.AwardsWinnerDao;
import com.cab.passport.awards.entity.AwardsClassify;
import com.cab.passport.awards.entity.AwardsWinner;
import com.cab.passport.awards.model.AwardsClassifyDto;
import com.cab.passport.awards.model.AwardsDto;
import com.cab.passport.awards.model.AwardsRequestDto;
import com.cab.passport.awards.model.AwardsResponseDto;
import com.cab.passport.awards.model.AwardsWinnerDto;
import com.cab.passport.common.ResultEnum;
import com.cab.passport.common.ResultVo;
import com.cab.passport.common.ResultVoUtil;
import com.thinkgem.jeesite.common.utils.JedisUtils;

@Service
@Transactional(readOnly = true)
public class AwardsWinnerService {
	
	@Autowired
	private AwardsClassifyDao awardsClassifyDao;
	
	@Autowired
	private AwardsWinnerDao awardsWinnerDao;
	
	private static final Logger log = LoggerFactory.getLogger(AwardsWinnerService.class);
	
	private static final String RDS_AWARDS_CLASSIFY_LIST = "rds_awards_classify_list_";
	
	private static final String RDS_AWARDS_WINNER_LIST = "rds_awards_winner_list_";
	
	private static final String RDS_AWARDS_WINNER_DETAIL = "rds_awards_winner_detail_";
	
	private static final int RDS_COMMON_TIMEOUT = 7200;
	
	public ResultVo<AwardsResponseDto> list(AwardsRequestDto request) {
		//如果机构类型为空，则默认CKU
		if(StringUtils.isBlank(request.getOrganization())) {
			request.setOrganization("CKU");
		}
		AwardsResponseDto result = new AwardsResponseDto();
		//奖项分类初始化
		List<AwardsClassifyDto> classifys = new ArrayList<>();
		Object rdsClassifys = JedisUtils.getObject(RDS_AWARDS_CLASSIFY_LIST+request.getOrganization().toLowerCase());
		if(Objects.isNull(rdsClassifys)) {
			List<AwardsClassify> classifyList = awardsClassifyDao.selectListByOrganization(request.getOrganization());
			if(!CollectionUtils.isEmpty(classifyList)) {
				classifys = classifyList.stream().map(entity->{
					AwardsClassifyDto classifyDto = new AwardsClassifyDto();
					classifyDto.setClassifyId(entity.getId());
					classifyDto.setClassifyName(entity.getClassifyName());
					classifyDto.setOrganization(entity.getOrganization());
					classifyDto.setSort(entity.getSort());
					return classifyDto;
				}).collect(Collectors.toList());
				classifys.sort((x, y) -> Integer.compare(x.getSort(), y.getSort()));
				
				JedisUtils.setObject(RDS_AWARDS_CLASSIFY_LIST+request.getOrganization().toLowerCase(),classifys,RDS_COMMON_TIMEOUT);
			}
			else {
				return ResultVoUtil.error(ResultEnum.ERROR.getRc(),"奖项分类未查询到数据");
			}
		}
		else {
			log.info("================awards_classifys_list==============从rds中获取=====");
			classifys = (List<AwardsClassifyDto>) rdsClassifys;
		}
		
		//奖项及得奖人列表 初始化
		List<AwardsDto> awards = new ArrayList<>();
		String classifId = StringUtils.isEmpty(request.getClassifyId())?classifys.get(0).getClassifyId():request.getClassifyId();
		Object rdsAwards = JedisUtils.getObject(RDS_AWARDS_WINNER_LIST+request.getOrganization().toLowerCase()+"_"+classifId);
		if(Objects.isNull(rdsAwards)) {
			List<AwardsWinner> winnerList = awardsWinnerDao.selectListByClassifyId(classifId);
			if(!CollectionUtils.isEmpty(winnerList)) {
				//按awardsId分组
				Map<String, List<AwardsWinner>> winnerMap = winnerList.stream().collect(Collectors.groupingBy(entity -> entity.getAwardId()));
				winnerMap.forEach((awardId,winners) -> {
					if(!CollectionUtils.isEmpty(winners)) {
						AwardsWinner tmp = winners.get(0);
						AwardsDto awardsDto = new AwardsDto();
						awardsDto.setAwardId(awardId);
						awardsDto.setAwardName(tmp.getAwardName());
						awardsDto.setClassifId(classifId);
						awardsDto.setWinnerType(tmp.getWinnerType());
						awardsDto.setSort(tmp.getAwardSort());
						awardsDto.setWinners(winners.stream().map(entity->{
							AwardsWinnerDto winner = new AwardsWinnerDto();
							winner.setAwardId(entity.getAwardId());
							winner.setAwardName(entity.getAwardName());
							winner.setWinnerId(entity.getId());
							winner.setWinnerName(entity.getWinnerName());
							winner.setWinnerType(entity.getWinnerType());
							winner.setMianImageUrl(entity.getMainImageUrl());
							winner.setMianVideoUrl(entity.getMainVideoUrl());
							winner.setDetailFlag(entity.isDetailFlag());
							winner.setSort(entity.getSort());
							return winner;
						}).collect(Collectors.toList()));
						awardsDto.getWinners().sort((x, y) -> Integer.compare(x.getSort(), y.getSort()));
						awards.add(awardsDto);
					}
				});
				awards.sort((x, y) -> Integer.compare(x.getSort(), y.getSort()));
				JedisUtils.setObject(RDS_AWARDS_WINNER_LIST+request.getOrganization().toLowerCase()+"_"+classifId,awards,RDS_COMMON_TIMEOUT);
			}
		}
		else {
			log.info("================awards_winners_list==============从rds中获取=====");
			awards.addAll((List<AwardsDto>)rdsAwards);
		}
	
		result.setClassifys(classifys);
		result.setAwards(awards);
		return ResultVoUtil.success(result);
	}
	
	public ResultVo<AwardsWinnerDto> detail(AwardsRequestDto request) {
		if(StringUtils.isBlank(request.getWinnerId())) {
			return ResultVoUtil.error(ResultEnum.ERROR.getRc(),"获奖人ID不能为空");
		}
		Object rdsWinner = JedisUtils.getObject(RDS_AWARDS_WINNER_DETAIL + request.getWinnerId());
		AwardsWinnerDto result = new AwardsWinnerDto();
		if(Objects.isNull(rdsWinner)) {
			AwardsWinner entity = awardsWinnerDao.selectById(request.getWinnerId());
			if(Objects.nonNull(entity)) {
				result.setAwardId(entity.getAwardId());
				result.setAwardName(entity.getAwardName());
				result.setDetailFlag(entity.isDetailFlag());
				result.setWinnerId(entity.getId());//id
				result.setWinnerIntroduction(entity.getWinnerIntroduction());//简介
				result.setWinnerName(entity.getWinnerName());//名称
				result.setWinnerReason(entity.getWinnerReason());
				result.setWinnerType(entity.getWinnerType());
				result.setMianImageUrl(entity.getMainImageUrl());
				result.setMianVideoUrl(entity.getMainVideoUrl());
				result.setChildImages(StringUtils.isBlank(entity.getChildImages())?null:Arrays.asList(entity.getChildImages().split(",")));
				result.setSort(entity.getSort());
				JedisUtils.setObject(RDS_AWARDS_WINNER_DETAIL+request.getWinnerId(),result,RDS_COMMON_TIMEOUT);
			}
		}
		else {
			result = (AwardsWinnerDto) rdsWinner;
		}
		return ResultVoUtil.success(result);
	}
}
