
package com.cab.passport.tcbpetorder.vo;

import java.io.Serializable;
import java.util.Date;

import javax.validation.constraints.NotNull;

import org.hibernate.validator.constraints.Length;

import com.fasterxml.jackson.annotation.JsonFormat;

public class TcbPetOrderVO implements Serializable {

	private static final long serialVersionUID = 1L;
	private String tmallOrderCode; // 天猫订单号
	private Date orderTime; // 下单时间
	private String petName; // 宠物名称
	private String petGender; // 宠物性别
	private String petBirthday; // 宠物生日
	private String petCoatColor; // 宠物毛色
	private String petBreed; // 宠物品种
	private String identificationFlag; // 芯片号
	private String cabPassport; // 护照号
	private Date produceDate; // 制作时间
	private String remarks; // 备注信息

	private String state; // 备注信息 0未采集 1已采集

	public String getState() {
		return state;
	}

	public void setState(String state) {
		this.state = state;
	}

	private String id;

	@Length(min = 1, max = 20, message = "天猫订单号长度必须介于 1 和 20 之间")
	public String getTmallOrderCode() {
		return tmallOrderCode;
	}

	public String getId() {
		return id;
	}

	public void setId(String id) {
		this.id = id;
	}

	public void setTmallOrderCode(String tmallOrderCode) {
		this.tmallOrderCode = tmallOrderCode;
	}

	@JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
	@NotNull(message = "下单时间不能为空")
	public Date getOrderTime() {
		return orderTime;
	}

	public void setOrderTime(Date orderTime) {
		this.orderTime = orderTime;
	}

	@Length(min = 1, max = 50, message = "宠物名称长度必须介于 1 和 50 之间")
	public String getPetName() {
		return petName;
	}

	public void setPetName(String petName) {
		this.petName = petName;
	}

	@Length(min = 1, max = 1, message = "宠物性别长度必须介于 1 和 1 之间")
	public String getPetGender() {
		return petGender;
	}

	public void setPetGender(String petGender) {
		this.petGender = petGender;
	}

	public String getPetBirthday() {
		return petBirthday;
	}

	public void setPetBirthday(String petBirthday) {
		this.petBirthday = petBirthday;
	}

	@Length(min = 1, max = 50, message = "宠物毛色长度必须介于 1 和 50 之间")
	public String getPetCoatColor() {
		return petCoatColor;
	}

	public void setPetCoatColor(String petCoatColor) {
		this.petCoatColor = petCoatColor;
	}

	@Length(min = 1, max = 50, message = "宠物品种长度必须介于 1 和 50 之间")
	public String getPetBreed() {
		return petBreed;
	}

	public void setPetBreed(String petBreed) {
		this.petBreed = petBreed;
	}

	@Length(min = 1, max = 20, message = "芯片号长度必须介于 1 和 20 之间")
	public String getIdentificationFlag() {
		return identificationFlag;
	}

	public void setIdentificationFlag(String identificationFlag) {
		this.identificationFlag = identificationFlag;
	}

	@Length(min = 1, max = 20, message = "护照号长度必须介于 1 和 20 之间")
	public String getCabPassport() {
		return cabPassport;
	}

	public void setCabPassport(String cabPassport) {
		this.cabPassport = cabPassport;
	}

	@JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
	@NotNull(message = "制作时间不能为空")
	public Date getProduceDate() {
		return produceDate;
	}

	public void setProduceDate(Date produceDate) {
		this.produceDate = produceDate;
	}

	public static long getSerialVersionUID() {
		return serialVersionUID;
	}

	public String getRemarks() {
		return remarks;
	}

	public void setRemarks(String remarks) {
		this.remarks = remarks;
	}
}