/*
 * Decompiled with CFR 0.152.
 */
package com.cku.util;

import com.cku.core.ZAException;
import com.cku.util.VeDate;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Random;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DateUtils {
    private static String previousDateTime;
    public static final SimpleDateFormat sdf;

    public static synchronized String getUniqueDateTime() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
        String dateTime = sdf.format(new Date());
        while (dateTime.equals(previousDateTime)) {
            dateTime = sdf.format(new Date());
        }
        previousDateTime = dateTime;
        return dateTime;
    }

    public static String getDateTimeZone() {
        return new SimpleDateFormat("yyyyMMddHHmmssS").format(new Date());
    }

    public static String getTimeZone() {
        return new SimpleDateFormat("HHmmssS").format(new Date());
    }

    public static String getCurrentDate(String format) {
        return new SimpleDateFormat(format).format(new Date());
    }

    public static String getDateTime() {
        return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date());
    }

    public static String getDateTime(Date date) {
        return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(date);
    }

    public static Timestamp getCurrentTimestamp() {
        return new Timestamp(System.currentTimeMillis());
    }

    public static String getDate() {
        return new SimpleDateFormat("yyyy-MM-dd").format(new Date());
    }

    public static String yestedayDate() {
        Calendar calendar = Calendar.getInstance();
        calendar.add(5, -1);
        String yestedayDate = new SimpleDateFormat("yyyy-MM-dd").format(calendar.getTime());
        return yestedayDate;
    }

    public static String getTime() {
        return new SimpleDateFormat("HH:mm:ss").format(new Date());
    }

    public static boolean isDateAfter(String timeString, long rating) {
        try {
            Date date = DateUtils.addDay(timeString, rating);
            Date now = new SimpleDateFormat("yyyy-MM-dd HH:mm").parse(new SimpleDateFormat("yyyy-MM-dd HH:mm").format(new Date()));
            long min = date.getTime();
            long nowmin = now.getTime();
            return nowmin - min > 600000L;
        }
        catch (ParseException e) {
            return false;
        }
    }

    public static boolean isAfter(String timeString, int rating) {
        try {
            Date date = new SimpleDateFormat("yyyy-MM-dd HH:mm").parse(timeString);
            Date now = new SimpleDateFormat("yyyy-MM-dd HH:mm").parse(new SimpleDateFormat("yyyy-MM-dd HH:mm").format(new Date()));
            long min = date.getTime();
            long nowmin = now.getTime();
            long count = rating * 60 * 1000;
            return nowmin - min > count;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean isBefore(String timeString, int rating) {
        try {
            Date date = new SimpleDateFormat("yyyy-MM-dd HH:mm").parse(timeString);
            Date now = new SimpleDateFormat("yyyy-MM-dd HH:mm").parse(new SimpleDateFormat("yyyy-MM-dd HH:mm").format(new Date()));
            long min = date.getTime();
            long nowmin = now.getTime();
            return nowmin - min < (long)(rating * 60 * 1000);
        }
        catch (Exception e) {
            return false;
        }
    }

    public static String formatDate(Date dDate, String sFormat) {
        SimpleDateFormat formatter = new SimpleDateFormat(sFormat);
        String dateString = formatter.format(dDate);
        return dateString;
    }

    public static String dateToString(Date dDate) {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
        String dateString = formatter.format(dDate);
        return dateString;
    }

    public static String dateTimeToString(Date dDate) {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String dateString = formatter.format(dDate);
        return dateString;
    }

    public static Date toDate(Date dDate) {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
        String dateString = formatter.format(dDate);
        return DateUtils.strToDate(dateString, "yyyy-MM-dd");
    }

    public static Date toDatetime(Date dDate) {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String dateString = formatter.format(dDate);
        return DateUtils.strToDate(dateString, "yyyy-MM-dd HH:mm:ss");
    }

    public static Date strToDate(String s, String pattern) {
        SimpleDateFormat formatter = new SimpleDateFormat(pattern);
        try {
            Date theDate;
            Date date = theDate = formatter.parse(s);
            return date;
        }
        catch (Exception ex) {
            Date date1 = null;
            return date1;
        }
    }

    public static Date strToDateFormat(String s) {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        try {
            Date theDate;
            Date date = theDate = formatter.parse(s);
            return date;
        }
        catch (Exception ex) {
            Date date1 = null;
            return date1;
        }
    }

    public static Date strToDate(String s) {
        return DateUtils.strToDate(s, "yyyy-MM-dd HH:mm:ss");
    }

    public static Date addMinute(String sDate, long iNbTime) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(DateUtils.strToDate(sDate, "yyyy-MM-dd HH:mm"));
        cal.add(12, (int)iNbTime);
        Date date = cal.getTime();
        return date;
    }

    public static Date addHour(String sDate, long iNbTime) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(DateUtils.strToDate(sDate, "yyyy-MM-dd HH:mm"));
        cal.add(11, (int)iNbTime);
        Date date = cal.getTime();
        return date;
    }

    public static Date addDay(String sDate, long iNbDay) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(DateUtils.strToDate(sDate, "yyyy-MM-dd HH:mm"));
        cal.add(5, (int)iNbDay);
        Date result = cal.getTime();
        return result;
    }

    public static Date addDay(long iNbDay) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(new Date());
        cal.add(5, (int)iNbDay);
        Date result = cal.getTime();
        return result;
    }

    public static Date addWeek(String sDate, long iNbWeek) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(DateUtils.strToDate(sDate, "yyyy-MM-dd HH:mm"));
        cal.add(3, (int)iNbWeek);
        Date result = cal.getTime();
        return result;
    }

    public static Date addMonth(String sDate, int iNbMonth) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(DateUtils.strToDate(sDate, "yyyy-MM-dd HH:mm"));
        int month = cal.get(2);
        int year = (month += iNbMonth) / 12;
        cal.set(2, month %= 12);
        if (year != 0) {
            int oldYear = cal.get(1);
            cal.set(1, year + oldYear);
        }
        return cal.getTime();
    }

    public static Date addYear(Date dDate, int iNbYear) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(dDate);
        int oldYear = cal.get(1);
        cal.set(1, iNbYear + oldYear);
        return cal.getTime();
    }

    public static int getWeek(Date dDate) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(dDate);
        return cal.get(7) - 1;
    }

    public static String getWeeks() {
        String[] dayNames = new String[]{"\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd", "\ufffd\ufffd\ufffd\ufffd\u04bb", "\ufffd\ufffd\ufffd\u06b6\ufffd", "\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd", "\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd", "\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd", "\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd"};
        SimpleDateFormat sdfInput = new SimpleDateFormat("yyyy-MM-dd HH:mm");
        Calendar calendar = Calendar.getInstance();
        Date date = new Date();
        try {
            date = sdfInput.parse(sdfInput.format(date));
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        calendar.setTime(date);
        int dayOfWeek = calendar.get(7);
        System.out.println("dayOfWeek:" + dayOfWeek);
        return dayNames[dayOfWeek - 1];
    }

    public static String getWeek(String sdate) {
        Date date = VeDate.strToDate(sdate);
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        return new SimpleDateFormat("EEEE").format(c.getTime());
    }

    public static int getMonthOfDay(Date dDate) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(dDate);
        return cal.get(5);
    }

    public static void main(String[] gta) {
    }

    public static String genRandomNum(int pwd_len) {
        int maxNum = 36;
        int count = 0;
        char[] str = new char[]{'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9'};
        StringBuffer pwd = new StringBuffer("");
        Random r = new Random();
        while (count < pwd_len) {
            int i = Math.abs(r.nextInt(36));
            if (i < 0 || i >= str.length) continue;
            pwd.append(str[i]);
            ++count;
        }
        return pwd.toString();
    }

    public static String genRandNum(int pwd_len) {
        int maxNum = 36;
        int count = 0;
        char[] str = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9'};
        StringBuffer pwd = new StringBuffer("");
        Random r = new Random();
        while (count < pwd_len) {
            int i = Math.abs(r.nextInt(36));
            if (i < 0 || i >= str.length) continue;
            pwd.append(str[i]);
            ++count;
        }
        return pwd.toString();
    }

    public static boolean isCurrentWeek(Timestamp ts) {
        long l;
        long d;
        long t;
        long c = DateUtils.getCurrentTimestamp().getTime();
        return (c - (t = ts.getTime())) / (d = (l = 1000L) * 60L * 60L * 24L * 7L) < 1L;
    }

    public static Map<Integer, Integer> getYearMap() {
        LinkedHashMap<Integer, Integer> yearMap = new LinkedHashMap<Integer, Integer>();
        for (int i = 2010; i <= 2020; ++i) {
            yearMap.put(i, i);
        }
        return yearMap;
    }

    public static Date getDate(Integer year, Integer month, Integer day) {
        Date date = new Date(year, month, day);
        return date;
    }

    public static Timestamp getBefore(Integer days) {
        Calendar calendar = Calendar.getInstance();
        calendar.add(5, days);
        String date = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss").format(calendar.getTime());
        Timestamp ts = Timestamp.valueOf(date);
        return ts;
    }

    public static boolean isInXMounth(Date date1, Date date2, int x) throws ZAException {
        if (date1 == null || date2 == null) {
            throw new ZAException(-1, "\u65e5\u671f\u4e3a\u7a7a");
        }
        if (x < 1) {
            throw new ZAException(-1, "\u6708\u4efd\u6570\u5fc5\u987b\u4e3a\u5927\u4e8e1\u7684\u6b63\u6574\u6570");
        }
        try {
            date1 = sdf.parse(sdf.format(date1));
            date2 = sdf.parse(sdf.format(date2));
        }
        catch (ParseException e) {
            throw new ZAException(-1, "\u65e5\u671f\u6709\u8bef");
        }
        Calendar startDateCalendar = Calendar.getInstance();
        Calendar endDateCalendar = Calendar.getInstance();
        if (date1.before(date2)) {
            startDateCalendar.setTime(date1);
            endDateCalendar.setTime(date2);
        } else {
            startDateCalendar.setTime(date2);
            endDateCalendar.setTime(date1);
        }
        int year = endDateCalendar.get(1) - startDateCalendar.get(1);
        int month = endDateCalendar.get(2) - startDateCalendar.get(2);
        if (year * 12 + month < x) {
            return true;
        }
        if (year * 12 + month == x) {
            return endDateCalendar.get(5) < startDateCalendar.get(5);
        }
        return false;
    }

    static {
        sdf = new SimpleDateFormat("yyyy-MM-dd");
    }
}

