/*
 * Decompiled with CFR 0.152.
 */
package com.cku.util;

import com.cku.core.RESTResponse;
import com.cku.core.ZAException;
import com.cku.util.Debugger;
import com.cku.util.PageBean;
import com.cku.util.PathUtils;
import com.cku.util.StreamUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ServletUtils {
    public static boolean isHttps(HttpServletRequest r) {
        return true;
    }

    public static void writeResponse(HttpServletResponse response, RESTResponse r) throws IOException {
        response.setHeader("Content-type", "application/json;charset=UTF-8");
        response.setHeader("Access-Control-Allow-Origin", "*");
        response.setHeader("Access-Control-Allow-Credentials", "true");
        response.setHeader("Access-Control-Allow-Methods", "POST, GET, PUT, DELETE");
        response.setHeader("Access-Control-Allow-Headers", "Content-Type, Content-Length, Connection, Cache-Control");
        StreamUtils.writeStream((OutputStream)response.getOutputStream(), r);
        if (r.getRc() != 0L) {
            response.setStatus(200);
        }
        response.flushBuffer();
    }

    public static String getParameter(HttpServletRequest r, String paramName, String defaultVal) {
        String p = r.getParameter(paramName);
        if (p == null) {
            return defaultVal;
        }
        return p;
    }

    public static String getParameter(HttpServletRequest r, String paramName) throws ZAException {
        String p = r.getParameter(paramName);
        Debugger.doAssert(p != null, -9, String.format("paremeter '%s' was not found", paramName), new Object[0]);
        return p;
    }

    public static String getHeader(HttpServletRequest r, String paramName) throws ZAException {
        String p = r.getHeader(paramName);
        return p;
    }

    public static Long getParameterLong(HttpServletRequest r, String paramName, Long defaultVal) {
        String p = r.getParameter(paramName);
        if (p == null) {
            return defaultVal;
        }
        try {
            return Long.parseLong(p);
        }
        catch (Exception e) {
            return defaultVal;
        }
    }

    public static long getParameterLong(HttpServletRequest r, String paramName) throws ZAException {
        String p = r.getParameter(paramName);
        Debugger.doAssert(p != null, -9, String.format("paremeter '%s' was not found", paramName), new Object[0]);
        return Long.parseLong(p);
    }

    public static Integer getParameterInt(HttpServletRequest r, String paramName, Integer defaultVal) {
        String p = r.getParameter(paramName);
        if (p == null) {
            return defaultVal;
        }
        try {
            return Integer.parseInt(p);
        }
        catch (Exception e) {
            return defaultVal;
        }
    }

    public static Integer getParameterInt(HttpServletRequest r, String paramName) throws ZAException {
        String p = r.getParameter(paramName);
        Debugger.doAssert(p != null, -9, String.format("paremeter '%s' was not found", paramName), new Object[0]);
        return Integer.parseInt(p);
    }

    public static PageBean getParameterBean(HttpServletRequest request) {
        Long limit = ServletUtils.getParameterLong(request, "limit", Long.MAX_VALUE);
        Long page = ServletUtils.getParameterLong(request, "page", 1L);
        int needCount = ServletUtils.getParameterInt(request, "needCount", 1);
        return new PageBean(page, limit, needCount == 1);
    }

    public static PageBean getParameterBeanWith10(HttpServletRequest request) {
        Long limit = ServletUtils.getParameterLong(request, "limit", 10L);
        Long page = ServletUtils.getParameterLong(request, "page", 1L);
        int needCount = ServletUtils.getParameterInt(request, "needCount", 1);
        return new PageBean(page, limit, needCount == 1);
    }

    public static void writeResponse(HttpServletResponse response, String localPath, String name) throws IOException {
        File f = new File(localPath);
        long size = f.length();
        FileInputStream fis2 = new FileInputStream(localPath);
        try {
            int reads;
            ServletOutputStream os = response.getOutputStream();
            byte[] bytes = new byte[65536];
            String fName2 = name + PathUtils.getFileExtension(localPath);
            String attachName = new String(fName2.getBytes("GB2312"), "ISO_8859_1");
            response.addHeader("Content-Disposition", "attachment;filename=" + new String(attachName));
            response.addHeader("Content-Length", "" + size);
            response.setContentType("application/octet-stream");
            while ((reads = ((InputStream)fis2).read(bytes)) >= 0) {
                os.write(bytes, 0, reads);
            }
            os.flush();
        }
        catch (Exception e) {
            response.reset();
            throw new IOException(e);
        }
        finally {
            try {
                ((InputStream)fis2).close();
            }
            catch (Exception exception) {}
        }
    }
}

