/*
 * Decompiled with CFR 0.152.
 */
package com.cku.patchca.background;

import com.cku.patchca.background.BackgroundFactory;
import com.cku.patchca.color.ColorFactory;
import com.cku.patchca.color.SingleColorFactory;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.image.BufferedImage;

public class SingleColorBackgroundFactory
implements BackgroundFactory {
    private ColorFactory colorFactory;

    public SingleColorBackgroundFactory() {
        this.colorFactory = new SingleColorFactory(Color.WHITE);
    }

    public SingleColorBackgroundFactory(Color color) {
        this.colorFactory = new SingleColorFactory(color);
    }

    public void setColorFactory(ColorFactory colorFactory) {
        this.colorFactory = colorFactory;
    }

    public void fillBackground(BufferedImage dest) {
        Graphics g = dest.getGraphics();
        g.setColor(this.colorFactory.getColor(0));
        g.fillRect(0, 0, dest.getWidth(), dest.getHeight());
    }
}

