import { Toast } from 'antd-mobile';
import { certificates } from '../services/index';

const COMMON_STATE = {
  data: {},
};
export default {
  state: COMMON_STATE,
  reducers: {
    clearState(state, { payload }) {
      return { ...COMMON_STATE };
    },
    updateState(state, { payload }) {
      return { ...state, ...payload };
    },
  },
  effects: {
    *certificates({ payload }, { call, put, select }) {
      const { rc, msg, data } = yield call(certificates, { ...payload });
      if (rc === 0) {
        yield put({
          type: 'updateState',
          payload: {
            data,
          },
        });
      } else {
        Toast.fail(msg, 2);
      }
    },
  },
  subscriptions: {
    // setupHistory({ dispatch, history }) {
    //   history.listen(location => {});
    // },
  },
};
