import React, { Component } from 'react';
import { connect } from 'react-redux';
import { Toast } from 'antd-mobile';
import DocumentTitle from 'react-document-title';
import styles from './index.less';
import canvsBg from '../assets/canvasBg.png';

class index extends Component {
  state = {
    memberName: '',
    issueDate: '',
  };
  componentWillMount = () => {
    let data = sessionStorage.getItem('appreciationInfo') || ''
    let info = JSON.parse(data)
    if(data != ''){
      this.setState({
        issueDate: info.issueDate.split('-')[0],
        memberName: info.memberName,
      })
    }

  };
  componentDidMount = () => {};
  componentWillUnmount = () => {};
  bindClick(){
    Toast.loading('生成中', 0, null, true);
    var c = document.getElementById("myCanvas");
    var ctx = c.getContext("2d");
    var img = document.getElementById("img");
    ctx.drawImage(img,0,0,2481,3508);
    // 姓名
    var memberName = this.state.memberName;
    ctx.font = "120px bold 黑体";
    ctx.fillStyle="#C78826";
    ctx.fillText(memberName, 1300, 1760);
    // 年份
    var issueDate = this.state.issueDate;
    ctx.font = "80px bold 黑体";
    ctx.fillText(issueDate, 1115, 2020);
    // 年份2
    var enIssueDate = this.state.issueDate;
    ctx.font = "50px bold 黑体";
    ctx.fillStyle="#707172";
    ctx.fillText(enIssueDate, 1272, 2400);

    var image = new Image();
    image.crossOrigin = 'anonymous'
    let imgUrl = c.toDataURL("image/png");
    if (/(iPhone|iPad|iPod|iOS)/i.test(navigator.userAgent)) {
      Toast.hide();
      window.webkit.messageHandlers.downloadImg.postMessage({
        imgUrl: imgUrl
      })
    } else {
      Toast.hide();
      window.js.downloadImg(imgUrl)
    }
  }
  render() {
    return (
      <DocumentTitle title="纯种犬猫鉴赏证书">
        <div className={styles.body}>
          <div className={styles.imgBoxx}>
            <div className={styles.name}>{this.state.memberName}</div>
            <div className={styles.year}>{this.state.issueDate}</div>
            <div className={styles.enYear}>{this.state.issueDate}</div>
            <div className={styles.btn} onClick={this.bindClick.bind(this)}>点击保存高清图片</div>
            <div className={styles.none}>
              <canvas id="myCanvas" height="3508px" width="2481px"></canvas>
              <img id="img" src={canvsBg} alt="" />
              <div className={styles.btn} >点击保存高清图片</div>
            </div>
          </div>
        </div>
      </DocumentTitle>
    );
  }
}

export default index;
