import React, { Component } from 'react';
import { connect } from 'react-redux';
import DocumentTitle from 'react-document-title';
import styles from './index.less';


@connect(({ certificates }) => ({ certificates }))
class index extends Component {
  state = {};
  componentWillMount = () => {
    const { id, club, token } = this.props.location.query;
    if(token){
      sessionStorage.setItem('token', token)
      sessionStorage.setItem('club', club)
    }
    this.props.dispatch({
      type: 'certificates/certificates',
      payload: {},
    });
  };
  componentDidMount = () => {};
  componentWillUnmount = () => {};
  openInfo(item){
    let data = JSON.stringify(item)
    sessionStorage.setItem('appreciationInfo', data)
    this.props.history.push('/appreciation/info');
  }
  render() {
    const { data } = this.props.certificates;
    return (
      <DocumentTitle title="纯种犬猫鉴赏证书">
        <div className={styles.body}>
          <div className={styles.list}>
            {
              data && data.length > 0 ?
              data.map((item, index) => 
                <div className={styles.item}  key={item.certificateCode} onClick={this.openInfo.bind(this, item)}>
                  <div className={styles.top}>
                    <div className={styles.img}></div>
                  </div>  
                  <div className={styles.bottom}>
                    <div className={styles.h3}>{item.courseName}</div>
                    <div className={styles.p}>{item.courseStartDate}至{item.courseEndDate}</div>
                  </div>
                </div>
              )
              :
              <div className={styles.normal}>
                <div className={styles.icon}></div>
                <div className={styles.p}>暂无证书</div>
              </div>
            }
          </div>
        </div>
      </DocumentTitle>
    );
  }
}

export default index;
