<!--配种证明添加页-->
define(["knockout"],function(ko){
    return function(context){
        var me = this;
        //我的狗列表
        me.myDogB = ko.observableArray([]);
        me.myDogG = ko.observableArray([]);
        //会员信息
        me.memberMsg = ko.observable(userInfo.getMember());
        me.member = ko.observable({});
        //血统证书号 公
        me.malePedigreeCertified = ko.observable("");
        //血统证书号 母
        me.femalePedigreeCertified = ko.observable("");
        //是否加急 默认“是”
        me.urgent = ko.observable("0");
        //配种日期
        me.breedDate = ko.observable("")
        //根据血统证书号查出来的狗信息
        //公狗信息
        me.mydog = ko.observable({});
        //母狗信息
        me.myFemaleDog = ko.observable({});
        //价格
        me.price = ko.observable("0");
        //修改时是否加急
        me.urgentAmend = ko.observable({});
        me.urgentAmend().urgent = "0";
        //是否为修改页
        me.isRepair = ko.observable({});
        //添加
        me.isRepair().text = "1";
        //查询我的狗列表
        me.findMyDogListB = function(){
            util.sendAjax({
                url:'dog/dogByGenderAll',
                data:{"gender":1},
                async:false,
                loadFlag:true,
                type:'GET',
                cache:false,
                success:function(json){
                    if(json.rc==0){
                        me.myDogB(json.list);
                    }else{
                        layer.msg(json.msg);
                    }
                }
            });
        }
        //显示下拉框
        me.showDogDivB = function(e){
        	if($("#dogDivB").css("display")=="none"){
                $("#dogDivB").css("display","block");
                $("#dogDivG").css("display","none");
            }else{
                $("#dogDivB").css("display","none");
            }
            var e = event || window.event;
            if(e.stopPropagation){
                e.stopPropagation();
            }else{
                window.event.cancelBubble = true;
            }
        }
        //选择血统证书号
        me.checkDogB = function(pedigreeCertifiedCode,data,event){
            me.malePedigreeCertified(pedigreeCertifiedCode);
            $("#dogDivB").css("display","none");
            var event = event || window.event;
            if(event.stopPropagation){
                event.stopPropagation();
            }else{
                window.event.cancelBubble = true;
            }
        }
      //查询我的狗列表
        me.findMyDogListG = function(){
            util.sendAjax({
                url:'dog/dogByGenderAll',
                data:{"gender":2},
                async:false,
                loadFlag:true,
                type:'GET',
                cache:false,
                success:function(json){
                    if(json.rc==0){
                        me.myDogG(json.list);
                    }else{
                        layer.msg(json.msg);
                    }
                }
            });
        }
      //显示下拉框
        me.showDogDivG = function(e){
            if($("#dogDivG").css("display")=="none"){
                $("#dogDivG").css("display","block");
                $("#dogDivB").css("display","none");
            }else{
                $("#dogDivG").css("display","none");
            }
            var e = event || window.event;
            if(e.stopPropagation){
                e.stopPropagation();
            }else{
                window.event.cancelBubble = true;
            }
        }
      //选择血统证书号
        me.checkDogG = function(pedigreeCertifiedCode,data,event){
            me.femalePedigreeCertified(pedigreeCertifiedCode);
            $("#dogDivG").css("display","none");
            var event = event || window.event;
            if(event.stopPropagation){
                event.stopPropagation();
            }else{
                window.event.cancelBubble = true;
            }
        }
        //修改后的返回信息
        me.getAmendMsg = function(msg){
            me.malePedigreeCertified(msg.malePedigreeCertified);
            me.getMalePedigreeCertified();
            me.femalePedigreeCertified(msg.femalePedigreeCertified);
            me.getFemalePedigreeCertified();
            me.urgent(msg.urgent);
            me.breedDate(msg.breedDate);
            me.getPrice();
        }
        //是否加急
        me.isUrgent=function(data,event){
            var obj = util.getQueryString();
            if(obj.malePedigreeCertified){
                return false;
            }
            $(event.target).attr("class","radio").siblings("a").removeAttr("class");
            if($(event.target).index()==0){
                me.urgent(1);
            }else{
                me.urgent(0);
            }
            me.getPrice();
        }
        //是否展开注意事项
        me.isOpen = ko.observable(false);
        me.isShow = function(){
            me.isOpen(!me.isOpen());
        }
        /**
         * 血统证书列表查询方法
         */
        //公犬查询
        me.getMalePedigreeCertified = function(){
            var sendData = {};
            sendData["pedigreeCertifiedCode"] = me.malePedigreeCertified();
            if(util.checkIsCKU(me.malePedigreeCertified())==0){
                layer.msg("非CKU开头的犬只不可以申请配种证明！");
                return;
            };
            util.sendAjax({
                url:'dog/dog/getOneByPedigreeCertified',
                data:sendData,
                async:true,
                loadFlag:true,
                type:'GET',
                cache:false,
                success:function(json){
                    if(json.rc==0){
                        if(json.data!=null){
                            if(json.data.memberCode==me.memberMsg().memberCode){
                                if(json.data.gender=="1"){
                                    me.mydog(json.data);
                                }else if(json.data.gender=="2"){
                                    layer.msg("性别不符，请输入正确的证书号！");
                                    me.mydog({});
                                    me.malePedigreeCertified("");
                                }
                            }else{
                                layer.msg("该犬只不在您名下，无法申请该业务！");
                                me.mydog({});
                            }
                        }else{
                            layer.msg("该犬只不在您名下，无法申请该业务！");
                            me.mydog({});
                        }
                    }else{
                        layer.msg("公犬信息查询失败:"+json.msg);
                    }
                }
            });
        }
        //母犬查询
        me.getFemalePedigreeCertified = function(){
            var sendData = {};
            sendData["pedigreeCertifiedCode"] = me.femalePedigreeCertified();
            if(util.checkIsCKU(me.femalePedigreeCertified())==0){
                layer.msg("非CKU开头的犬只不可以申请配种证明！");
                return;
            };
            util.sendAjax({
                url:'dog/dog/getOneByPedigreeCertified',
                data:sendData,
                async:true,
                loadFlag:true,
                type:'GET',
                cache:false,
                success:function(json){
                    if(json.rc==0){
                        if(json.data!=null){
                            if(json.data.gender=="2"){
                                me.myFemaleDog(json.data);
                            }else if(json.data.gender=="1"){
                                layer.msg("性别不符，请输入正确的证书号！");
                                me.myFemaleDog({});
                                me.femalePedigreeCertified("");
                            }
                        }else{
                            layer.msg("找不到犬只信息，请核对血统证书号是否正确!");
                            me.myFemaleDog({});
                        }
                    }else{
                        layer.msg("母犬信息查询失败:"+json.msg);
                    }
                }
            });

        }
        /**
         * 保存
         */
        me.saveCart = function(){
            var endTime = new Date(new Date(util.formatDateLong(me.memberMsg().memberEndDate).replace(/-/g,"/"))).getTime()+86399000 - new Date().getTime();
            if(endTime>=0&&me.memberMsg().memberType=="professional") {
                var sendData = {};
                var malePedigreeCertified = me.malePedigreeCertified();
                if (util.isVal(malePedigreeCertified) == "") {
                    layer.msg("公犬血统证书号不能为空！");
                    return;
                }
                var femalePedigreeCertified = me.femalePedigreeCertified();
                if (util.isVal(femalePedigreeCertified) == "") {
                    layer.msg("母犬血统证书号不能为空！");
                    return;
                }
                if(util.checkIsCKU(femalePedigreeCertified)==0){
                    layer.msg("非CKU开头的犬只不可以申请配种证明！");
                    return;
                };
                if(util.checkIsCKU(malePedigreeCertified)==0){
                    layer.msg("非CKU开头的犬只不可以申请配种证明！");
                    return;
                };
                var breedDate = $("#breedDate").val();
                if (util.isVal(breedDate) == "") {
                    layer.msg("配种日期不能为空！");
                    return;
                }
                sendData["malePedigreeCertified"] = me.malePedigreeCertified();
                sendData["femalePedigreeCertified"] = me.femalePedigreeCertified();
                sendData["urgent"] = me.urgent();
                sendData["breedDate"] = $("#breedDate").val();
                util.sendAjax({
                    url: 'dog/dognewborn',
                    data: JSON.stringify(sendData),
                    async: true,
                    loadFlag: true,
                    type: 'POST',
                    cache: false,
                    success: function (json) {
                        if (json.rc == 0) {
                            context.app.changeCart();
                            layer.alert('业务添加成功，是否跳转到业务核对页面进行支付？', {
                                time: 0 //不自动关闭
                                , btn: ['跳转', '取消']
                                , yes: function (index) {
                                    layer.close(index);
                                    location.href = location.href.split("#")[0] + "#/order/check";
                                }
                            });
                        } else {
                            layer.msg("配种证明申请失败:" + json.msg);
                        }
                    }
                });
            }else{
                layer.msg("该业务仅限有效专业会员办理!");
            }
        }
        /**
         * 发送修改
         */
        me.saveRepair = function() {
            var sendData = {};
            var malePedigreeCertified = me.malePedigreeCertified();
            if (util.isVal(malePedigreeCertified) == "") {
                layer.msg("公犬血统证书号不能为空！");
                return;
            }
            var femalePedigreeCertified = me.femalePedigreeCertified();
            if (util.isVal(femalePedigreeCertified) == "") {
                layer.msg("母犬血统证书号不能为空！");
                return;
            }
            if(util.checkIsCKU(femalePedigreeCertified)==0){
                layer.msg("非CKU开头的犬只不可以申请配种证明！");
                return;
            };
            if(util.checkIsCKU(malePedigreeCertified)==0){
                layer.msg("非CKU开头的犬只不可以申请配种证明！");
                return;
            };
            var breedDate = $("#breedDate").val();
            if (util.isVal(breedDate) == "") {
                layer.msg("配种日期不能为空！");
                return;
            }
            sendData["malePedigreeCertified"] = me.malePedigreeCertified();
            sendData["femalePedigreeCertified"] = me.femalePedigreeCertified();
            sendData["breedDate"] = $("#breedDate").val();
            var obj = util.getQueryString();
            sendData["id"] = obj.id;
            util.sendAjax({
                url: 'dog/dognewborn',
                data: JSON.stringify(sendData),
                async:true,
                loadFlag:true,
                type: 'PUT',
                cache: false,
                success: function (json) {
                    if (json.rc == 0) {
                        layer.msg("修改成功！");
                        location.href = location.href.split("#")[0]+"#/dog/dognewbornlist"
                    } else {
                        layer.msg("修改失败:"+json.msg);
                    }
                }
            });
        }
        //配种证明订单金额
        me.getPrice = function(){
            var payData = {};
            payData["urgent"] = me.urgent();

            var malePedigreeCertified = me.malePedigreeCertified();
            if (util.isVal(malePedigreeCertified) == "") {
                layer.msg("公犬血统证书号不能为空！");
                return;
            }
            var femalePedigreeCertified = me.femalePedigreeCertified();
            if (util.isVal(femalePedigreeCertified) == "") {
                layer.msg("母犬血统证书号不能为空！");
                return;
            }
            payData["malePedigreeCertified"] = malePedigreeCertified;
            payData["femalePedigreeCertified"] = femalePedigreeCertified;
            if(me.breedDate()==""){
                payData["breedDate"] = $("#breedDate").val();
            }else{
                payData["breedDate"] = me.breedDate();
            }
            util.sendAjax({
                url:'dog/dognewborn/getPrice',
                data:payData,
                async:true,
                loadFlag:true,
                type:'GET',
                cache:false,
                success:function(json){
                    if(json.rc ==0){
                        me.price(json.data["price"]);
                    }else{
                        layer.msg("获取价格失败:"+json.msg);
                    }
                }
            });
        }
        //改变配种日期
        me.changeDate = function(){
            var timer = setInterval(function(){
                if(me.breedDate()!=$("#breedDate").val()){
                    me.breedDate($("#breedDate").val());
                    clearInterval(timer);
                    me.getPrice();
                }
            },100)
        };
        $(function(){
            var obj = util.getQueryString();
            me.findMyDogListB();//查询我的狗列表
            me.findMyDogListG();//查询我的狗列表
            $(document).on("click",function(){
                $("#dogDivB").hide();
            })
            me.findMyDogListG();//查询我的狗列表
            $(document).on("click",function(){
                $("#dogDivG").hide();
            })
            if(obj.malePedigreeCertified){
                me.getAmendMsg(obj);
                
                if(obj.urgent=="1"){
                    me.urgentAmend().urgent = "1";
                }
                //修改
                me.isRepair().text = "2";
                $('#femalePedigreeCertifiedinp').attr("disabled",true);
            }
        });
        
        context.app.loading(false);
        context.app.isShop(false);
    }
});
