//出生证明添加页
define(["knockout"],function(ko){
    return function(context){
        var me = this;
        userInfo.refresh();
        //当前登陆人信息；
        var member = userInfo.getMember();
        me.member = ko.observable(member);
        var kennel = userInfo.getKennel();
        me.kennel = ko.observable(kennel);
        //列表数据
        me.listData = ko.observableArray([]);
        //配种证明编号
        me.breedCertifiedCode = ko.observable("");
        //每页多少条数据
        me.pageSize = ko.observable(10);
        //第几页
        me.pageNo = ko.observable(1);
        //页码列表
        me.pageArray = ko.observableArray();
        //上一页
        me.pagePre = function(){
            if(me.pageNo()>1){
                me.pageNo(me.pageNo()-1);
            }
            me.finddognewbornList(false);
        }

        me.pageNext = function(){
            if(me.pageNo()<parseInt(me.pageArray().pop()["pageNo"])){
                me.pageNo(me.pageNo()+1);
            }

            me.finddognewbornList(false);
        }

        me.pageAction = function(data){
            if(data.pageNo == -1){
                //什么都不做
            }else if(me.pageNo() == data.pageNo){
                //alert("当前选中的就是该页");
                me.finddognewbornList(false);
            }else{
                //alert(data.pageNo);//做一些分页啥的
                me.pageNo(data.pageNo);
                me.finddognewbornList(false);
            }
            return false;
        }
        //未通过原因的显示隐藏
        me.showReason = function(data,event){
            if(data.reviewState=="不通过"||data.reviewState=="未通过"){
                if($(event.target).parent("a").siblings(".reason").css("display")=="none"){
                    $(event.target).parent("a").siblings(".reason").css("display","block");
                }else{
                    $(event.target).parent("a").siblings(".reason").css("display","none");
                }
            }
        }
        me.closeReason = function(data,event){
            $(event.target).parents(".reason").css("display","none");
        }
        /**
         * 配种证明列表查询方法
         */
        me.finddognewbornList = function(isreset){
            if(isreset){
                me.pageNo(1);
            };
            var sendData = {};
            sendData["breedCertifiedCode"] = me.breedCertifiedCode().trim();
            sendData["pageSize"] = me.pageSize();
            sendData["pageNo"] = me.pageNo();
            util.sendAjax({
                url:'dog/dognewborn',
                data:sendData,
                async:true,
                loadFlag:true,
                type:'GET',
                cache:false,
                success:function(data){
                    if(data.rc==0){
                        if(data.list!=null && data.list.length>0) {
                            $.each(data.list,function(index,item){
                                if((item.mdogOwnerCode==me.member().memberCode&&(item.reviewState=="不通过"||item.reviewState=="未通过"))||(item.reviewState=='未审核')){
                                    item["manage"]="修改";
                                    item["manageClass"] = "repeal";
                                }else{
                                    item["manage"]="申请登记卡";
                                    if(item.birthday==""&&item.reviewState=="通过"){
                                        item["manageClass"] = "pending";
                                    }else{
                                        item["manageClass"] = "gray";
                                    }
                                }
                            })
                            me.listData(data.list);
                        }else{
                            me.listData([]);
                            layer.msg("配种证明列表为空！");
                        }
                        //计算总页数和分页的参数
                        me.pageArray(util.getPageArray(me.pageNo(), data.total, me.pageSize()));
                    }else{
                        layer.msg("信息查询失败:"+data.msg);
                    }
                }
            });

        }
        //申请出生纸 跳转
        me.sendMsg = function(data,event){
            var memberCode = me.member().memberCode;
            var fdogOwnerCode = data.fdogOwnerCode;
            if(data["birthday"]=="" && data.reviewState!=('不通过'||"未通过")){
                if(memberCode!=fdogOwnerCode){
                    layer.msg("只有母犬主可以申领登记卡！");
                }else{
                    var id = data.id;
                    location.href = location.href.split("#")[0]+"#/dog/birthcertificateapply?id="+id;
                }
            }
        }
        //修改 跳转
        me.amend = function(data,event){
            var malePedigreeCertified = data.malePedigreeCertified;
            var femalePedigreeCertified = data.femalePedigreeCertified;
            var urgent = data.urgent;
            var breedDate = data.breedDate;
            var id = data.id;
            if((data.maleDogOwner==member.name&&data.reviewState==("不通过"||"未通过"))||(data.reviewState=='未审核')){
                location.href = location.href.split("#")[0]+"#/dog/dognewbornadd?malePedigreeCertified="+malePedigreeCertified+"&femalePedigreeCertified="+femalePedigreeCertified+"&urgent="+urgent+"&breedDate="+breedDate+"&id="+id;
            }
        }
        $(function(){
            me.finddognewbornList(false);
        });
        context.app.loading(false);
        context.app.isShop(false);
    }
});