define(["knockout"],function(ko){
    return function(context){
        var me = this;
        me.memberName = ko.observable("");
        me.memberCode = ko.observable("");
        //展现手机号码，****
        me.showMobile = ko.observable("");
        //输入短信接收手机
        me.inMobile = ko.observable("");
        //倒计时
        me.downTime = ko.observable("120");
        me.timeRun = null;
        /**
         * 查询会员信息
         */
        me.findMember = function(){

            if(util.isVal(me.memberCode())==""){
                layer.msg("会员号不能为空！");
                return;
            }

            util.sendAjax({
                url:'member',
                data:{memberCode:me.memberCode(), home:"1"},
                async:true,
                loadFlag:true,
                type:'GET',
                cache:false,
                success:function(json){
                    if(json.rc==0){
                        if(json.data.isBindUser=="true"){
                            layer.alert("该会员号已被绑定，<br> 如有疑问请联系客服：400-660-7000", {
                                time: 0 //不自动关闭
                                ,btn: [ '确定']
                            });
                            return;
                        }
                        me.memberName(json.data.name);
                        if(!json.data.safeMobile){
                            me.showMobile(json.data.mobile);
                        }else{
                            me.showMobile(json.data.safeMobile);
                        }
                    }
                }
            });
        };
        /**
         * 发送手机短信
         */
        me.sendMsg = function(){
            if(me.downTime()>0 && me.downTime()<120){
                layer.msg("验证码已经发送，请耐心等候！");
                return;
            }
            if(util.isVal(me.showMobile())==""){
                layer.msg("会员登记手机为空！");
                return;
            }
            me.downTime(120);
            util.sendAjax({
                url:'userCenter/smsValidate/bindUser',
                data:{memberCode:me.memberCode(), home:"1"},
                async:true,
                loadFlag:true,
                type:'GET',
                cache:false,
                success:function(json){
                    if(json.rc==0){
                        $("#sendBtn").html("已发送");
                        $("#showEndTime").css("display","block");
                        me.timeRun = setInterval( me.settime, 1000);
                    }else{
                        layer.msg("发送手机验证码失败,错误代码:"+json.rc+"错误信息:"+json.msg);
                    }
                }
            });
        }
        me.settime = function(){
            me.downTime(me.downTime()-1);
            if(me.downTime()==0){
                clearInterval(me.timeRun);
                $("#sendBtn").html("重新发送");
            }
        }
        /**
         * 关联会员
         */
        me.accountMember = function(){
            if(util.isVal(me.inMobile())==""){
                layer.msg("验证码不能为空！");
                return;
            }
            if(util.isVal(me.memberCode())==""){
                layer.msg("会员号不能为空！");
                return;
            }
            //{"memberCode":"2001","captcha":"12354"}
            var sendData = {};
            sendData["memberCode"] = me.memberCode();
            sendData["captcha"] = me.inMobile();
            util.sendAjax({
                url:'userCenter/bindUser?home=1',
                data:JSON.stringify(sendData),
                async:true,
                loadFlag:true,
                type:'POST',
                cache:false,
                success:function(json){
                    if(json.rc==0){
                        userInfo.refresh();
                        location.href = location.href.split("#")[0]+"#home";
                    }else{
                        layer.msg("关联会员失败,错误代码:"+json.rc+"错误信息:"+json.msg);
                    }
                }
            });

        }


        context.app.loading(false);
        context.app.isShop(false);
    }
});