//新生犬登记申请列表
define(["knockout"],function(ko){
    return function(context){
        var me = this;
        me.member = ko.observable({});
        //列表数据
        me.listData = ko.observableArray([]);
        //申请批次号
        me.semenBatchCode = ko.observable("");
        //血统证书号
        me.pedigreeCertified = ko.observable("");
        //业务类型
        me.businessType = ko.observable("");
        //精子变更类别 申报  报备
        me.typeList = ko.observableArray([]);
//        //新生犬信息数组
//        me.dogSemenList = ko.observableArray([]);

        //每页多少条数据
        me.pageSize = ko.observable(10);
        //第几页
        me.pageNo = ko.observable(1);
        //页码列表
        me.pageArray = ko.observableArray();
        me.detailData= ko.observable({});
        //详细数据
        me.detailData()["dogSemenList"] = ko.observableArray([]);
        me.detailData()["id"] = ko.observable("");
        me.detailData()["pedigreeCertified"] = ko.observable("");
        me.detailData()["dogChip"] = ko.observable("");
        me.detailData()["dogBreed"] = ko.observable("");
        me.detailData()["dogName"] = ko.observable("");
        me.detailData()["dogOwner"] = ko.observable("");
        me.detailData()["semenNumber"] = ko.observable("");

        //未通过原因的显隐
        me.showReason = function(data,event){
            if(data.businessState=="未通过") {
                if ($(event.target).parent("a").siblings(".reason").css("display") == "none") {
                    $(event.target).parent("a").siblings(".reason").css("display", "block");
                } else {
                    $(event.target).parent("a").siblings(".reason").css("display", "none");
                }
            }
        }
        me.closeReason = function(data,event){
            $(event.target).parents(".reason").css("display","none")
        }
        //上一页
        me.pagePre = function(){
            if(me.pageNo()>1){
                me.pageNo(me.pageNo()-1);
            }
            me.findnewdogchipList(false);
        }

        me.pageNext = function(){
            if(me.pageNo()<parseInt(me.pageArray().pop()["pageNo"])){
                me.pageNo(me.pageNo()+1);
            }

            me.findnewdogchipList(false);
        }
        me.changeType = function(data,event){
        	var options=$("#type option:selected");
        	me.businessType(options.val());
        }
        me.pageAction = function(data){
            if(data.pageNo == -1){
                //什么都不做
            }else if(me.pageNo() == data.pageNo){
                //alert("当前选中的就是该页");
                me.findnewdogchipList(false);
            }else{
                //alert(data.pageNo);//做一些分页啥的
                me.pageNo(data.pageNo);
                me.findnewdogchipList(false);
            }
            return false;
        }
        /**
         * 新生犬登记申请查询方法
         */
        me.findnewdogchipList = function(isreset){
            if(isreset){
                me.pageNo(1);
            };
            var sendData = {};
            sendData["pedigreeCertified"] = me.pedigreeCertified().trim();
            sendData["businessType"] = me.businessType().trim();
            sendData["pageSize"] = me.pageSize;
            sendData["pageNo"] = me.pageNo;
            util.sendAjax({
                url:'dog/dogFrozenSemen',
                data:sendData,
                async:true,
                loadFlag:true,
                type:'GET',
                cache:false,
                success:function(data){
                    if(data.rc==0){
                        if(data.list!=null && data.list.length>0) {
                            me.listData(data.list);
                        }else{
                            me.listData([]);
                        }
                        //计算总页数和分页的参数
                        me.pageArray(util.getPageArray(me.pageNo(), data.total, me.pageSize()));
                    }else{
                        layer.msg("信息查询失败:"+data.msg);
                    }
                }
            });

        }
        //展示查看页
        me.showCszmask = function(){
        	$("#viewMask").css("display","block");
        }
        //关闭mask
        me.closemask  = function(type){
            $("#"+type).css("display","none");
        }
        $(function(){
            me.findnewdogchipList(false);
            me.member(userInfo.getMember());
            if(me.member().memberType!="professional"||me.member().paymentState!="2"){
                layer.alert('只有有效专业会员才能办理此业务，请先缴费', {
                    time: 0 //不自动关闭
                    ,btn: ['缴费', '关闭']
                    ,yes: function(index){
                        layer.close(index);
                        location.href = location.href.split("#")[0]+"#home";
                    }
                });
            }
        });
        me.getDetail = function(data){
            $("#viewMask").css("display","inline-block");
            util.sendAjax({
                url:'dog/dogFrozenSemen/'+data.id,
                async:true,
                loadFlag:true,
                type:'GET',
                cache:false,
                success:function(json){
                    if(json.rc==0){
                    	me.detailData()["id"] ( json.data.id);
                    	me.detailData()["pedigreeCertified"] ( json.data.pedigreeCertified);
                    	me.detailData()["dogChip"] (json.data.dogChip);
                    	me.detailData()["dogBreed"] ( json.data.dogBreed);
                    	me.detailData()["dogName"] (json.data.dogName);
                    	me.detailData()["dogOwner"] (json.data.dogOwner);
                    	me.detailData()["semenNumber"] (json.data.semenNumber);
                    	me.detailData()["dogSemenList"](json.data.dogSemenList);
                    }else{
                        layer.msg("信息查询失败:"+data.msg);
                    }
                }
            });
        }

        me.changeMsg = function(data,event){
            $("#editMask").css("display","inline-block");
            util.sendAjax({
                url:'dog/dogFrozenSemen/'+data.id,
                async:true,
                loadFlag:true,
                type:'GET',
                cache:false,
                success:function(json){
                    if(json.rc==0){
                    	me.detailData()["id"] ( json.data.id);
                    	me.detailData()["pedigreeCertified"] ( json.data.pedigreeCertified);
                    	me.detailData()["dogChip"] (json.data.dogChip);
                    	me.detailData()["dogBreed"] ( json.data.dogBreed);
                    	me.detailData()["dogName"] (json.data.dogName);
                    	me.detailData()["dogOwner"] (json.data.dogOwner);
                    	me.detailData()["semenNumber"] (json.data.semenNumber);
                    	me.detailData()["dogSemenList"](json.data.dogSemenList);
                    }else{
                        layer.msg("信息查询失败:"+data.msg);
                    }
                }
            });
        }


        me.del = function(data,event){
        	var old = data.id;
        	var currList = me.detailData()["dogSemenList"]();
        	for(var i=0;i<currList.length;i++)  
        	{  
        	    var cuid = currList[i].id;  
        	    if(cuid===old)  
        	    {  
        	    	currList.splice(i,1);  
        	    }  
        	} 
            me.detailData()["dogSemenList"](currList.slice());
        }
        
        me.add = function(data,event){
        	var currList = me.detailData()["dogSemenList"]();
            var nowObj = {};
            nowObj["originalSemenCode"] = "" ;
            nowObj["semenCode"] = "" ;
            nowObj["id"] = "new_"+ Math.random();
            currList.push(nowObj);
            me.detailData()["dogSemenList"](currList.slice());
        }

        me.edit = function(){
            var originalSemenCode = [];
            var currList = me.detailData()["dogSemenList"]();
            for(var i=0;i<currList.length;i++)
            {
                var val = currList[i].originalSemenCode;
                if(val==''){
                    layer.msg("请填写原精子编号");
                    return;
                }
                originalSemenCode.push(val);
            }
            if(originalSemenCode.length==0){
                layer.msg("请填写原精子编号");
                return;
            }
            var sendData = {};
            sendData["id"] = me.detailData()["id"]();
            sendData["originalSemenCode"] = originalSemenCode;
            util.sendAjax({
                url:'dog/dogFrozenSemen',
                data:JSON.stringify(sendData),
                async:true,
                loadFlag:true,
                type:'PUT',
                cache:false,
                success:function(json){
                    if(json.rc ==0){
                        layer.msg("种犬报备编辑成功");
                        me.closemask('editMask');
                        me.findnewdogchipList(false);
                    }else{
                        layer.msg("种犬报备编辑失败:"+json.msg);
                    }
                }
            });
        }
        context.app.loading(false);
        context.app.isShop(false);
    }
});