<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
	<title>课程报名</title>
	<meta name="decorator" content="default"/>
	<script type="text/javascript">
		$(document).ready(function() {
			//悬浮提示插件
			$(document).tooltip();

/* 			$("#btnExport").click(function(){
				top.$.jBox.confirm("确认要导出数据吗？","系统提示",function(v,h,f){
					if(v=="ok"){
						$("#searchForm").attr("action","${ctx}/groomer/groomerDiploma/export");
						$("#searchForm").submit();
					}
				},{buttonsFocus:1});
				top.$('.jbox-body .jbox-icon').css('top','55px');
			}); */
		});

		function page(n,s){
			if(n) $("#pageNo").val(n);
			if(s) $("#pageSize").val(s);
			$("#searchForm").attr("action","${ctxSchools}/schoolsCourse/viewApply/");
			$("#searchForm").submit();
	    	return false;
	    }
		//批量审核通过
/* 		function listSubmit(){
				var id="";
				$(".checkedId:checked").each(function(){
					id+=$(this).attr("groomerId")+',';
				});
				if (id!="") {
					$.ajax({
		                type:"POST",
		                url: ctx+"/groomer/groomerDiploma/listSubmit",
		                data : {'id':id},
		                dataType: 'json',
		                success: function(json){
		                	if (json.rc==0) {
		                		$("#searchForm").submit();
							}else{
								$.jBox.alert(json.msg,"提示");
							}
		                }
					});
				}else{
					$.jBox.alert("请勾选需要通过的结业记录");
				}
			}
		 */

		//全选事件 选中/取消选中
/* 		var b=false;
		function allCheck(){
			if (!b) {
				b=true;
				$(".checkedId").each(function(){
					$(this).attr("checked", b);
				});
			}else{
				b=false;
				$(".checkedId").each(function(){
					$(this).attr("checked", b);
				});
			}
		} */

	</script>
	<!-- 悬浮提示插件 -->
	<link rel="stylesheet" href="${ctxStatic}/jquery-ui/1.12.0/jquery-ui.min.css">
	<script src="${ctxStatic}/jquery-ui/1.12.0/jquery-ui.min.js"></script>
</head>
<body>
	<ul class="nav nav-tabs">
		<li class="active"><a href="#">课程报名</a></li>
	</ul>
	<form:form id="searchForm" modelAttribute="groomerCourseApplication" action="${ctxSchools}/schoolsCourse/viewApply" method="post" class="breadcrumb form-search">
		<input id="pageNo" name="pageNo" type="hidden" value="${page.pageNo}"/>
		<input id="pageSize" name="pageSize" type="hidden" value="${page.pageSize}"/>
		<ul class="ul-form">
			<li><label>姓名/会员号：</label>
				<form:input path="memberCode" htmlEscape="false" maxlength="100" class="input-medium"/>
			</li>
			<li><label>课程编号：</label>
				<form:input path="groomerCourse.code" htmlEscape="false"  class="input-medium"/>
			</li>
			<li><label>课程等级：</label>
				<form:select path="groomerCourse.diplomaLevel" class="input-medium">
					<form:option value="" label="全部"/>
					<form:options items="${fns:getDictList('course_level')}" itemLabel="label" itemValue="value" htmlEscape="false"/>
				</form:select>
			</li>
			<li><label>课程类型：</label>
				<form:select path="groomerCourse.type" class="input-medium">
					<form:option value="" label="全部"/>
					<form:options items="${fns:getDictList('course_type')}" itemLabel="label" itemValue="value" htmlEscape="false"/>
				</form:select>
			</li>
			<li><label>报名时间：</label>
				<input name="beginCreateDate"  type="text" readonly="readonly" maxlength="20" class="input-medium Wdate"
					   value="<fmt:formatDate value="${groomerCourseApplication.beginCreateDate}" pattern="yyyy-MM-dd"/>"
					   onclick="WdatePicker({dateFmt:'yyyy-MM-dd',isShowClear:true});"/> -
				<input name="endCreateDate" type="text" readonly="readonly" maxlength="20" class="input-medium Wdate"
					   value="<fmt:formatDate value="${groomerCourseApplication.endCreateDate}" pattern="yyyy-MM-dd"/>"
					   onclick="WdatePicker({dateFmt:'yyyy-MM-dd',isShowClear:true});"/>
			</li>
			<li class="btns"><input id="btnSubmit" class="btn btn-primary" type="submit" value="查询" onclick="return page();"/>
			</li>
			<li class="clearfix"></li>
		</ul>
	</form:form>
	<sys:message content="${message}"/>

	<table id="contentTable" class="table table-striped table-bordered table-condensed">
		<thead>
			<tr>
				<th>课程编号</th>
				<th>会员姓名</th>
				<th>会员号</th>
				<th>美容师类型</th>
				<th>手机号</th>
				<th>课程等级</th>
				<th>报名时间</th>
				<th>操作</th>
			</tr>
		</thead>
		<tbody>
		<c:forEach items="${page.list}" var="groomerCourseApplication">
			<tr>
				<td>
					${fns:escapeHtml(groomerCourseApplication.courseCode)}
				</td>
				<td>
					${fns:escapeHtml(groomerCourseApplication.memberCode)}
				</td>
				<td>
					${fns:escapeHtml(groomerCourseApplication.name)}
				</td>
				<td>
					${fns:getDictLabels(groomerCourseApplication.member.groomerType, 'user_groomer_type', '无')}
				</td>
				<td>
					${fns:escapeHtml(groomerCourseApplication.member.mobile)}
				</td>
				<td>
				    ${fns:getDictLabel(groomerCourseApplication.groomerCourse.diplomaLevel, 'course_level', '')}
				</td>
				<td>
					<fmt:formatDate value="${groomerCourseApplication.createDate}" pattern="yyyy-MM-dd"/>
				</td>
				<td>
					<a href="${ctxSchools}/schoolsCourse/groomerCourseApplicationDetail?id=${groomerCourseApplication.id}">查看</a>
				</td>
			</tr>
		</c:forEach>
		</tbody>
	</table>
	<div class="pagination">${page}</div>
</body>
</html>