<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
	<title>订单管理</title>
	<meta name="decorator" content="default"/>
	<script type="text/javascript">
		$(document).ready(function() {
			
		});
		function page(n,s){
			$("#pageNo").val(n);
			$("#pageSize").val(s);
			$("#searchForm").submit();
        	return false;
        }
	</script>
</head>
<body>
	<ul class="nav nav-tabs">
		<li class="active"><a href="#">当前位置:消费记录</a></li>
	</ul>
<ul>
	<form:form id="searchForm" modelAttribute="paymentOrder" action="${ctxSchools}/schoolsAccountManagement/myConsume" method="post" class="breadcrumb form-search">
		<input id="pageNo" name="pageNo" type="hidden" value="${page.pageNo}"/>
		<input id="pageSize" name="pageSize" type="hidden" value="${page.pageSize}"/>
	</form:form>
	<sys:message content="${message}"/>
	<table id="contentTable" class="table table-striped table-bordered table-condensed">
		<thead>
			<tr>
				<th>流水账号</th>
				<th>金额</th>
				<th>收支类型</th>
				<th>支付方式</th>
				<th>缴费日期</th>
			</tr>
		</thead>
		<tbody>
		<c:forEach items="${page.list}" var="paymentOrder">
			<tr>
				<td>
					<a href="${ctxSchools}/schoolsAccountManagement/orderDetil?id=${fns:escapeHtml(paymentOrder.id)}">${fns:escapeHtml(paymentOrder.orderCode)}</a>
				</td>
				<td>
					${fns:escapeHtml(paymentOrder.totalPrice)}
				</td>
				<td>
					业务订单支付
				</td>
				<td>
					${fns:getDictLabel(paymentOrder.paymentWay, 'payment_way', '')}
				</td>
				<td>
					<fmt:formatDate value="${paymentOrder.paymentTime}" pattern="yyyy-MM-dd HH:mm:ss"/>
				</td>
			</tr>
		</c:forEach>
		</tbody>
	</table>
	<div class="pagination">${page}</div>
	<HR style="FILTER: progid:DXImageTransform.Microsoft.Glow(color=#987cb9,strength=10)"  color=#987cb9 SIZE=1>
	<span>
		<input id="btnCancel" class="btn" type="button" value="返回上一页" onclick="history.go(-1)"/>
	</span>
</ul>
</body>
</html>