<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
	<title>犬只鉴定管理</title>
	<meta name="decorator" content="default"/>
	<script type="text/javascript">
		$(document).ready(function() {
			//$("#name").focus();
			$("#inputForm").validate({
				submitHandler: function(form){
					loading('正在提交，请稍等...');
					form.submit();
				},
				errorContainer: "#messageBox",
				errorPlacement: function(error, element) {
					$("#messageBox").text("输入有误，请先更正。");
					if (element.is(":checkbox")||element.is(":radio")||element.parent().is(".input-append")){
						error.appendTo(element.parent().parent());
					} else {
						error.insertAfter(element);
					}
				}
			});
		});
		function check(dogBreedCode, id){
			var reviewState = $("#reviewState option:selected").val();
			if(reviewState!='1'){
				$.jBox.alert("只有鉴定通过后才能生成血统证书号！","提示");
			}else{
				util.createPedigreeCertifiedCode(dogBreedCode,id);
			}
        }
	</script>
</head>
<body>
	<ul class="nav nav-tabs">
		<li><a href="${ctxPartner}/dog/appraisal/${dogAppraisal.dogBreed=='230'?'list?dogBreed=230':''}">犬只鉴定列表</a></li>
		<li class="active"><a href="${ctxPartner}/dog/appraisal/form?id=${dogAppraisal.id}">犬只鉴定查看</a></li>
	</ul><br/>
	<form:form id="inputForm" modelAttribute="dogAppraisal" action="${ctxPartner}/dog/appraisal/audit" method="post" class="form-horizontal">
		<form:hidden path="id"/>
		<sys:message content="${message}"/>	
		<div class="control-group">
			<label class="control-label">犬种：</label>
			<div class="controls">
				${fns:escapeHtml(dogAppraisal.breedCnName)}
			</div>
		</div>	
		<div class="control-group">
			<label class="control-label">犬名：</label>
			<div class="controls">
				${fns:escapeHtml(dogAppraisal.dogName)}
			</div>
		</div>	
		<div class="control-group">
			<label class="control-label">毛色：</label>
			<div class="controls">
				${fns:escapeHtml(dogAppraisal.dogColorMarkCn)}
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">鉴定类型：</label>
			<div class="controls">
				${fns:getDictLabel(dogAppraisal.identifyType, 'dog_appraisal_type', '')}
			</div>
		</div>
		<c:if test="${fns:getDictLabel(dogAppraisal.identifyType, 'dog_appraisal_type', '')=='审查员鉴定'}">
		<div class="control-group">
			<label class="control-label">鉴定地点：</label>
			<div class="controls">
				${fns:escapeHtml(dogAppraisal.identifySite)}
			</div>
		</div>
		</c:if>
		<div class="control-group">
			<label class="control-label">犬只出生日期：</label>
			<div class="controls">
				<fmt:formatDate value="${dogAppraisal.birthday}" pattern="yyyy-MM-dd"/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">性别：</label>
			<div class="controls">
				${fns:getDictLabel(dogAppraisal.dogGender, 'dog_gender', '')}
			</div>
		</div>
		<c:if test="${not empty dogAppraisal.mainShowId or not empty dogAppraisal.hospitalId}">
		<div class="control-group">
			<label class="control-label">是否提取DNA：</label>
			<div class="controls">
				<c:if test="${dogAppraisal.isFinishOrder==0}"><font color="red">否</font></c:if>
				<c:if test="${dogAppraisal.isFinishOrder==1}"><font color="green">是</font></c:if>
			</div>
		</div>
		</c:if>
		<div class="control-group">
			<label class="control-label">犬主：</label>
			<div class="controls">
				${fns:escapeHtml(dogAppraisal.dogOwnerName)}
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">会员号：</label>
			<div class="controls">
				${fns:escapeHtml(dogAppraisal.dogOwnerCode)}
			</div>
		</div>
		<c:if test="${dogAppraisal.identifyType=='0'}">
				<div class="control-group">
				<label class="control-label">鉴定人：</label>
				<div class="controls">
					<form:input path="identifier" disabled="true" htmlEscape="false" maxlength="64" class="input-xlarge required"/>
				</div>
			</div>
			<div class="control-group">
				<label class="control-label">鉴定地点：</label>
				<div class="controls">
					<form:input path="identifySite" disabled="true" htmlEscape="false" maxlength="64" class="input-xlarge required"/>
				</div>
			</div>
			<div class="control-group">
				<label class="control-label">鉴定时间：</label>
				<div class="controls">
					<input name="identifyDate" type="text" readonly="readonly" maxlength="20" class="input-medium  required"
						value="<fmt:formatDate value="${dogAppraisal.identifyDate}" pattern="yyyy-MM-dd"/>"
						/>
				</div>
			</div>
		</c:if>
		<div class="control-group">
			<label class="control-label">犬只芯片号：</label>
			<div class="controls">
				<form:input path="dogChip" disabled="true" htmlEscape="false" maxlength="64" class="input-xlarge "/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">血统证书号：</label>
			<div class="controls">
				<form:input id="pedigreeCertified" disabled="true" path="pedigreeCertified" readonly="true" htmlEscape="false" maxlength="64" class="input-xlarge "/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">宠爱证书号：</label>
			<div class="controls">
				<form:input id="chongaiCertificateCode" disabled="true" path="chongaiCertificateCode" readonly="true" htmlEscape="false" maxlength="50" class="input-xlarge "/>
			</div>
		</div>
		<c:if test="${dogAppraisal.identifyType=='1'}">
		<div class="control-group">
			<label class="control-label">鉴定结果：</label>
			<div class="controls">
				<img height="170" width="120" src="<%=request.getContextPath()%>/oaManage/sys/file/image/${dogAppraisal.dogDnaImage}">
			</div>
		</div>
		</c:if>
		<div class="control-group">
			<label class="control-label">鉴定结果：</label>
			<div class="controls">
				<form:select id="reviewState" disabled="true" path="reviewState" class="input-medium">
					<form:options items="${fns:getDictList('dog_appraisal_review_state')}" itemLabel="label" itemValue="value" htmlEscape="false"/>
				</form:select>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">审核意见：</label>
			<div class="controls">
				<form:textarea path="reviewRemarks" disabled="true" htmlEscape="false" rows="3" maxlength="255" class="input-xlarge "/>
			</div>
		</div>
		<div class="form-actions">
			<input id="btnCancel" class="btn" type="button" value="返 回" onclick="history.go(-1)"/>
		</div>
	</form:form>
</body>
</html>