<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
	<title>芯片发放记录管理</title>
	<meta name="decorator" content="default"/>
</head>
<body>
    <ul class="nav nav-tabs">
        <li><a href="${ctx}/sys/org/">合作机构列表</a></li>
        <li class="active"><a href="${ctx}/sys/orgChip/group?orgId=${org.id}">物资管理</a></li>
    </ul>
	<div class="form-actions">
	<input id="btnCancel" class="btn" type="button" value="返 回" onclick="history.go(-1)"/>
	</div>
	<table id="contentTable" class="table table-striped table-bordered table-condensed">
		<thead>
			<tr>
				<th>机构名</th>
				<th>芯片数量</th>
				<th>采血卡量</th>
				<th>采血器数量</th>
				<th style="text-align:left">血统证书数量<br>(打印次数：${printCount})</th>
				<th style="text-align:left">玛犬血统证书数量<br>(打印次数：${printCountMC})</th>
				<th style="text-align:left">杜高血统证书数量<br>(打印次数：${printCountDC})</th>
				<th>鉴定证书数量</th>
				<th>DNA血统证书证书数量</th>
				<th>DNA繁育证书证书数量</th>
				<th>发放时间</th>
				<th>操作</th>
			</tr>
		</thead>
		<tbody>
		<c:forEach items="${list}" var="orgChip">
			<tr>
				<td>${orgChip.org.name }</td>
				<td>
					${orgChip.count}
				</td>
				<td>
					${orgChip.bloodCard}
				</td>
				<td>
					${orgChip.drawBlood}
				</td>
				<td>
					${orgChip.pedigreeCertified}
				</td>
				<td>
					${orgChip.pedigreeCertifiedMc}
				</td>
				<td>
					${orgChip.pedigreeCertifiedDc}
				</td>
				<td>
					${orgChip.appraisalCertified}
				</td>
				<td>
					${orgChip.dnaPedigreeCertified}
				</td>
				<td>
					${orgChip.dnaBreedCertified}
				</td>
				<td>
					<fmt:formatDate value="${orgChip.postDate}" pattern="yyyy-MM-dd HH:mm:ss"/>
				</td>
				<td>
				<a href="${ctx }/sys/orgChip/list?orgId=${orgChip.orgId}&postDate=<fmt:formatDate value="${orgChip.postDate}" pattern="yyyy-MM-dd"/>">物资明细</a>
				<a href="${ctx }/sys/orgChip/deleteList?orgId=${orgChip.orgId}&postDate=<fmt:formatDate value="${orgChip.postDate}" pattern="yyyy-MM-dd"/>" onclick="return confirmx('确认要删除该批次芯片吗？', this.href)">删除本批</a>
				</td>
			</tr>
		</c:forEach>
		</tbody>
	</table>

</body>
</html>