<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
	<title>商城销售信息</title>
	<meta name="decorator" content="default"/>
	<script type="text/javascript">
	$(document).ready(function() {
		$("#btnImport").click(function(){
			$.jBox($("#importBox").html(), {title:"商城销售统计导入", buttons:{"关闭":true}, 
				bottomText:"导入文件不能超过5M，仅允许导入“xls”或“xlsx”格式文件！"});
		});
	});
		function page(n,s){
			$("#pageNo").val(n);
			$("#pageSize").val(s);
			$("#searchForm").submit();
        	return false;
        }
		function mySubmit()
		{	
			document.getElementById("searchForm").submit();
		}
	</script>
</head>
<body>
	<div id="importBox" class="hide">
		<form id="importForm" action="${ctx}/statistics/shop/import" method="post" enctype="multipart/form-data"
			class="form-search" style="padding-left:20px;text-align:center;" onsubmit="loading('正在导入，请稍等...');"><br/>
			<input id="uploadFile" name="file" type="file" style="width:330px"/><br/><br/>　　
			<input id="btnImportSubmit" class="btn btn-primary" type="submit" value="   导    入   "/>
			<a href="${ctx}/statistics/shop/import/template">下载模板</a>
		</form>
	</div>
	<ul class="nav nav-tabs">
		<li class="active"><a href="#">商城销售信息</a></li>
	</ul>
	<form id="searchForm"  action="${ctx}/statistics/shop/shopSalesStatistics" method="post" class="breadcrumb form-search">
		<ul class="ul-form">
			<li><label>开始时间：</label>
				<input id="startDate" name="startDate" type="text" readonly="readonly" maxlength="20" class="input-medium Wdate"
				value="${startDate}" onclick="WdatePicker({dateFmt:'yyyy-MM-dd',isShowClear:true});"/>
			</li>
			
			<li><label>结束时间：</label>
				<input id="endDate" name="endDate" type="text" readonly="readonly" maxlength="20" class="input-medium Wdate"
				value="${endDate}" onclick="WdatePicker({dateFmt:'yyyy-MM-dd',isShowClear:true});"/>
			</li>
			<li><label>商品名称：</label>
				<select id="name" name="name" class="input-small" autocomplete="off">
					<option value="">全部</option>					
					<c:forEach items="${list}" var="p">
						<c:choose>
							<c:when test="${selectedName!='' && selectedName!=null && selectedName == fns:escapeHtml(p)}">
								<option value="${fns:escapeHtml(p)}" selected="selected">${fns:escapeHtml(p)}</option>
							</c:when>
							<c:otherwise>
								<option value="${fns:escapeHtml(p)}">${fns:escapeHtml(p)}</option>
							</c:otherwise>
						</c:choose>
					</c:forEach>
				</select>
			</li> 
			<li class="btns"><input id="btnSubmit" name="btnSubmit" class="btn btn-primary" type="submit" onclick = "mySubmit()" value="查询"/></li>
			<li class="btns"><input id="btnImport" class="btn btn-primary" type="button" value="导入销售信息"/></li>
			<li class="clearfix"></li>
		</ul>
	</form>
	<sys:message content="${message}"/>
	<table id="contentTable" class="table table-striped table-bordered table-condensed">
		<thead>
			<tr>
				<th>商品名称</th>
				<th>商品类别</th>
				<th align="center" colspan="2" >统计</th>
			</tr>
		</thead>
		<tbody>
		<c:forEach items="${results}" var="results">
			<tr>
				<td>
					${results.commodityName}
				</td>
				<td>
					<font color="green">${results.commodityType}</font> 
				</td>
				<td>
					总数:<font color="green">${results.commodityNum}</font> 
				</td>
				<td>
					金额:<font color="green">${results.totalAmount}</font> 
				</td>
				<%-- <td>
					金额:<font color="green"><fmt:formatNumber value="${results.totalAmount}" pattern="#,##0.00#" maxFractionDigits="2"/></font> 
				</td> --%>
			</tr>
		</c:forEach>
			<tr>
				<td>
					<b>合计</b>
				</td>
				<td>
				</td>
				<td>
				</td>
				<td>
				</td>
			</tr>
		</tbody>
	</table>


<script type="text/javascript">
	if(document.getElementById('contentTable').getElementsByTagName('tr').length-1!=1)
	{
		calcTotal(document.getElementById('contentTable'),2,'总数');
		calcTotal(document.getElementById('contentTable'),3,'金额');
	}
	function calcTotal(table,column,text){			
		var trs=table.getElementsByTagName('tr');		
		var start=1,//忽略第一行的表头
		end=trs.length-1;//忽略最后合计的一行
		var total = 0.00;    
		for(var i=start;i<end;i++){
			var td=trs[i].getElementsByTagName('td')[column];		
			var t=parseFloat(td.innerText.substring(3,td.innerText.length));
			if(t)total=accAdd(t,total);
		}
		total = number_format(total, 2, ".", ",");
		trs[end].getElementsByTagName('td')[column].innerHTML='<b>'+text+'：'+total+'</b>';
	}
	
	function accAdd(arg1,arg2){
		var r1,r2,m;
		try{r1=arg1.toString().split(".")[1].length}catch(e){r1=0}
		try{r2=arg2.toString().split(".")[1].length}catch(e){r2=0}
		m=Math.pow(10,Math.max(r1,r2))
		return (arg1*m+arg2*m)/m
		}
	
	function number_format(number, decimals, dec_point, thousands_sep) {
        /*
        * 参数说明：
        * number：要格式化的数字
        * decimals：保留几位小数
        * dec_point：小数点符号
        * thousands_sep：千分位符号
        * */
        number = (number + '').replace(/[^0-9+-Ee.]/g, '');
        var n = !isFinite(+number) ? 0 : +number,
 
            prec = !isFinite(+decimals) ? 0 : Math.abs(decimals),
            sep = (typeof thousands_sep === 'undefined') ? ',' : thousands_sep,
            dec = (typeof dec_point === 'undefined') ? '.' : dec_point,
            s = '',
            toFixedFix = function (n, prec) {
                var k = Math.pow(10, prec);
                return '' + Math.floor(n * k) / k;
            };
        s = (prec ? toFixedFix(n, prec) : '' + Math.floor(n)).split('.');
        var re = /(-?\d+)(\d{3})/;
        while (re.test(s[0])) {
            s[0] = s[0].replace(re, "$1" + sep + "$2");
        }
 
        if ((s[1] || '').length < prec) {
            s[1] = s[1] || '';
            s[1] += new Array(prec - s[1].length + 1).join('0');
        }
        return s.join(dec);
    }
	
</script>	
</body>
</html>