<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
	<title>合作医院信息统计</title>
	<meta name="decorator" content="default"/>
	<script type="text/javascript">
		$(document).ready(function() {
			var s='${state}';
			$('#state option[value="'+s+'"]').attr('selected',true);
			$("#state").trigger("change");
			
			var area = '${area}';
			$('#area option[value="' + area + '"]').attr('selected', true);
			$("#area").trigger("change");
		});
		function page(n,s){
			$("#pageNo").val(n);
			$("#pageSize").val(s);
			$("#searchForm").submit();
        	return false;
        }
		function SubmitByDate(date)
		{
			document.getElementById("nowDate").value=date
			 document.getElementById("searchForm").submit();
		}
	</script>
</head>
<body>
	<ul class="nav nav-tabs">
		<li class="active"><a href="#">合作医院统计信息</a></li>
	</ul>
	<form id="searchForm"  action="${ctx}/statistics/hospital/hospitalStatistics" method="post" class="breadcrumb form-search">
	<ul class="ul-form">

			<li><label>区域：</label> <select id="area" name="area"
				class="input-small selector" style="width: 177px">
					<option value="all" selected="selected">全部</option>
					<option value="110">北京办公室</option>
					<option value="410">郑州办公室</option>
					<option value="430">长沙办公室</option>
					<option value="330">杭州(平阳)办公室</option>
					<option value="220">长春办公室</option>
					<option value="500">重庆办公室</option>
			</select></li>

			<li><label>医院名称：</label> <input id="name" name="name"
				type="text" maxlength="20" class="input " style="width: 163px"
				value="${name}" /></li>

			<li><label>状态：</label> <select id="state" name="state"
				class="input-small selector">
					<option value="all">全部</option>
					<option value="0" selected="selected">开放</option>
					<option value="1">关闭</option>
			</select></li>

			<li class="clearfix"></li>
		</ul>
		<ul class="ul-form">
			<li><label>开始时间：</label> <input id="startDate" name="startDate"
				type="text" readonly="readonly" maxlength="20"
				class="input-medium Wdate" value="${startDate}"
				onclick="WdatePicker({dateFmt:'yyyy-MM-dd HH:mm:ss',isShowClear:true});" />
			</li>

			<li><label>结束时间：</label> <input id="endDate" name="endDate"
				type="text" readonly="readonly" maxlength="20"
				class="input-medium Wdate" value="${endDate}"
				onclick="WdatePicker({dateFmt:'yyyy-MM-dd HH:mm:ss',isShowClear:true});" />
			</li>
			<li style="padding-left: 72px" class="btns"><input
				id="btnSubmit" class="btn btn-primary"
				onclick="SubmitByDate('input')" type="submit" value="查询" /></li>
			<li class="btns"><input id="btnSubmit_current_month"
				class="btn btn-primary" type="button" value="本月"
				onclick="SubmitByDate('month')" /></li>
			<li class="btns"><input id="btnSubmit_current_yearh"
				class="btn btn-primary" type="button" value="本年"
				onclick="SubmitByDate('year')" /></li>
			<li><input id="nowDate" type="hidden" name="nowDate" value="" /></li>
		</ul>
			<li class="clearfix"></li>
		</ul>
	</form>
	<sys:message content="${message}"/>
	<table id="contentTable" class="table table-striped table-bordered table-condensed">
		<thead>
			<tr>
				<th>区域</th>
				<th>省/直辖市</th>
				<th>合作医院名字</th>
				<th>状态</th>
				<th onclick="orderByName('contentTable',4,'number')"><a href="javascript:;">预埋置芯片数</a></th>
				<th onclick="orderByName('contentTable',5,'number')"><a href="javascript:;">埋置芯片数</a></th>
				<th onclick="orderByName('contentTable',6,'number')"><a href="javascript:;">芯片转证书数</a></th>
				<th onclick="orderByName('contentTable',7,'number')"><a href="javascript:;">血样留存数</a></th>
			</tr>
		</thead>
		<tbody>
		<c:forEach items="${results}" var="result">
			<tr>
				<td>${result.area_name}</td>
				<td>${result.area_province}</td>
				<td>
					${result.name}
					
				</td>
				<td>
					<c:choose>
						<c:when test="${result.endDate>=date }">
							<font color="green">开放</font>
						</c:when>
						<c:otherwise>
							<font color="red">关闭</font>
						</c:otherwise>
					</c:choose>
				<td>
					<font color="green">${result.org_count}</font>
				</td>
				<td>
					<font color="green">${result.birth_count}</font>
				</td>
				<td>
					<font color="green">${result.certified_count}</font>
				</td>
				<td>
					<font color="green">${result.blood_count}</font>
				</td>
			</tr>
		</c:forEach>
		</tbody>
		<tbody>
		
			<tr>
				<td>
					<b>合计</b>
				</td>
					</td>
				<td>
				</td>
				<td>
					</td>
				<td>
				<td>
				</td>
				<td>
				</td>
				<td>
				</td>
				<td>
				</td>
				<td>
				</td>
			</tr>
			<div class="alert" role="alert" style="text-align: right;font-size:15px;">${size} 家合作医院</div>
		</tbody>
	</table>
<script type="text/javascript">
	if (document.getElementById('contentTable').getElementsByTagName('tr').length - 1 != 1) {
		var num = 4
		for (var i = num; i < 8 + num; i++) {
			calcTotal(document.getElementById('contentTable'), i, '');
		}		
	
	}
	function calcTotal(table, column, text) {
		var trs = table.getElementsByTagName('tr');
		var start = 1, //忽略第一行的表头
		end = trs.length - 1;//忽略最后合计的一行
		var total = 0.00;
		for (var i = start; i < end; i++) {
			var td = trs[i].getElementsByTagName('td')[column];
			var t = parseFloat(td.innerText.substring(0,
					td.innerText.length));
			if (t)
				total = accAdd(t, total);
		}
		trs[end].getElementsByTagName('td')[column].innerHTML = '<b>'
				+ text + total + '</b>';
	}
	
	function accAdd(arg1,arg2){
		var r1,r2,m;
		try{r1=arg1.toString().split(".")[1].length}catch(e){r1=0}
		try{r2=arg2.toString().split(".")[1].length}catch(e){r2=0}
		m=Math.pow(10,Math.max(r1,r2))
		return (arg1*m+arg2*m)/m
		}
	
</script>

<script>

function  orderByName(sTableID, iCol, sDataType) {
    var  oTable = document.getElementById(sTableID);
    var  oTBody = oTable.tBodies[0];
    var  colDataRows = oTBody.rows;

    var  aTRs =  new  Array;
    for  (  var  i = 0; i < colDataRows.length; i++) {
       aTRs[i] = colDataRows[i];
   }



    if  (oTable.sortCol == iCol) {
       aTRs.reverse();
   }  else  {

       aTRs.sort(generateCompareTRs(iCol, sDataType));
   }
    var  oFragment = document.createDocumentFragment();
    for  (  var  j = 0; j < aTRs.length; j++) {
		       oFragment.appendChild(aTRs[j]);
   }
   oTBody.appendChild(oFragment);
   oTable.sortCol = iCol;
}


/**
* 处理排序的字段类型
*
* @param sValue
*            字段值 默认为字符类型即比较ASCII码
* @param sDataType
*            字段类型 对于date只支持格式为mm/dd/yyyy或mmmm dd,yyyy(January 12,2004)
* @return
*/
function  convert(sValue, sDataType) {
    switch  (sDataType) {
    case   "int" :
        return  parseInt(sValue);
    case   "float" :
        return  parseFloat(sValue);
    case   "date" :
        return   new  Date(Date.parse(sValue));
	case	"number":
		return new Number(sValue)
    default :
        return  sValue.toString();
   }
}


/**
* 比较函数生成器
*
* @param iCol
*            数据行数
* @param sDataType
*            该行的数据类型
* @return
*/
function  generateCompareTRs(iCol, sDataType) {
    return   function  compareTRs(oTR1, oTR2) {

       vValue1 = convert(oTR1.cells[iCol].innerText, 'number');
       vValue2 = convert(oTR2.cells[iCol].innerText, 'number');
	
            return  vValue1 - vValue2;
   };
}
</script>
	
</body>
</html>