<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp" %>
<html>
<head>
    <title>犬种组犬展裁判证书表管理</title>
    <meta name="decorator" content="default"/>
    <script type="text/javascript">
        $(document).ready(function () {

        });
        function page(n, s) {
            $("#pageNo").val(n);
            $("#pageSize").val(s);
            $("#searchForm").submit();
            return false;
        }
    </script>
</head>
<body>
<ul class="nav nav-tabs">
    <li class="active"><a href="${ctx}/judgecertificatedoggroup/showJudgeCertificateDogGroup/">犬种组犬展裁判证书表列表</a></li>
    <shiro:hasPermission name="judgecertificatedoggroup:showJudgeCertificateDogGroup:edit">
        <li><a href="${ctx}/judgecertificatedoggroup/showJudgeCertificateDogGroup/form">犬种组犬展裁判证书表添加</a></li>
    </shiro:hasPermission>
</ul>
<form:form id="searchForm" modelAttribute="showJudgeCertificateDogGroup"
           action="${ctx}/judgecertificatedoggroup/showJudgeCertificateDogGroup/" method="post"
           class="breadcrumb form-search">
    <input id="pageNo" name="pageNo" type="hidden" value="${page.pageNo}"/>
    <input id="pageSize" name="pageSize" type="hidden" value="${page.pageSize}"/>
    <ul class="ul-form">
        <li><label>主裁判证书号：</label>
            <form:input path="judgeCertificateMian" htmlEscape="false" maxlength="20" class="input-medium"/>
        </li>
        <li><label>裁判证书号：</label>
            <form:input path="judgeCertificate" htmlEscape="false" maxlength="20" class="input-medium"/>
        </li>
        <li><label>签发日期：</label>
            <input name="signDate" type="text" readonly="readonly" maxlength="20" class="input-medium Wdate"
                   value="<fmt:formatDate value="${showJudgeCertificateDogGroup.signDate}" pattern="yyyy-MM-dd HH:mm:ss"/>"
                   onclick="WdatePicker({dateFmt:'yyyy-MM-dd HH:mm:ss',isShowClear:false});"/>
        </li>
        <li><label>结束日期：</label>
            <input name="endDate" type="text" readonly="readonly" maxlength="20" class="input-medium Wdate"
                   value="<fmt:formatDate value="${showJudgeCertificateDogGroup.endDate}" pattern="yyyy-MM-dd HH:mm:ss"/>"
                   onclick="WdatePicker({dateFmt:'yyyy-MM-dd HH:mm:ss',isShowClear:false});"/>
        </li>
        <li><label>组别编号：</label>
            <form:input path="groupNo" htmlEscape="false" maxlength="2" class="input-medium"/>
        </li>
        <li><label>是否可见。0不可见；1可见：</label>
            <form:input path="visibleFlag" htmlEscape="false" maxlength="1" class="input-medium"/>
        </li>
        <li class="btns"><input id="btnSubmit" class="btn btn-primary" type="submit" value="查询"/></li>
        <li class="clearfix"></li>
    </ul>
</form:form>
<sys:message content="${message}"/>
<table id="contentTable" class="table table-striped table-bordered table-condensed">
    <thead>
    <tr>
        <th>主裁判证书号</th>
        <th>裁判证书号</th>
        <th>签发日期</th>
        <th>结束日期</th>
        <th>组别编号</th>
        <th>是否可见。0不可见；1可见</th>
        <th>修改时间</th>
        <th>备注信息</th>
        <shiro:hasPermission name="judgecertificatedoggroup:showJudgeCertificateDogGroup:edit">
            <th>操作</th>
        </shiro:hasPermission>
    </tr>
    </thead>
    <tbody>
    <c:forEach items="${page.list}" var="showJudgeCertificateDogGroup">
        <tr>
            <td>
                <a href="${ctx}/judgecertificatedoggroup/showJudgeCertificateDogGroup/form?id=${showJudgeCertificateDogGroup.id}">
                        ${showJudgeCertificateDogGroup.judgeCertificateMian}
                </a></td>
            <td>
                    ${showJudgeCertificateDogGroup.judgeCertificate}
            </td>
            <td>
                <fmt:formatDate value="${showJudgeCertificateDogGroup.signDate}" pattern="yyyy-MM-dd HH:mm:ss"/>
            </td>
            <td>
                <fmt:formatDate value="${showJudgeCertificateDogGroup.endDate}" pattern="yyyy-MM-dd HH:mm:ss"/>
            </td>
            <td>
                    ${showJudgeCertificateDogGroup.groupNo}
            </td>
            <td>
                    ${showJudgeCertificateDogGroup.visibleFlag}
            </td>
            <td>
                <fmt:formatDate value="${showJudgeCertificateDogGroup.updateDate}" pattern="yyyy-MM-dd HH:mm:ss"/>
            </td>
            <td>
                    ${showJudgeCertificateDogGroup.remarks}
            </td>
            <shiro:hasPermission name="judgecertificatedoggroup:showJudgeCertificateDogGroup:edit">
                <td>
                    <a href="${ctx}/judgecertificatedoggroup/showJudgeCertificateDogGroup/form?id=${showJudgeCertificateDogGroup.id}">修改</a>
                    <a href="${ctx}/judgecertificatedoggroup/showJudgeCertificateDogGroup/delete?id=${showJudgeCertificateDogGroup.id}"
                       onclick="return confirmx('确认要删除该犬种组犬展裁判证书表吗？', this.href)">删除</a>
                </td>
            </shiro:hasPermission>
        </tr>
    </c:forEach>
    </tbody>
</table>
<div class="pagination">${page}</div>
</body>
</html>