<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
    <title>犬展报名信息管理</title>
    <meta name="decorator" content="default"/>
    <script type="text/javascript">
        $(document).ready(function() {
            
        });
    </script>
</head>
	<table id="contentTable" class="table table-striped table-bordered table-condensed">
		<thead>
			<tr>
				<th>报名序号</th>
				<th>犬主人</th>
				<th>会员号</th>
				<th>备注</th>
				<th>犬种</th>
				<th>犬名</th>
				<th>出生日期</th>
				<th>年龄组别</th>
				<th>BBE</th>
				<th>血统证书号</th>
				<th>芯片号</th>
				<th>犬展编号</th>
				<th>报名费</th>
				<th>缴费</th>
				<th>备注</th>
				<th>管理</th>
			</tr>
		</thead>
		<tbody>
		<c:forEach items="${list}" var="showApply">
			<tr>
				<td>
					${fns:escapeHtml(showApply.applyCode)}
				</td>
				<td>
					${fns:escapeHtml(showApply.dogOwnerNameCn)}
				</td>
				<td>
					${fns:escapeHtml(showApply.dogOwnerMemberCode)}
				</td>
				<td>
					${fns:escapeHtml(showApply.remarks)}
				</td>
				<td>
					${fns:escapeHtml(showApply.dogBreedNameCn)}
				</td>
				<td>
					${fns:escapeHtml(showApply.dogName)}
				</td>
				<td>
					<fmt:formatDate value="${showApply.dogBirthday}" pattern="yyyy-MM-dd"/>
				</td>
				<td>
					${fns:getDictLabel(showApply.ageGroup, 'show_age_group', '')}
				</td>
				<td>
					${fns:getDictLabel(showApply.bbeFlag, 'show_apply_bbe', '')}
				</td>
				<td>
					${fns:escapeHtml(showApply.pedigreeCertified)}
				</td>
				<td>
					${fns:escapeHtml(showApply.chipCode)}
				</td>
				<td>
					${fns:escapeHtml(showApply.showCode)}
				</td>
				<td>
					${fns:escapeHtml(showApply.fee)}
				</td>
				<td>
					<shiro:hasPermission name="finance:deductCost:payment">
					<c:choose>
						<c:when test="${showApply.phoneApplyFlag=='0'}">
								<a onclick="util.pay('${showApply.id}','show_apply@phoneApplyFee',${showApply.showNum},'${showApply.phoneApplyFee}','${fns:escapeHtml(showApply.dogOwnerMemberCode)}')">
								服务费
								</a>
						</c:when>
						<c:when test="${showApply.paymentState=='1'}">
							<a onclick="util.pay('${showApply.id}','${showApply.shortName}',${showApply.showNum},'${showApply.orderPrice}','${fns:escapeHtml(showApply.dogOwnerMemberCode)}')">
							${fns:getDictLabel(showApply.paymentState, 'user_payment_state', '')}
							</a>
						</c:when>
						<c:otherwise>
							${fns:getDictLabel(showApply.paymentState, 'user_payment_state', '')}
						</c:otherwise>
					</c:choose>
					</shiro:hasPermission>
				</td>
				<td>
				${fns:escapeHtml(showApply.remarks)}
				</td>
				<td>
				<shiro:hasPermission name="apply:showApply:view">
					<a href="${ctx}/apply/showApply/form?id=${showApply.id}">查看</a>
				</shiro:hasPermission>
				<c:if test="${!showApply.businessRefundState}">
					<shiro:hasPermission name="apply:showApply:edit">
						<a href="${ctx}/apply/showApply/editForm?id=${showApply.id}">编辑</a>
					</shiro:hasPermission>
					<shiro:hasPermission name="apply:showApply:delete">
						<a href="${ctx}/apply/showApply/delete?id=${showApply.id}" onclick="return confirmx('确认要删除该犬展报名表吗？', this.href)">删除</a>
					</shiro:hasPermission>
				</c:if>
				</td>
			</tr>
		</c:forEach>
		</tbody>
	</table>
</body>
</html>