<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
	<title>销售渠道管理</title>
	<meta name="decorator" content="default"/>
	<script type="text/javascript">
		$(document).ready(function() {
			$("#btnExport").click(function(){
				top.$.jBox.confirm("确认要导出数据吗？","系统提示",function(v,h,f){
					if(v=="ok"){
						$("#searchForm").attr("action","${ctx}/shop/shopSaleChannel/export");
						$("#searchForm").submit();
					}
				},{buttonsFocus:1});
				top.$('.jbox-body .jbox-icon').css('top','55px');
			});
			$("#btnImport").click(function(){
				$.jBox($("#importBox").html(), {title:"导入数据", buttons:{"关闭":true},
					bottomText:"导入文件不能超过5M，仅允许导入“xls”或“xlsx”格式文件！"});
			});
		});
		function page(n,s){
			$("#pageNo").val(n);
			$("#pageSize").val(s);
			$("#searchForm").submit();
        	return false;
        }
	</script>
</head>
<body>
	<ul class="nav nav-tabs">
		<li class="active"><a href="${ctx}/shop/shopSaleChannel/">销售渠道列表</a></li>
		<shiro:hasPermission name="shop:shopSaleChannel:add"><li><a href="${ctx}/shop/shopSaleChannel/form">销售渠道添加</a></li></shiro:hasPermission>
	</ul>
	<div id="importBox" class="hide">
		<form id="importForm" action="${ctx}/shop/shopSaleChannel/import" method="post" enctype="multipart/form-data"
			  class="form-search" style="padding-left:20px;text-align:center;" onsubmit="loading('正在导入，请稍等...');"><br/>
			<input id="uploadFile" name="file" type="file" style="width:330px"/><br/><br/>　　
			<input id="btnImportSubmit" class="btn btn-primary" type="submit" value="   导    入   "/>
		</form>
	</div>
	<form:form id="searchForm" modelAttribute="shopSaleChannel" action="${ctx}/shop/shopSaleChannel/" method="post" class="breadcrumb form-search">
		<input id="pageNo" name="pageNo" type="hidden" value="${page.pageNo}"/>
		<input id="pageSize" name="pageSize" type="hidden" value="${page.pageSize}"/>
		<ul class="ul-form">
			<li><label>编号：</label>
				<form:input path="code" htmlEscape="false" maxlength="64" class="input-medium"/>
			</li>
			<li><label>姓名：</label>
				<form:input path="name" htmlEscape="false" maxlength="100" class="input-medium"/>
			</li>
			<li><label>部门：</label>
				<sys:treeselect id="dept" name="dept" value="${shopSaleChannel.dept}" labelName="deptName" labelValue="${shopSaleChannel.deptName}"  title="部门" url="/sys/office/treeData?type=2" cssClass="input-small" allowClear="true" notAllowSelectParent="true"/>
			</li>
			<li><label>职位：</label>
				<form:input path="position" htmlEscape="false" maxlength="50" class="input-medium"/>
			</li>
			<li><label>渠道类型：</label>
				<form:select path="type" class="input-medium">
					<form:option value="" label="全部"></form:option>
					<form:options items="${fns:getDictList('channel_type')}" itemLabel="label" itemValue="value" htmlEscape="false"></form:options>
				</form:select>
			</li>
			<li><label>区域：</label>
				<sys:treeselect id="area" name="area" value="${shopSaleChannel.area}" labelName="areaName" labelValue="${shopSaleChannel.areaName}"  title="区域" url="/sys/area/treeData" cssClass="input-small" allowClear="true" notAllowSelectParent="true"/>
			</li>
			<li><label>是否有效：</label>
				<form:select path="isValid" class="input-medium">
					<form:option value="" label="全部"></form:option>
					<form:options items="${fns:getDictList('yes_no')}" itemLabel="label" itemValue="value" htmlEscape="false"></form:options>
				</form:select>
			</li>
			<li class="btns">
				<input id="btnSubmit" class="btn btn-primary" type="submit" value="查询"/>
				<shiro:hasPermission name="shop:shopSaleChannel:export">
				<input id="btnExport" class="btn btn-primary" type="button" value="导出"/>
				</shiro:hasPermission>
				<shiro:hasPermission name="shop:shopSaleChannel:import">
				<input id="btnImport" class="btn btn-primary" type="button" value="导入"/>
				</shiro:hasPermission>
			</li>
			<li class="clearfix"></li>
		</ul>
	</form:form>
	<sys:message content="${message}"/>
	<table id="contentTable" class="table table-striped table-bordered table-condensed">
		<thead>
			<tr>
				<th>编号</th>
				<th>姓名</th>
				<th>部门</th>
				<th>职位</th>
				<th>渠道类型</th>
				<th>区域</th>
				<th>联系方式1</th>
				<th>联系方式2</th>
				<th>是否有效</th>
				<th>操作</th>
			</tr>
		</thead>
		<tbody>
		<c:forEach items="${page.list}" var="shopSaleChannel">
			<tr>
				<td><a href="${ctx}/shop/shopSaleChannel/view?id=${shopSaleChannel.id}">
					${fns:escapeHtml(shopSaleChannel.code)}
				</a></td>
				<td>
					${fns:escapeHtml(shopSaleChannel.name)}
				</td>
				<td>
					${fns:escapeHtml(shopSaleChannel.deptName)}
				</td>
				<td>
					${fns:escapeHtml(shopSaleChannel.position)}
				</td>
				<td>
					${fns:getDictLabel(shopSaleChannel.type, 'channel_type','' )}
				</td>
				<td>
					${fns:escapeHtml(shopSaleChannel.areaName)}
				</td>
				<td>
					${fns:escapeHtml(shopSaleChannel.linkMobile1)}
				</td>
				<td>
					${fns:escapeHtml(shopSaleChannel.linkMobile2)}
				</td>
				<td>
					${fns:getDictLabel(shopSaleChannel.isValid,'yes_no','')}
				</td>
				<td>
					<shiro:hasPermission name="shop:shopSaleChannel:edit">
    				<a href="${ctx}/shop/shopSaleChannel/form?id=${shopSaleChannel.id}">修改</a>
					</shiro:hasPermission>
					<shiro:hasPermission name="shop:shopSaleChannel:delete">
					<a href="${ctx}/shop/shopSaleChannel/delete?id=${shopSaleChannel.id}" onclick="return confirmx('确认要删除该销售渠道吗？', this.href)">删除</a>
					</shiro:hasPermission>
				</td>
			</tr>
		</c:forEach>
		</tbody>
	</table>
	<div class="pagination">${page}</div>
</body>
</html>