<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
	<title>俱乐部账户</title>
	<meta name="decorator" content="default"/>
	<script type="text/javascript">
		$(document).ready(function() {
			
		});
		function page(n,s){
			$("#pageNo").val(n);
			$("#pageSize").val(s);
			$("#searchForm").submit();
        	return false;
        }
	</script>
</head>
<body>
	<ul class="nav nav-tabs">
		<li><a href="${ctx}/shop/shopMember/moneyList">俱乐部账户收支信息</a></li>
		<li><a href="${ctx}/shop/shopMember/list">俱乐部账户</a></li>
		<shiro:hasPermission name="shop:shopMember:recharge">
			<li><a href="${ctx}/shop/shopMember/form">俱乐部充值</a></li>
			<li><a href="${ctx}/shop/shopMember/refund">俱乐部提现</a></li>
		</shiro:hasPermission>
		<li class="active"><a href="${ctx}/shop/shopMember/detail?memberCode=${shopMember.memberCode}">俱乐部账户收支明细</a></li>
	</ul>
		<div class="alert alert-warning" role="alert">
			<label>会员号:</label> ${fns:escapeHtml(shopMember.memberCode)}
			<label> 会员名称:</label> ${fns:escapeHtml(shopMember.orgName)}
			<label> 余额:</label> ${fns:escapeHtml(shopMember.userMoney)}
			<label> 返利:</label> ${fns:escapeHtml(shopMember.rebateMoney)}
			<label> 本金销售总额:</label> ${fns:escapeHtml(shopMember.userCountMoney)}
			<label> 返利销售总额:</label> ${fns:escapeHtml(shopMember.rebateCountMoney)}
			<a onclick="history.go(-1)">返回上一页</a>
		</div>
	<sys:message content="${message}"/>
	<table id="contentTable" class="table table-striped table-bordered table-condensed">
		<thead>
			<tr>
				<th>订单编号</th>
				<th>会员号</th>
				<th>订单金额</th>
				<th>支付方式</th>
				<th>支付类型</th>
				<th>操作员</th>
				<th>时间</th>
				<th>备注</th>
			</tr>
		</thead>
		<tbody>
		<c:forEach items="${list}" var="shopPayRecord">
			<tr>
				<td>
					${fns:escapeHtml(shopPayRecord.shopOrderCode)}
				</td>
				<td>
					${fns:escapeHtml(shopPayRecord.memberCode)}
				</td>
				<td>
					${fns:escapeHtml(shopPayRecord.paymentMoney)}
				</td>
				<td>
					${fns:getDictLabel(shopPayRecord.paymentWay, 'payment_way', '')}
				</td>
				<td>
						${fns:getDictLabel(shopPayRecord.paymentType, 'shop_payment_type', '')}
				</td>
				<td>
					${fns:escapeHtml(shopPayRecord.updateBy.name)}
				</td>
				<td>
					<fmt:formatDate value="${shopPayRecord.paymentTime}" pattern="yyyy-MM-dd HH:mm:ss"/>
				</td>
				<td>
						${fns:escapeHtml(shopPayRecord.paymentRemarks)}
				</td>
			</tr>
		</c:forEach>
		</tbody>
	</table>
</body>
</html>