<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
	<title>采样包日志管理</title>
	<meta name="decorator" content="default"/>
	<script type="text/javascript">
		$(document).ready(function() {
			//初始化
			//是否只读
			let isView = '${isView}';
			console.log(isView);
			if (isView == 1) {
				$('#btnSubmit').hide();
				$('#inputForm input').attr('disabled','true');
				$('#inputForm select').attr('disabled','true');
				$('#inputForm textarea').attr('disabled','true');
				$('#inputForm input').unbind();
				$('#btnCancel').removeAttr('disabled');
			}

			//表单
			$("#inputForm").validate({
				submitHandler: function(form){
					loading('正在提交，请稍等...');
					form.submit();
				},
				errorContainer: "#messageBox",
				errorPlacement: function(error, element) {
					$("#messageBox").text("输入有误，请先更正。");
					if (element.is(":checkbox")||element.is(":radio")||element.parent().is(".input-append")){
						error.appendTo(element.parent().parent());
					} else {
						error.insertAfter(element);
					}
				}
			});
		});
	</script>
</head>
<body>
	<ul class="nav nav-tabs">
		<li><a href="${ctx}/samplingFlowLog/samplingFlowLog/">采样包日志列表</a></li>
		<li class="active">
			<c:choose>
				<c:when test="${not empty samplingFlowLog.id and isView == 1}">
					<a href="${ctx}/samplingFlowLog/samplingFlowLog/viewForm?id=${samplingFlowLog.id}">采样包日志查看</a>
				</c:when>
				<c:when test="${not empty samplingFlowLog.id and isView == 0}">
					<a href="${ctx}/samplingFlowLog/samplingFlowLog/editForm?id=${samplingFlowLog.id}">采样包日志修改</a>
				</c:when>
				<c:otherwise>
					<a href="${ctx}/samplingFlowLog/samplingFlowLog/editForm?id=${samplingFlowLog.id}">采样包日志添加</a>
				</c:otherwise>
			</c:choose>
		</li>
	</ul><br/>
	<form:form id="inputForm" modelAttribute="samplingFlowLog" action="${ctx}/samplingFlowLog/samplingFlowLog/save" method="post" class="form-horizontal">
		<form:hidden path="id"/>
		<sys:message content="${message}"/>		
		<div class="control-group">
			<label class="control-label">采样包编号：</label>
			<div class="controls">
				<form:input path="samplingCode" htmlEscape="false" maxlength="32" class="input-xlarge required" disabled="true"/>
				<span class="help-inline"><font color="red">*</font> </span>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">流程类型：</label>
			<div class="controls">
				<form:select path="flowType" class="input-xlarge required" disabled="true">
					<form:option value="" label=""/>
					<form:options items="${fns:getDictList('sampling_log_flow_type')}" itemLabel="label" itemValue="value" htmlEscape="false"/>
				</form:select>
				<span class="help-inline"><font color="red">*</font> </span>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">操作信息：</label>
			<div class="controls">
				<form:input path="operData" htmlEscape="false" maxlength="64" class="input-xlarge " disabled="true"/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">操作者：</label>
			<div class="controls">
				<form:input path="operName" htmlEscape="false" maxlength="64" class="input-xlarge required" disabled="true"/>
				<span class="help-inline"><font color="red">*</font> </span>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">操作时间：</label>
			<div class="controls">
				<input name="operTime" type="text" readonly="readonly" maxlength="20" class="input-medium Wdate required"
					value="<fmt:formatDate value="${samplingFlowLog.operTime}" pattern="yyyy-MM-dd HH:mm:ss"/>"/>
				<span class="help-inline"><font color="red">*</font> </span>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">备注信息：</label>
			<div class="controls">
				<form:textarea path="remarks" htmlEscape="false" rows="4" maxlength="255" class="input-xxlarge "/>
			</div>
		</div>
		<div class="form-actions">
			<shiro:hasPermission name="sampling:samplingFlowLog:edit"><input id="btnSubmit" class="btn btn-primary" type="submit" value="保 存"/>&nbsp;</shiro:hasPermission>
			<input id="btnCancel" class="btn" type="button" value="返 回" onclick="history.go(-1)"/>
		</div>
	</form:form>
</body>
</html>