<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
	<title>会员统计报表管理</title>
	<meta name="decorator" content="default"/>
	<style type="text/css">
		.tb-head-custom{
			padding-left:20px!important;
		}
		.td-default{
			width:16%!important;
		}
		#searchForm{
		    position: fixed;
		    top: 0;
		    left: 0;
		    width: 100%; 
		}
		#seizeDiv{
			position: fixed;
		    top: 50px;
		    height: 10px;
		    background-color:white;
		    left: 0;
		    width: 100%;
		}
		.thead{
		    position: fixed;
		    top: 60px;
		    left: 0;
		    width: 100%;
		}
		#contentTable{
			margin-top:90px
		}
	</style>
	<script type="text/javascript">
		$(document).ready(function() {
			$("#btnSubmit").click(function(){
				var periodTypeVal = $("#periodType").find("option:selected").val();
				var periodNoVal = $("#periodNo"+periodTypeVal).val();
				if(periodTypeVal == "" || periodTypeVal == undefined || periodTypeVal == null ||
						periodNoVal == "" || periodNoVal == undefined || periodNoVal == null){
					top.layer.msg("请选择查询周期和年度后重试！");
				}else{
					periodNoVal = periodNoVal.replaceAll("第","").replaceAll("季度","").replaceAll("半年","");
					var periodNoArr = periodNoVal.split("-");
					$("#periodYear").val(periodNoArr[0]);
					$("#periodNo").val(periodNoArr.length>1?periodNoArr[1]:"1");
					$("#searchForm").submit();
				}
			});
			
			$("#btnExport").click(function(){
				var periodTypeVal = $("#periodType").find("option:selected").val();
				var periodNoVal = $("#periodNo"+periodTypeVal).val();
				if(periodTypeVal == "" || periodTypeVal == undefined || periodTypeVal == null ||
						periodNoVal == "" || periodNoVal == undefined || periodNoVal == null){
					top.layer.msg("请选择查询周期和年度后重试！");
				}else{
					top.$.jBox.confirm("确认要导出会员报表数据吗？","系统提示",function(v,h,f){
						if(v=="ok"){
							layer.load();
							$("#searchForm").attr("action","${ctx}/report/reportMemberArea/export");
							$("#searchForm").submit();
							setTimeout(function(){
								layer.closeAll('loading');
							},1500);
							$("#searchForm").attr("action","${ctx}/report/reportMemberArea");
						}
					},{buttonsFocus:1});
					top.$('.jbox-body .jbox-icon').css('top','55px');
				}
			});
			
			var periodTypeVal = $("#periodType").find("option:selected").val();
			$("#periodNo"+periodTypeVal).show();
			
		});
		function page(n,s){
			$("#pageNo").val(n);
			$("#pageSize").val(s);
			$("#searchForm").submit();
        	return false;
        }
		
		function initPeriodNo(){
			var periodTypeVal = $("#periodType").find("option:selected").val();
			$("#searchForm .period-no").val("");
			$("#searchForm .period-no").hide();
			$("#periodNo"+periodTypeVal).show();
		}
		
	</script>
</head>
<body>
	<form:form id="searchForm" modelAttribute="reportMemberArea" action="${ctx}/report/reportMemberArea/" method="post" class="breadcrumb form-search">
		<input id="pageNo" name="pageNo" type="hidden" value="${page.pageNo}"/>
		<input id="pageSize" name="pageSize" type="hidden" value="${page.pageSize}"/>
		<form:hidden path="periodNo"/>
		<form:hidden path="periodYear"/>
		<ul class="ul-form">
			<li><label>查询区域：</label>
				<form:select path="officeName" class="input-medium">
					<form:option value="">全部</form:option>
					<c:forEach items="${fns:getShowOfficeRegionNames()}" var="regionName">
						<form:option value="${regionName}">${regionName}</form:option>
					</c:forEach>
				</form:select>
			</li>
			<li><label>查询周期：</label>
				<form:select path="periodType" class="input-medium" onchange="initPeriodNo(this);">
					<form:option value="1">按月</form:option>
					<form:option value="3">按季度</form:option>
					<form:option value="6">按半年</form:option>
					<form:option value="12">按年</form:option>
				</form:select>
			</li>
			<li><label>查询年度：</label>
 				<input id="periodNo1" name="periodNo1" value="${reportMemberArea.periodNo1}" type='text' readonly="readonly" maxlength="20" class="period-no input-medium Wdate" onclick="WdatePicker({ dateFmt: 'yyyy-M'})" style="display:none;"/>
 				<input id="periodNo3" name="periodNo3" value="${reportMemberArea.periodNo3}" type='text' readonly="readonly" maxlength="20" class="period-no input-medium Wdate" onclick="WdatePicker({ dateFmt: 'yyyy-第M季度', isQuarter: true, isShowOK: false, disabledDates: ['....-0[5-9]-..', '....-1[0-2]-..'], startDate: '%y-01-01'})" style="display:none;"/>
 				<input id="periodNo6" name="periodNo6" value="${reportMemberArea.periodNo6}" type='text' readonly="readonly" maxlength="20" class="period-no input-medium Wdate" onclick="WdatePicker({ dateFmt: 'yyyy-第M半年', isQuarter: true, isShowOK: false, disabledDates: ['....-0[3-9]-..', '....-1[0-2]-..'], startDate: '%y-01-01'})" style="display:none;"/>
				<input id="periodNo12" name="periodNo12" value="${reportMemberArea.periodNo12}" type="text" readonly="readonly" maxlength="20" class="period-no input-medium Wdate" onclick="WdatePicker({ dateFmt: 'yyyy'})" style="display:none;"/>
			</li>
			<li class="btns"><input id="btnSubmit" class="btn btn-primary" type="button" value="查询"/></li>
			<li class="btns"><input id="btnExport" class="btn btn-primary" type="button" value="导出"/></li>
			<li class="clearfix"></li>
		</ul>
	</form:form>
	<sys:message content="${message}"/>
	<div id="seizeDiv"></div>
	<table class="table thead table-striped table-bordered table-condensed">
		<thead>
			<tr>
				<th class="tb-head-custom td-default">所属省份</th>
				<th class="tb-head-custom td-default">有效会员合计</th>
				<th class="tb-head-custom td-default">新增会员合计</th>
				<th class="tb-head-custom td-default">流失会员合计</th>
				<th class="tb-head-custom td-default">续费会员合计</th>
				<th class="tb-head-custom td-default">留存会员合计</th>
			</tr>
		</thead>
	</table>
	<table id="contentTable" class="table table-striped table-bordered table-condensed">
		<tbody>
		<c:forEach items="${page.list}" var="record">
			<tr>
				<td class="td-default">${record.province}</td>
				<td class="td-default">
					<ul class="ul-form">
						<li style="color:#18a689;"><label>合计：</label>${record.reportVo.validTotal['合计']}</li>
						<li><label>银卡：</label>${record.reportVo.validTotal['银卡']}</li>
						<li><label>金卡：</label>${record.reportVo.validTotal['金卡']}</li>
						<li><label>铂金：</label>${record.reportVo.validTotal['铂金卡']}</li>
						<li><label>紫金：</label>${record.reportVo.validTotal['紫金卡']}</li>
					</ul>
				</td>
				<td class="td-default">
					<ul class="ul-form">
						<li style="color:#18a689;"><label>合计：</label>${record.reportVo.addedTotal['合计']}</li>
						<li><label>银卡：</label>${record.reportVo.addedTotal['银卡']}</li>
						<li><label>金卡：</label>${record.reportVo.addedTotal['金卡']}</li>
						<li><label>铂金：</label>${record.reportVo.addedTotal['铂金卡']}</li>
						<li><label>紫金：</label>${record.reportVo.addedTotal['紫金卡']}</li>
					</ul>
				</td>
				<td class="td-default">
					<ul class="ul-form">
						<li style="color:#18a689;"><label>合计：</label>${record.reportVo.lossTotal['合计']}</li>
						<li><label>银卡：</label>${record.reportVo.lossTotal['银卡']}</li>
						<li><label>金卡：</label>${record.reportVo.lossTotal['金卡']}</li>
						<li><label>铂金：</label>${record.reportVo.lossTotal['铂金卡']}</li>
						<li><label>紫金：</label>${record.reportVo.lossTotal['紫金卡']}</li>
					</ul>
				</td>
				<td class="td-default">
					<ul class="ul-form">
						<li style="color:#18a689;"><label>合计：</label>${record.reportVo.renewalTotal['合计']}</li>
						<li><label>银卡：</label>${record.reportVo.renewalTotal['银卡']}</li>
						<li><label>金卡：</label>${record.reportVo.renewalTotal['金卡']}</li>
						<li><label>铂金：</label>${record.reportVo.renewalTotal['铂金卡']}</li>
						<li><label>紫金：</label>${record.reportVo.renewalTotal['紫金卡']}</li>
					</ul>
				</td>
				<td class="td-default">
					<ul class="ul-form">
						<li style="color:#18a689;"><label>合计：</label>${record.reportVo.keepTotal['合计']}</li>
						<li><label>银卡：</label>${record.reportVo.keepTotal['银卡']}</li>
						<li><label>金卡：</label>${record.reportVo.keepTotal['金卡']}</li>
						<li><label>铂金：</label>${record.reportVo.keepTotal['铂金卡']}</li>
						<li><label>紫金：</label>${record.reportVo.keepTotal['紫金卡']}</li>
					</ul>
				</td>
			</tr>
		</c:forEach>
		<c:if test="${not empty total}">
			<tr>
				<td class="td-default" style="background-color: #d9edf7;">合计</td>
				<td class="td-default" style="background-color: #d9edf7;">
					<ul class="ul-form">
						<li style="color:#18a689;"><label>合计：</label>${total.validTotal['合计']}</li>
						<li><label>银卡：</label>${total.validTotal['银卡']}</li>
						<li><label>金卡：</label>${total.validTotal['金卡']}</li>
						<li><label>铂金：</label>${total.validTotal['铂金卡']}</li>
						<li><label>紫金：</label>${total.validTotal['紫金卡']}</li>
					</ul>
				</td>
				<td class="td-default" style="background-color: #d9edf7;">
					<ul class="ul-form">
						<li style="color:#18a689;"><label>合计：</label>${total.addedTotal['合计']}</li>
						<li><label>银卡：</label>${total.addedTotal['银卡']}</li>
						<li><label>金卡：</label>${total.addedTotal['金卡']}</li>
						<li><label>铂金：</label>${total.addedTotal['铂金卡']}</li>
						<li><label>紫金：</label>${total.addedTotal['紫金卡']}</li>
					</ul>
				</td>
				<td class="td-default" style="background-color: #d9edf7;">
					<ul class="ul-form">
						<li style="color:#18a689;"><label>合计：</label>${total.lossTotal['合计']}</li>
						<li><label>银卡：</label>${total.lossTotal['银卡']}</li>
						<li><label>金卡：</label>${total.lossTotal['金卡']}</li>
						<li><label>铂金：</label>${total.lossTotal['铂金卡']}</li>
						<li><label>紫金：</label>${total.lossTotal['紫金卡']}</li>
					</ul>
				</td>
				<td class="td-default" style="background-color: #d9edf7;">
					<ul class="ul-form">
						<li style="color:#18a689;"><label>合计：</label>${total.renewalTotal['合计']}</li>
						<li><label>银卡：</label>${total.renewalTotal['银卡']}</li>
						<li><label>金卡：</label>${total.renewalTotal['金卡']}</li>
						<li><label>铂金：</label>${total.renewalTotal['铂金卡']}</li>
						<li><label>紫金：</label>${total.renewalTotal['紫金卡']}</li>
					</ul>
				</td>
				<td class="td-default" style="background-color: #d9edf7;">
					<ul class="ul-form">
						<li style="color:#18a689;"><label>合计：</label>${total.keepTotal['合计']}</li>
						<li><label>银卡：</label>${total.keepTotal['银卡']}</li>
						<li><label>金卡：</label>${total.keepTotal['金卡']}</li>
						<li><label>铂金：</label>${total.keepTotal['铂金卡']}</li>
						<li><label>紫金：</label>${total.keepTotal['紫金卡']}</li>
					</ul>
				</td>
			</tr>
		</c:if>
		</tbody>
	</table>
	<div class="pagination">${page}</div>
</body>
</html>