<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp" %>
<html>
<head>
	<title>美容资格证书换发管理</title>
	<meta name="decorator" content="default"/>
	<script type="text/javascript">
        $(document).ready(function () {

        });

        function page(n, s) {
            $("#pageNo").val(n);
            $("#pageSize").val(s);
            $("#searchForm").submit();
            return false;
        }
	</script>
</head>
<body>
<ul class="nav nav-tabs">
	<li class="active"><a href="${ctx}/groomer/groomerQualificationCertificateChange/">资格证书换发列表</a></li>
	<shiro:hasPermission name="groomer:groomerQualificationCertificateChange:add">
		<li><a href="${ctx}/groomer/groomerQualificationCertificateChange/editForm">资格证书换发新增</a></li>
	</shiro:hasPermission>
</ul>
<form:form id="searchForm" modelAttribute="groomerQualificationCertificateChange"
           action="${ctx}/groomer/groomerQualificationCertificateChange/" method="post" class="breadcrumb form-search">
	<input id="pageNo" name="pageNo" type="hidden" value="${page.pageNo}"/>
	<input id="pageSize" name="pageSize" type="hidden" value="${page.pageSize}"/>
	<ul class="ul-form">
		<li><label>会员号：</label>
			<form:input path="memberCode" htmlEscape="false" maxlength="32" class="input-medium"/>
		</li>
		<li><label>证书来源：</label>
			<form:select path="certificateSource" class="input-medium">
				<form:option value="" label=""/>
				<form:options items="${fns:getDictList('groomer_certificate_change_source')}" itemLabel="label"
				              itemValue="value" htmlEscape="false"/>
			</form:select>
		</li>
		<li><label>原证书级别：</label>
			<form:select path="certificateLevel" class="input-medium">
				<form:option value="" label=""/>
				<form:options items="${fns:getDictList('groomer_qualification_level')}" itemLabel="label"
				              itemValue="value" htmlEscape="false"/>
			</form:select>
		</li>
		<li><label>品种类别：</label>
			<form:input path="breedCate" htmlEscape="false" maxlength="64" class="input-medium"/>
		</li>
		<li><label>审查员：</label>
			<form:input path="reviewer" htmlEscape="false" maxlength="64" class="input-medium"/>
		</li>
		<li><label>订单号：</label>
			<form:input path="runningNumber" htmlEscape="false" maxlength="64" class="input-medium"/>
		</li>
		<li><label>支付状态：</label>
			<form:select path="paymentState" class="input-medium">
				<form:option value="" label=""/>
				<form:options items="${fns:getDictList('user_payment_state')}" itemLabel="label" itemValue="value"
				              htmlEscape="false"/>
			</form:select>
		</li>
		<li><label>审核状态：</label>
			<form:select path="reviewState" class="input-medium">
				<form:option value="" label=""/>
				<form:options items="${fns:getDictList('review_state')}" itemLabel="label" itemValue="value"
				              htmlEscape="false"/>
			</form:select>
		</li>
		<li class="btns"><input id="btnSubmit" class="btn btn-primary" type="submit" value="查询"/></li>
		<li class="clearfix"></li>
	</ul>
</form:form>
<sys:message content="${message}"/>
<table id="contentTable" class="table table-striped table-bordered table-condensed">
	<thead>
	<tr>
		<th>会员号</th>
		<th>证书来源</th>
		<th>原证书级别</th>
		<th>CKU证书级别</th>
		<th>品种类别</th>
		<th>审查员</th>
		<th>签发日期</th>
		<th>订单号</th>
		<th>支付状态</th>
		<th>审核状态</th>
		<shiro:hasPermission name="groomer:groomerQualificationCertificateChange:edit">
			<th>操作</th>
		</shiro:hasPermission>
	</tr>
	</thead>
	<tbody>
	<c:forEach items="${page.list}" var="groomerQualificationCertificateChange">
		<tr>
			<td>
					${groomerQualificationCertificateChange.memberCode}
			</td>
			<td>
					${fns:getDictLabel(groomerQualificationCertificateChange.certificateSource, 'groomer_certificate_source', '')}
			</td>
			<td>
					${fns:getDictLabel(groomerQualificationCertificateChange.certificateLevel, 'groomer_qualification_level', '')}
			</td>
			<td>
					${fns:getDictLabel(groomerQualificationCertificateChange.ckuCertificateLevel, 'groomer_qualification_level', '')}
			</td>
			<td>
					${groomerQualificationCertificateChange.breedCate}
			</td>
			<td>
					${groomerQualificationCertificateChange.reviewer}
			</td>
			<td>
				<fmt:formatDate value="${groomerQualificationCertificateChange.issueDate}" pattern="yyyy-MM-dd"/>
			</td>
			<td>
					${groomerQualificationCertificateChange.runningNumber}
			</td>
			<td>
				<c:choose>
					<c:when test="${groomerQualificationCertificateChange.paymentState=='1'}">
						<shiro:hasPermission name="groomer:groomerQualificationCertificateChange:pay">
							<a onclick="util.payBusinessOrderByDataId('cff9fc8be72b48f6ac3abc6b29dd518f','${groomerQualificationCertificateChange.memberCode}','${groomerQualificationCertificateChange.id}')">
								<font color="red">${fns:getDictLabel(groomerQualificationCertificateChange.paymentState,'user_payment_state','')}</font>
							</a>
						</shiro:hasPermission>
						<shiro:lacksPermission name="groomer:groomerQualificationCertificateChange:pay">
							<font color="red">${fns:getDictLabel(groomerQualificationCertificateChange.paymentState,'user_payment_state','')}</font>
						</shiro:lacksPermission>
					</c:when>
					<c:otherwise>
						<font color="green">${fns:getDictLabel(groomerQualificationCertificateChange.paymentState,'user_payment_state','')}</font>
					</c:otherwise>
				</c:choose>
			</td>
			<td>
				<shiro:hasPermission name="groomer:groomerQualificationCertificateChange:review">
					<c:choose>
						<c:when test="${groomerQualificationCertificateChange.paymentState=='2' and groomerQualificationCertificateChange.reviewState=='0'}">
							<a href="${ctx}/groomer/groomerQualificationCertificateChange/editForm?id=${groomerQualificationCertificateChange.id}">
									${fns:getDictLabel(groomerQualificationCertificateChange.reviewState, 'review_state', '')}
							</a>
						</c:when>
						<c:when test="${groomerQualificationCertificateChange.paymentState=='2' and groomerQualificationCertificateChange.reviewState!='1'}">
							<a href="${ctx}/groomer/groomerQualificationCertificateChange/editForm?id=${groomerQualificationCertificateChange.id}">
								<font color="red">${fns:getDictLabel(groomerQualificationCertificateChange.reviewState, 'review_state', '')}</font>
							</a>
						</c:when>
						<c:otherwise>
							${fns:getDictLabel(groomerQualificationCertificateChange.reviewState, 'review_state', '')}
						</c:otherwise>
					</c:choose>
				</shiro:hasPermission>
				<shiro:lacksPermission name="groomer:groomerQualificationCertificateChange:review">
					${fns:getDictLabel(groomerQualificationCertificateChange.reviewState, 'review_state', '')}
				</shiro:lacksPermission>
			</td>
			<td>
				<a href="${ctx}/groomer/groomerQualificationCertificateChange/viewForm?id=${groomerQualificationCertificateChange.id}">查看</a>
				<shiro:hasPermission name="groomer:groomerQualificationCertificateChange:edit">
					<a href="${ctx}/groomer/groomerQualificationCertificateChange/editForm?id=${groomerQualificationCertificateChange.id}">修改</a>
				</shiro:hasPermission>
				<shiro:hasPermission name="groomer:groomerQualificationCertificateChange:del">
					<c:if test="${groomerQualificationCertificateChange.paymentState != '2'}">
						<a href="${ctx}/groomer/groomerQualificationCertificateChange/delete?id=${groomerQualificationCertificateChange.id}"
						   onclick="return confirmx('确认要删除该资格证书换发记录吗？', this.href)">删除</a>
					</c:if>
				</shiro:hasPermission>
			</td>
		</tr>
	</c:forEach>
	</tbody>
</table>
<div class="pagination">${page}</div>
</body>
</html>