<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp" %>
<html>
<head>
    <title>美容官网信息管理</title>
    <meta name="decorator" content="default"/>
    <script type="text/javascript">
        $(document).ready(function () {
            //setup
            setSubType();
        });

        function page(n, s) {
            $("#pageNo").val(n);
            $("#pageSize").val(s);
            $("#searchForm").submit();
            return false;
        }

        //当前type
        var lastType = '${gcWebInfo.type}'

        function setSubType() {
            $('#subType').empty();
            const type = $("#type").val();
            let subTypeJson;
            if (type == '2') {
                subTypeJson = '${fns:getDictListJson('gc_web_lecture_type')}';
            } else if (type == '4') {
                subTypeJson = '${fns:getDictListJson('gc_web_org_type')}';
            }
            if (type == '2' || type == '4') {
                $('#subType').append("<option value =''>全部</option>");
                $.each(JSON.parse(subTypeJson), function (i, val) {
                    $('#subType').append("<option value ='" + val.value + "'>" + val.label + "</option>");
                });
                if (lastType == type) {
                    $('#subType').val('${gcWebInfo.subType}');
                } else {
                    $('#subType').val('');
                }
                $('#subType').trigger("change");
                $('#subTypeDiv').show();
            } else {
                $('#subTypeDiv').hide();
            }
            lastType = type;
        }
    </script>
</head>
<body>
<ul class="nav nav-tabs">
    <li class="active"><a href="${ctx}/gcWeb/info/">美容官网信息列表</a></li>
    <shiro:hasPermission name="gcWeb:info:add">
        <li><a href="${ctx}/gcWeb/info/form">美容官网信息添加</a></li>
    </shiro:hasPermission>
</ul>
<form:form id="searchForm" modelAttribute="gcWebInfo" action="${ctx}/gcWeb/info/" method="post"
           class="breadcrumb form-search">
    <input id="pageNo" name="pageNo" type="hidden" value="${page.pageNo}"/>
    <input id="pageSize" name="pageSize" type="hidden" value="${page.pageSize}"/>
    <ul class="ul-form">
        <li><label>类型：</label>
            <form:select path="type" class="input-medium" onchange="setSubType()">
                <form:option value="" label="全部"/>
                <form:options items="${fns:getDictList('gc_web_info_type')}" itemLabel="label" itemValue="value"
                              htmlEscape="false"/>
            </form:select>
        </li>
        <div id="subTypeDiv">
            <li><label>子类型：</label>
                <form:select path="subType" class="input-medium">
                    <form:option value="" label="全部"/>
                </form:select>
            </li>
        </div>
        <li><label>标题：</label>
            <form:input path="title" htmlEscape="false" maxlength="64" class="input-medium"/>
        </li>
        <li><label>显示标记：</label>
            <form:select path="showFlag" class="input-medium">
                <form:option value="" label="全部"/>
                <form:options items="${fns:getDictList('show_hide')}" itemLabel="label" itemValue="value"
                              htmlEscape="false"/>
            </form:select>
        </li>
        <li class="btns"><input id="btnSubmit" class="btn btn-primary" type="submit" value="查询"/></li>
        <li class="clearfix"></li>
    </ul>
</form:form>
<sys:message content="${message}"/>
<table id="contentTable" class="table table-striped table-bordered table-condensed">
    <thead>
    <tr>
        <th>类型</th>
        <c:choose>
            <c:when test="${empty gcWebInfo.type}">
                <th>子类型</th>
            </c:when>
            <c:when test="${gcWebInfo.type == 2}">
                <th>讲座类型</th>
            </c:when>
            <c:when test="${gcWebInfo.type == 4}">
                <th>合作机构类型</th>
            </c:when>
            <c:otherwise>
            </c:otherwise>
        </c:choose>
        <th>标题</th>
        <th>显示标记</th>
        <th>排序</th>
        <th>操作</th>
    </tr>
    </thead>
    <tbody>
    <c:forEach items="${page.list}" var="var">
        <tr>
            <td>
                    ${fns:getDictLabel(var.type, 'gc_web_info_type', '')}
            </td>
            <c:if test="${empty gcWebInfo.type || gcWebInfo.type == 2 || gcWebInfo.type == 4}">
                <td>
                    <c:choose>
                        <c:when test="${var.type == 2}">
                            ${fns:getDictLabel(var.subType, 'gc_web_lecture_type', '')}
                        </c:when>
                        <c:when test="${var.type == 4}">
                            ${fns:getDictLabel(var.subType, 'gc_web_org_type', '')}
                        </c:when>
                        <c:otherwise>
                        </c:otherwise>
                    </c:choose>
                </td>
            </c:if>
            <td>
                    ${var.title}
            </td>
            <td>
                    ${fns:getDictLabel(var.showFlag, 'show_hide', '')}
            </td>
            <td>
                    ${var.sort}
            </td>
            <td>
                <shiro:lacksPermission name="gcWeb:info:edit">
                    <a href="${ctx}/gcWeb/info/form?id=${var.id}">查看</a>
                </shiro:lacksPermission>
                <shiro:hasPermission name="gcWeb:info:edit">
                    <a href="${ctx}/gcWeb/info/form?id=${var.id}">修改</a>
                </shiro:hasPermission>
                <shiro:hasPermission name="gcWeb:info:edit">
                    <a href="${ctx}/gcWeb/info/delete?id=${var.id}"
                       onclick="return confirmx('确认要删除该美容官网信息吗？', this.href)">删除</a>
                </shiro:hasPermission>
            </td>
        </tr>
    </c:forEach>
    </tbody>
</table>
<div class="pagination">${page}</div>
</body>
</html>