<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp" %>
<html>
<head>
    <title>美容官网信息管理</title>
    <meta name="decorator" content="default"/>
    <link rel="stylesheet" type="text/css" href="${ctxStatic }/wangEditor/css/wangEditor.min.css">
    <script type="text/javascript" src="${ctxStatic}/wangEditor/js/wangEditor.min.js"></script>
    <script type="text/javascript">
        $(document).ready(function () {
            //setup
            setSubType();
            //富文本
            const editor = new wangEditor('content');
            // 上传图片
            editor.config.uploadImgUrl = '${ctx}/sys/file/editorUpload';
            editor.config.uploadParams = {module:'gcWeb'};
            editor.config.uploadImgFileName = 'editorImg';
            // 设置 headers
            editor.config.uploadHeaders = {
                'Accept': 'text/x-json'
            };
            // 隐藏掉插入网络图片功能。该配置，只有在你正确配置了图片上传功能之后才可用。
            editor.config.hideLinkImg = true;
            editor.create();

            //表单
            $("#inputForm").validate({
                submitHandler: function (form) {
                    loading('正在提交，请稍等...');
                    form.submit();
                },
                errorContainer: "#messageBox",
                errorPlacement: function (error, element) {
                    $("#messageBox").text("输入有误，请先更正。");
                    if (element.is(":checkbox") || element.is(":radio") || element.parent().is(".input-append")) {
                        error.appendTo(element.parent().parent());
                    } else {
                        error.insertAfter(element);
                    }
                }
            });
        });

        //当前type
        var lastType = '${gcWebInfo.type}'

        function setSubType() {
            $('#subType').empty();
            const type = $("#type").val();
            let subTypeJson;
            if (type == '2') {
                subTypeJson = '${fns:getDictListJson('gc_web_lecture_type')}';
            } else if (type == '4') {
                subTypeJson = '${fns:getDictListJson('gc_web_org_type')}';
            }
            if (type == '2' || type == '4') {
                $('#subType').append("<option value =''>全部</option>");
                $.each(JSON.parse(subTypeJson), function (i, val) {
                    $('#subType').append("<option value ='" + val.value + "'>" + val.label + "</option>");
                });
                if (lastType == type) {
                    $('#subType').val('${gcWebInfo.subType}');
                } else {
                    $('#subType').val('');
                }
                $('#subType').trigger("change");
                $('#subTypeDiv').show();
            } else {
                $('#subTypeDiv').hide();
            }
            lastType = type;
        }
    </script>
</head>
<body>
<ul class="nav nav-tabs">
    <li><a href="${ctx}/gcWeb/info/">美容官网信息列表</a></li>
    <li class="active">
        <a href="${ctx}/gcWeb/info/form?id=${gcWebInfo.id}">美容官网信息
            <shiro:hasPermission name="gcWeb:info:edit">${not empty gcWebInfo.id?'修改':'添加'}</shiro:hasPermission>
            <shiro:lacksPermission name="gcWeb:info:edit">查看</shiro:lacksPermission>
        </a>
    </li>
</ul>
<br/>
<form:form id="inputForm" modelAttribute="gcWebInfo" action="${ctx}/gcWeb/info/save" method="post"
           class="form-horizontal">
    <form:hidden path="id"/>
    <sys:message content="${message}"/>
    <div class="control-group">
        <label class="control-label">类型：</label>
        <div class="controls">
            <form:select path="type" class="input-xlarge required" onchange="setSubType()">
                <form:option value="" label=""/>
                <form:options items="${fns:getDictList('gc_web_info_type')}" itemLabel="label" itemValue="value"
                              htmlEscape="false"/>
            </form:select>
            <span class="help-inline"><font color="red">*</font> </span>
        </div>
    </div>
    <div id="subTypeDiv" class="control-group">
        <label class="control-label">子类型：</label>
        <div class="controls">
            <form:select path="subType" class="input-xlarge">
                <form:option value="" label=""/>
                <form:options items="${fns:getDictList('gc_web_lecture_type')}" itemLabel="label" itemValue="value"
                              htmlEscape="false"/>
            </form:select>
        </div>
    </div>
    <div class="control-group">
        <label class="control-label">标题：</label>
        <div class="controls">
            <form:input path="title" htmlEscape="false" maxlength="64" class="input-xxlarge required"/>
            <span class="help-inline"><font color="red">*</font> </span>
        </div>
    </div>
    <div class="control-group">
        <label class="control-label">图片：</label>
        <div class="controls">
            <c:choose>
                <c:when test="${!empty gcWebInfo.image}">
                    <img id="previewImage" src="${gcWebInfo.image}" style="padding:10px;height:130px;"/>
                </c:when>
                <c:otherwise>
                    <img id="previewImage"/>
                </c:otherwise>
            </c:choose>
            <div style="width: 300px">
                <sys:ossUpload module="gcWebInfoImage" maxCount="1" maxSize="5" successHideFile="true"
                               successCallback="uploadImageCallBack"/>
            </div>
            <form:input path="image" htmlEscape="false" maxlength="255" class="input-xlarge " type="hidden"/>
            <!-- 文件上传成功的回调方法 -->
            <script type="text/javascript">
                function uploadImageCallBack(file, res) {
                    $("#image").val(res.fileUrl);
                    $("#previewImage").attr("src", res.fileUrl)
                    $("#previewImage").attr("style", "padding:10px;height:130px;");
                }
            </script>
        </div>
    </div>
    <div class="control-group">
        <label class="control-label">链接：</label>
        <div class="controls">
            <form:input path="url" htmlEscape="false" maxlength="32" class="input-xlarge "/>
        </div>
    </div>
    <div class="control-group">
        <label class="control-label">显示标记：</label>
        <div class="controls">
            <form:select path="showFlag" class="input-xlarge required">
                <form:option value="" label=""/>
                <form:options items="${fns:getDictList('show_hide')}" itemLabel="label" itemValue="value"
                              htmlEscape="false"/>
            </form:select>
            <span class="help-inline"><font color="red">*</font> </span>
        </div>
    </div>
    <div class="control-group">
        <label class="control-label">排序：</label>
        <div class="controls">
            <form:input path="sort" htmlEscape="false" maxlength="11" class="input-xlarge  digits"/>
        </div>
    </div>
    <div class="control-group">
        <label class="control-label">内容：</label>
        <div class="controls">
            <form:textarea path="content" htmlEscape="true" style="height:400px"/>
        </div>
    </div>
    <div class="control-group">
        <label class="control-label">备注：</label>
        <div class="controls">
            <form:textarea path="remarks" htmlEscape="false" rows="4" maxlength="1000" class="input-xxlarge "/>
        </div>
    </div>
    <div class="form-actions">
        <shiro:hasPermission name="gcWeb:info:edit">
            <input id="btnSubmit" class="btn btn-primary" type="submit" value="保 存"/>&nbsp;
        </shiro:hasPermission>
        <input id="btnCancel" class="btn" type="button" value="返 回" onclick="history.go(-1)"/>
    </div>
</form:form>
</body>
</html>