<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
	<title>订单管理</title>
	<meta name="decorator" content="default"/>
	<script type="text/javascript">
        $(document).ready(function() {

        });
        var submitFlag=true;
        function page(n,s){
            $("#pageNo").val(n);
            $("#pageSize").val(s);
            $("#searchForm").submit();
            return false;
        }
        function refundAgreeMatch(businessOrderCode,businessId){
        	if(!submitFlag){
        		return;
        	}
        	var content = {
       		    state1: {
       		        content: '<div style="padding: 10px;margin-left: 40px;"><span class="jbox-icon jbox-icon-info" style="position:absolute; top:50px;left:15px; width:32px; height:32px;"></span>确认同意吗？</div>',
       		        buttons: {'确定': 1,'取消': 0},
       		        buttonsFocus: 0,
       		        submit: function (v, h, f) {
       		            if (v == 0) {
       		                return true;
       		            }
       		            else{
       		            	$.jBox.nextState();
       		            }
       		            return false;
       		        }
       		    },
       		    state2: {
       		        content: '<div style="padding: 10px;margin-left: 40px;"><span class="jbox-icon jbox-icon-info" style="position:absolute; top:50px;left:15px; width:32px; height:32px;"></span>赛事退费收取 “30%” 手续费，本次是否全额退费？</div>',
       		        buttons: { '正常退费': 1, '全额退费': 0 },
       		        buttonsFocus: 0,
       		        submit: function (v, h, f) {
       		            if (v == 0) {
       		            	refundAgreeCommon(businessOrderCode,true);
       		            } else {
       		            	refundAgreeCommon(businessOrderCode,false);
       		            }
       		            return false;
       		        }
       		    }
       		};
        	$.jBox(content);
        	top.$('.jbox-body .jbox-icon').css('top','55px');
        }
        function refundAgree(businessOrderCode){
        	if(!submitFlag){
        		return;
        	}
        	top.$.jBox.confirm("确认同意吗？","系统提示",function(v,h,f){
				if(v=="ok"){
					refundAgreeCommon(businessOrderCode,false);
				}
			},{buttonsFocus:1});
			top.$('.jbox-body .jbox-icon').css('top','55px');
        }
        
        function refundAgreeCommon(businessOrderCode,matchFullRefundFlag){
        	$.ajax({
                type:"POST",
                url: ctx+"/finance/paymentOrder/refundAgree?matchFullRefundFlag="+matchFullRefundFlag,
                data : {'businessOrderCode':businessOrderCode},
                dataType: 'json',
                beforeSend: function () {
                	submitFlag=false;
                	loading('正在提交，请稍等...');
                },
                success: function(json){
                	if (json.code=='0') {
                		$("#searchForm").submit();
					}else{
						$.jBox.alert(json.msg,"提示");
						closeLoading();
					}
                }
			});
        }
        
        function refundDisagree(businessOrderCode){
        	if(!submitFlag){
        		return;
        	}
        	top.$.jBox.confirm("确认不同意吗？","系统提示",function(v,h,f){
				if(v=="ok"){
		        	$.ajax({
		                type:"POST",
		                url: ctx+"/finance/paymentOrder/refundDisagree",
		                data :  {'businessOrderCode':businessOrderCode},
		                dataType: 'json',
		                beforeSend: function () {
		                	submitFlag=false;
		                	loading('正在提交，请稍等...');
		                },
		                success: function(json){
		                	if (json.code=='0') {
		                		$("#searchForm").submit();
						}else{
							$.jBox.alert(json.msg,"提示");
						}
		                }
					}); 
				}
			},{buttonsFocus:1});
		top.$('.jbox-body .jbox-icon').css('top','55px');
		
        }
        
       function  showApplyDiscount(discountSign,orderCode,showMainId){
   			parent.layer.open({
   				type: 2,
   				title: ['参与减免信息', 'font-size:18px;text-align: center;'],
   				shadeClose: false,
   				shade: [0.8, '#393D49'],
   				maxmin: true, //开启最大化最小化按钮
   				area: ['1300px', '600px'],
				content : "${ctx}/finance/paymentOrder/applyDiscountList?discountSign=" + discountSign
										+ "&orderCode=" + orderCode
										+ "&showMainId=" + showMainId
					});
			return false;
		}
		//批量审核通过
		function listSubmit() {
			if (!submitFlag) {
				return;
			}
			top.$.jBox.confirm("确认同意吗？<br>赛事如需全额退费，请单独退费！", "系统提示", function(v,
					h, f) {
				if (v == "ok") {
					var arry = [];
					$(".checkedId:checked").each(
							function() {
								var obj = {};
								obj.businessOrderCode = $(this).attr(
										"businessOrderCode");
								arry.push(obj);
							});
					var josn = JSON.stringify(arry);
					if (josn != "" && josn != "[]") {
						$.ajax({
							type : "POST",
							url : ctx + "/finance/paymentOrder/refundAgreeALL",
							data : {
								'ids' : arry
							},
							dataType : 'json',
							beforeSend : function() {
								submitFlag = false;
								loading('正在提交，请稍等...');
							},
							success : function(json) {
								if (json.code == '0') {
									$("#searchForm").submit();
								} else {
									$.jBox.alert(json.msg, "提示");
								}
							}
						});
					} else {
						$.jBox.alert("请勾选需要通过的退款");
					}
				}
			}, {
				buttonsFocus : 1
			});
			top.$('.jbox-body .jbox-icon').css('top', '55px');
		}
	</script>
</head>
<body>
<ul class="nav nav-tabs">
	<li class="active"><a href="${ctx}/finance/paymentOrder/refundList">退款审核列表</a></li>
	
</ul>
<form:form id="searchForm" modelAttribute="refundOrder" action="${ctx}/finance/paymentOrder/refundList" 
		method="post" class="breadcrumb form-search">
	<input id="pageNo" name="pageNo" type="hidden" value="${page.pageNo}"/>
	<input id="pageSize" name="pageSize" type="hidden" value="${page.pageSize}"/>
	<ul class="ul-form">
		<li><label>会员号/名称：</label>
		 <form:input path="memberCode" maxlength="100" class="input-medium"/> 
		</li>
		<li><label>订单编号：</label>
		 <form:input path="orderCode" maxlength="100" class="input-medium"/> 
		</li>
		<li><label>所属部门：</label>
			<form:select  path="department"  class="input-small" >
			<form:option value="" label="全部" htmlEscape="false"/>
				<c:forEach items="${departmentList}" var="item">
					<form:option value="${item}" label="${item}" htmlEscape="false"/>
				</c:forEach>
		      </form:select>
		</li>
		
		
		<li><label>审核状态：</label>
			<form:select path="businessRefundState" class="input-small">
				<form:option value="">全部</form:option>
				<form:option value="1" label="退费审核中"/>
				<form:option value="3" label="通过"/>
				<form:option value="2" label="未通过"/>
			</form:select>
		</li>
		<li><label>申请起止时间：</label>
			<input name="beginUpdateDate" type="text" readonly="readonly" maxlength="20" class="input-medium Wdate"
				   value="<fmt:formatDate value="${refundOrder.beginUpdateDate}" pattern="yyyy-MM-dd"/>"
				   onclick="WdatePicker({dateFmt:'yyyy-MM-dd',isShowClear:true});"/> -
			<input name="endUpdateDate" type="text" readonly="readonly" maxlength="20" class="input-medium Wdate"
				   value="<fmt:formatDate value="${refundOrder.endUpdateDate}" pattern="yyyy-MM-dd"/>"
				   onclick="WdatePicker({dateFmt:'yyyy-MM-dd',isShowClear:true});"/>
		</li>
		<li class="btns"><input id="btnSubmit" class="btn btn-primary" type="submit" value="查询"/></li>
		<li class="btns">
			<input onclick="listSubmit()" class="btn btn-primary" type="button" value="一键通过"/>
		</li>
		
		<li class="clearfix"></li>
		
	</ul>
</form:form>
<sys:message content="${message}"/>
<table id="contentTable" class="table table-striped table-bordered table-condensed">
	<thead>
	<tr>
	<th>选择</th>
		<th>会员名称</th>
				<th>会员编号</th>
				<th>业务名称</th>
				<th>所属部门</th>
				<th>订单编号</th>
				<th>缴费时间</th>
				<th>退款金额</th>
				<th>业务详情</th>
				<th>申请时间</th>
				<th>退款原因</th>
				<th>退款状态</th>
				<th>审核</th>

	<!--	<shiro:hasPermission name="finance:paymentOrderProject:view">
			
		</shiro:hasPermission>  -->
	</tr>
	</thead>
	<tbody>
	<c:forEach items="${page.list}" var="refundOrder">
		<tr>
		     <td> <input type="checkbox" class="checkedId" businessOrderCode="${fns:escapeHtml(refundOrder.businessOrderCode)}" 
		     	${refundOrder.businessRefundState==1?"":"disabled"}  > 
		         
		      </td>
			<td>
					${fns:escapeHtml(refundOrder.memberName)}
			</td>
			<td>
					${fns:escapeHtml(refundOrder.memberCode)}
			</td>
				<td>
					${refundOrder.businessName}
			</td>
			<td>
					${fns:escapeHtml(refundOrder.department)}
			</td>
			<td>
					${fns:escapeHtml(refundOrder.orderCode)} 
					<c:if test="${not empty refundOrder.cycleSign }">
						 <a href="javascript:void(0);" onclick="showApplyDiscount('${refundOrder.discountSign}' , '${refundOrder.orderCode}' , '${refundOrder.showMainId }') ">参与减免</a>
					</c:if> 
			</td>
			<td>
				<fmt:formatDate value="${refundOrder.paymentTime}" pattern="yyyy-MM-dd HH:mm:ss"/>
			</td>
			
			<td>
					${refundOrder.totalPrice}
			</td>
			<td>
			     <a href="${ctx}/finance/paymentOrder/refundList/business?businessTable=${refundOrder.businessTable}" >
			     	${refundOrder.businessName}
			     </a>
			</td>
			
			<td>
				<fmt:formatDate value="${refundOrder.businessRefundTime}" pattern="yyyy-MM-dd HH:mm:ss"/>
			</td>
			
			<td>
					${refundOrder.businessRefundReason}
			</td>
			<td>
			    <c:if test="${refundOrder.businessRefundState==1}">退费审核中</c:if>
				<c:if test="${refundOrder.businessRefundState==3}">通过</c:if>
				<c:if test="${refundOrder.businessRefundState==2}">未通过</c:if>
			</td>
			
		
			<!--<shiro:hasPermission name="finance:paymentOrderProject:view">-->
				<td>
				  <c:if test="${refundOrder.businessRefundState==1}">
				  	<c:choose>
					    <c:when test="${refundOrder.businessId == '1027' || refundOrder.businessId == '1030'  || refundOrder.businessId == '1033'  || refundOrder.businessId == '1036'
				  	 || refundOrder.businessId == '1039'  || refundOrder.businessId == '1042'  || refundOrder.businessId == '1070'  || refundOrder.businessId == '1073'}">
					    	<a  href="#" onclick="refundAgreeMatch('${refundOrder.businessOrderCode}')"> 通过 </a>
					    </c:when>
					    <c:otherwise>
					    	<a  href="#" onclick="refundAgree('${refundOrder.businessOrderCode}')"> 通过 </a>
					    </c:otherwise>
					</c:choose>
					<br/>
			        <a  href="#"  onclick="refundDisagree('${refundOrder.businessOrderCode}')"> 不通过 </a>
				  
				  </c:if>
				
				</td>
			<!--</shiro:hasPermission>-->
		</tr>
	</c:forEach>
	</tbody>
</table>
<div class="pagination">${page}</div>
</body>
</html>