<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
	<title>合并会员扣款</title>
	<meta name="decorator" content="default"/>
	<script type="text/javascript">
		$(document).ready(function() {
		});
		function closeLayer(){
			parent.layer.closeAll();
		}
		function save(){
			var price1 = $("#price1").val();
			var paymentAmount1 = $("#paymentAmount1").val();
			var paymentRemarks1 = $("#paymentRemarks1").val();
			
			var price2 = $("#price2").val();
			var paymentAmount2 = $("#paymentAmount2").val();
			var paymentRemarks2 = $("#paymentRemarks2").val();
			var accountBalance = $("#accountBalance").val();
			if(parseFloat(paymentAmount1)<0){
				alert("实扣金额1应大于零！");
				return;
			};
			if(parseFloat(paymentAmount2)<0){
				alert("实扣金额1应大于零！");
				return;
			};
			if(parseFloat(paymentAmount1)+parseFloat(paymentAmount2)-parseFloat(accountBalance)>0){
				alert("实扣金额应大于会员余额！");
				return;
			}
			if(price1!=paymentAmount1){
				if(paymentRemarks1.replace(/(^\s+)|(\s+$)/g,"").length==0){
					alert("请填写应付款1的说明！");
					return;
				}
			}
			if(price2!=paymentAmount2){
				if(paymentRemarks2.replace(/(^\s+)|(\s+$)/g,"").length==0){
					alert("请填写应付款1的说明！");
					return;
				}
			}
			$.ajax({
				type: "POST",
				url:"${ctx}/finance/deductCost/mergePaySave",
				dataType:"json",
				data:$('#inputForm').serialize(),// 你的formid
				async: false,
				error: function(request, textStatus, errorThrown) {
					alert("系统错误，请联系管理员！");
				},
				success: function(data) {
					if(data.rc==0){
						alert("扣款成功！");
						parent.isYes = true;
						parent.layer.closeAll();
					}else{
						alert("错误代码："+data.rc+"错误信息："+data.msg);
					}
				}
			});
		}
	</script>
	<style>
		form{
			padding-top: 20px;
		}
		.control-group{
			border-bottom: 0px;
		}
	</style>
	<link rel="stylesheet" href="${ctxStatic }/modules/common/two-column.css"/>
</head>
<body>


<form:form id="inputForm" modelAttribute="member" class="form-horizontal">
	<input type="hidden" name="businessId" value="${id }">
	<div class="control-group" style="width:100%">
		<label class="control-label">会员编号：</label>
		<div class="controls">
			<input type="text" readonly="readonly" name="memberCode" value="${memberForm.memberCode}"  maxlength="60" class="input-xlarge"/>
		</div>
	</div>
	<div style="clear:both;"></div>
	<div class="control-group" style="width:100%">
		<label class="control-label">姓名：</label>
		<div class="controls">
			<input type="text" readonly="readonly" value="${memberForm.name}" maxlength="100" class="input-xlarge"/>
		</div>
	</div>
	<div style="clear:both;" ></div>
	<div class="control-group" style="width:100%">
		<label class="control-label">会员余额：</label>
		<div class="controls">
			<input type="text" readonly="readonly" id="accountBalance" value="${memberForm.accountBalance}" class="input-xlarge">
		</div>
	</div>
	<div style="clear:both;"></div>
	<c:forEach items="${payTypes}" var="pay" varStatus="status">
	<div class="control-group">
		<label class="control-label">扣费类型${status.count }：</label>
		<div class="controls">
			<input type="text" readonly="readonly" value="${pay.name}" class="input-xlarge">
			<input type="hidden" name="chargingItemId${status.count }" value="${pay.id}">
		</div>
	</div>
	</c:forEach>
	<c:forEach items="${payTypes}" var="pay" varStatus="status">
	<div class="control-group">
		<label class="control-label">应扣金额${status.count }：</label>
		<div class="controls">
			<input type="text" readonly id="price${status.count }" name="price${status.count }" value="${pay.price}" class="input-xlarge">
		</div>
	</div>
	</c:forEach>
	<c:forEach items="${payTypes}" var="pay" varStatus="status">
	<div class="control-group">
		<label class="control-label">实扣金额${status.count }：</label>
		<div class="controls">
			<input type="number" step="0.01" min="0" id="paymentAmount${status.count }"  <shiro:lacksPermission name="finance:deductCost:other">readonly</shiro:lacksPermission> name="paymentAmount${status.count }" value="${pay.price}" placeholder="实扣金额！" class="input-xlarge">
		</div>
	</div>
	</c:forEach>
	<c:forEach items="${payTypes}" var="pay" varStatus="status">
	<div class="control-group">
		<label class="control-label">说明${status.count }：</label>
		<div class="controls">
			<textarea  class="form-control input-xlarge" id="paymentRemarks${status.count }" name="paymentRemarks${status.count }"  rows="3" placeholder="请填写说明！"></textarea>
		</div>
	</div>
	</c:forEach>
	
	<div style="clear:both;"></div>
	<div class="control-group" style="text-align: center;width:100%">
		<input id="btnSubmit" class="btn btn-primary" type="button" value="保 存" onclick="save()"/>&nbsp;
		<input id="btnCancel" class="btn" type="button" value="关 闭" onclick="closeLayer()"/>
	</div>
</form:form>
</body>
</html>