<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
	<title>新生犬登记管理</title>
	<meta name="decorator" content="default"/>
	<script type="text/javascript">
		$(document).ready(function() {
			//$("#name").focus();
			$("#inputForm").validate({
				submitHandler: function(form){
					loading('正在提交，请稍等...');
					form.submit();
				},
				errorContainer: "#messageBox",
				errorPlacement: function(error, element) {
					$("#messageBox").text("输入有误，请先更正。");
					if (element.is(":checkbox")||element.is(":radio")||element.parent().is(".input-append")){
						error.appendTo(element.parent().parent());
					} else {
						error.insertAfter(element);
					}
				}
			});
			if($("#reviewState").val()==2){
				$("#reviewDiv").show();
			} else {
				$("#reviewDiv").hide();
			}
		});
		function closeLayer(){
			parent.isYes = false;
            parent.layer.closeAll();
        }
		function changeState(val){
			 if(val==2){
				 $("#reviewDiv").show();
			 } else {
				 $("#reviewDiv").hide();
				 $("#reviewRemarks").val('');
			 }
		}
		function save(){
			$.ajax({
                type: "POST",
                url:"${ctx}/newdogchip/dogChip/changeStatus",
                dataType:"json",
                data:$('#inputForm').serialize(),
                async: false,
                error: function(request, textStatus, errorThrown) {
                    alert("系统错误，请联系管理员！");
                },
                success: function(data) {
                	if(data.rc==0){
                		alert("审核成功");
                		parent.isYes = true;
                        parent.layer.closeAll();
                	}else {
                		alert("错误代码："+data.rc+"错误信息："+data.msg);
                		parent.isYes = false;
                		parent.layer.closeAll();
                	}
                }
            });
		}
	</script>
</head>
<body>
	<form:form id="inputForm" modelAttribute="dogChip" action="${ctx}/newdogchip/dogChip/changeStatus" method="post" class="form-horizontal">
		<form:hidden path="id"/>
		<sys:message content="${message}"/>		
		<div class="control-group">
		</div>
		<div class="control-group">
			<label class="control-label">出生纸编号：</label>
			<div class="controls">
				<form:input path="birthCode" htmlEscape="false" maxlength="64" class="input-xlarge " readonly="true"/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">犬主人：</label>
			<div class="controls">
				<form:input path="dogBirthCertificate.dogOwenr" htmlEscape="false" maxlength="64" class="input-xlarge " readonly="true"/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">申请日期：</label>
			<div class="controls">
				<input name="createDate" type="text" readonly="readonly" maxlength="20" class="input-medium Wdate "
                    value="<fmt:formatDate value="${dogChip.createDate}" pattern="yyyy-MM-dd HH:mm:ss"/>"
                    onclick="WdatePicker({dateFmt:'yyyy-MM-dd HH:mm:ss',isShowClear:true});" disabled="disabled"/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">申请医院：</label>
			<div class="controls">
				<form:input path="sysOrg.name" htmlEscape="false" maxlength="64" class="input-xlarge " readonly="true"/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">审核状态：</label>
			<div class="controls">
				<form:select path="reviewState" class="input-xlarge " style="width: 80px;"  onclick="changeState(this.value)" disabled="true">
					<form:option value="" label=""/>
					<form:options items="${fns:getDictList('review_state')}" itemLabel="label" itemValue="value" htmlEscape="false"/>
				</form:select>
			</div>
		</div>
		<div class="control-group" id="reviewDiv">
			<label class="control-label">未通过原因：</label>
			<div class="controls">
                <form:textarea path="reviewRemarks" htmlEscape="false" rows="3" maxlength="255" class="form-control input-xlarge" readonly="true"/>
            </div>
		</div>
		<div class="form-actions">
			<input id="btnCancel" class="btn" type="button" value="关闭" onclick="closeLayer()"/>
		</div>
	</form:form>
</body>
</html>