<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
    <title>犬只信息管理</title>
    <meta name="decorator" content="default"/>
    <script type="text/javascript">
        $(document).ready(function() {
            //$("#name").focus();
            $("#inputForm").validate({
                submitHandler: function(form){
                    loading('正在提交，请稍等...');
                    form.submit();
                },
                errorContainer: "#messageBox",
                errorPlacement: function(error, element) {
                    $("#messageBox").text("输入有误，请先更正。");
                    if (element.is(":checkbox")||element.is(":radio")||element.parent().is(".input-append")){
                        error.appendTo(element.parent().parent());
                    } else {
                        error.insertAfter(element);
                    }
                }
            });
        });
    </script>
</head>
<body>
<ul class="nav nav-tabs">
    <li><a href="${ctx}/dog/dog/${'230' eq dogdog.dogBreed?'?dogBreed=230':''}">犬只信息列表</a></li>
    <li class="active"><a href="${ctx}/dog/dog/view?id=${dog.id}">犬只信息查看</a></li>
</ul><br/>
<form:form id="inputForm" modelAttribute="dog" action="${ctx}/dog/dog/save" method="post" class="form-horizontal">
    <form:hidden path="id"/>
    <sys:message content="${message}"/>
    <div style="width: 100%">
        <div style="float: left ;width: 50%">
            <div class="control-group">
                <label class="control-label">犬只照片：</label>
                <div class="controls">
                    <img  style="width:180px; height: 190px"src="${dog.picture}">
                </div>
            </div>
        </div>
        <div style="float: left ;width: 50%">
            <div class="control-group">
                <label class="control-label">图片审核：</label>
                <div class="controls">
                    <form:select path="pictureReviewState" class="input-xlarge " >
                        <form:option value="" label=""/>
                        <form:option value="0" label="待审核"/>
                        <form:option value="1" label="通过"/>
                        <form:option value="2" label="未通过"/>
                    </form:select>
                </div>
            </div>
            <div class="control-group">
                <label class="control-label">未通过原因：</label>
                <div class="controls">
                    <form:textarea path="pictureReviewRemark" htmlEscape="false" maxlength="255" class="input-xlarge "/>
                </div>
            </div>
        </div>
    </div>
    <div style="clear:both;"/>
    <div class="control-group">
        <label class="control-label">出生证明编号：</label>
        <div class="controls">
            <form:input path="birthCertificateLevelCode" htmlEscape="false" maxlength="64" class="input-xlarge " readonly="true"/>
        </div>
    </div>
    <div class="control-group">
        <label class="control-label">性别：</label>
        <div class="controls">
            <form:radiobuttons path="gender" items="${fns:getDictList('dog_gender')}" itemLabel="label" itemValue="value" htmlEscape="false" class="required" disabled="true"/>
            <font color="#FF0000">* </font>
        </div>
    </div>
    <div class="control-group" style="float: left">
        <label class="control-label">犬只代数：</label>
        <div class="controls">
            <form:input path="dogGeneration" readonly="true" htmlEscape="false" maxlength="64"
                        class="input-xlarge "/>
        </div>
    </div>
    <div class="control-group" >
        <label class="control-label">犬只呼名：</label>
        <div class="controls">
            <form:input path="callName" readonly="true" htmlEscape="false" maxlength="4" class="input-xlarge "/>
        </div>
    </div>
    <div class="control-group">
        <label class="control-label">犬只状态：</label>
        <div class="controls">
            <form:select path="dogState" class="input-medium" disabled="true">
                <form:option value="" label="全部"/>
                <form:options items="${fns:getDictList('dogState')}" itemLabel="label" itemValue="value"
                              htmlEscape="false"/>
            </form:select>
        </div>
    </div>
    <div class="control-group" style="float: left">
        <label class="control-label">血统证书号：</label>
        <div class="controls">
            <form:input path="pedigreeCertifiedCode" htmlEscape="false" maxlength="64" class="input-xlarge required" readonly="true"/>
            <font color="#FF0000">* </font>
        </div>
    </div>
    <div class="control-group">
        <label class="control-label">芯片号：</label>
        <div class="controls">
            <form:input path="identificationFlag" htmlEscape="false" maxlength="64" class="input-xlarge" readonly="true"/>
        </div>
    </div>
    <div class="control-group">
        <label class="control-label">宠爱护照号：</label>
        <div class="controls">
            <form:input path="cabPassport" htmlEscape="false" maxlength="64" class="input-xlarge" readonly="true"/>
        </div>
    </div>
    <div class="control-group" style="float: left">
        <label class="control-label">英文姓名：</label>
        <div class="controls">
            <form:input path="nameEn" htmlEscape="false" maxlength="255" class="input-xlarge required" readonly="true"/>
            <font color="#FF0000">* </font>
        </div>
    </div>
    <div class="control-group">
        <label class="control-label">中文姓名：</label>
        <div class="controls">
            <form:input path="nameCn" htmlEscape="false" maxlength="64" class="input-xlarge " readonly="true"/>
        </div>
    </div>
    <div class="control-group"  style="float: left">
        <label class="control-label">种类：</label>
        <div class="controls">
            <form:select id="dogBreed" path="dogBreed" class="input-xlarge" disabled="true">
                <form:option value="" label=""/>
                <form:options items="${dogBreedList}" itemLabel="breedEnName" itemValue="dogBreedCode" htmlEscape="false"/>
            </form:select>
            <font color="#FF0000">* </font>
        </div>
    </div>
    <div class="control-group">
        <label class="control-label">FCI赛事编码：</label>
        <div class="controls">
            <form:select id="showDogBreed" path="showDogBreed" class="input-xlarge" disabled="true">
                <form:option value="" label=""/>
                <form:options items="${showDogBreedList}" itemLabel="showEnName" itemValue="dogShowCode" htmlEscape="false"/>
            </form:select>
            <font color="#FF0000">* </font>
        </div>
    </div>
    <div class="control-group">
        <label class="control-label">出生日期：</label>
        <div class="controls">
            <input name="birthdate" type="text" readonly="readonly" maxlength="20" class="input-medium Wdate "
                   value="<fmt:formatDate value="${dog.birthdate}" pattern="yyyy-MM-dd"/>"
            />
        </div>
    </div>
    <div class="control-group" style="float: left">
        <label class="control-label">犬主人：</label>
        <div class="controls">
            <form:input path="dogOwner" htmlEscape="false" maxlength="64" class="input-xlarge " readonly="true"/>
        </div>
    </div>
    <div class="control-group">
        <label class="control-label">会员号：</label>
        <div class="controls">
            <form:input path="memberCode" htmlEscape="false" maxlength="100" class="input-xlarge " readonly="true"/>
        </div>
    </div>
    <div class="control-group" style="float: left">
        <label class="control-label">第二犬主人：</label>
        <div class="controls">
            <form:input path="secondDogOwner" htmlEscape="false" maxlength="64" class="input-xlarge " readonly="true"/>
        </div>
    </div>
    <div class="control-group">
        <label class="control-label">第二犬主会员号：</label>
        <div class="controls">
            <form:input path="secondOwnerMemberNum" htmlEscape="false" maxlength="64" class="input-xlarge " readonly="true"/>
        </div>
    </div>
    <div class="control-group" style="float: left">
        <label class="control-label">颜色及标志：</label>
        <div class="controls">
            <form:select id="colorFlag" path="colorFlag" class="input-xlarge" disabled="true">
                <form:option value="" label=""/>
                <form:options items="${dogColorMarkList}" itemLabel="dogColorMarkCn" itemValue="dogColorMarkCode" htmlEscape="false"/>
            </form:select>
        </div>
    </div>
    <div class="control-group">
        <label class="control-label">特殊标志：</label>
        <div class="controls">
            <form:input path="specialFlag" htmlEscape="false" maxlength="64" class="input-xlarge " readonly="true"/>
        </div>
    </div>
    <div class="control-group" style="float: left">
        <label class="control-label">配种证明号：</label>
        <div class="controls">
            <form:input path="fmdogBreedCertifiedCode" htmlEscape="false" maxlength="100" class="input-xlarge " readonly="true"/>
        </div>
    </div>
    <div class="control-group">
        <label class="control-label">DNA编号：</label>
        <div class="controls">
            <form:input path="dna" htmlEscape="false" maxlength="64" class="input-xlarge " readonly="true"/>
        </div>
    </div>
    <div class="control-group" style="float: left">
        <label class="control-label">父犬血统证书号：</label>
        <div class="controls">
            <form:input path="fdogPedigreeCertified" htmlEscape="false" maxlength="100" class="input-xlarge " readonly="true"/>
        </div>
    </div>
    <div class="control-group">
        <label class="control-label">母犬血统证书号：</label>
        <div class="controls">
            <form:input path="mdogPedigreeCertified" htmlEscape="false" maxlength="100" class="input-xlarge " readonly="true"/>
        </div>
    </div>
    <div class="control-group" style="float: left">
        <label class="control-label">比赛级别：</label>
        <div class="controls">
            <form:input path="showLevel" htmlEscape="false" maxlength="64" class="input-xlarge " readonly="true"/>
        </div>
    </div>
    <div class="control-group">
        <label class="control-label">比赛成绩：</label>
        <div class="controls">
            <form:input path="showGrade" htmlEscape="false" maxlength="100" class="input-xlarge " readonly="true"/>
        </div>
    </div>
    <div class="control-group" style="float: left">
        <label class="control-label">考试级别：</label>
        <div class="controls">
            <form:input path="testLevel" htmlEscape="false" maxlength="64" class="input-xlarge " readonly="true"/>
        </div>
    </div>
    <div class="control-group">
        <label class="control-label">考试成绩：</label>
        <div class="controls">
            <form:input path="testGrade" htmlEscape="false" maxlength="100" class="input-xlarge " readonly="true"/>
        </div>
    </div>
    <div class="control-group" style="float: left">
        <label class="control-label">旧血统证书号：</label>
        <div class="controls">
            <form:input path="pedigreeCertifiedOld" htmlEscape="false" maxlength="64" class="input-xlarge " readonly="true"/>
        </div>
    </div>
    <div class="control-group">
        <label class="control-label">国外血统证书号：</label>
        <div class="controls">
            <form:input path="pedigreeCertifiedEn" htmlEscape="false" maxlength="64" class="input-xlarge " readonly="true"/>
        </div>
    </div>
    <div class="control-group" style="float: left">
        <label class="control-label">肘关节鉴定结果：</label>
        <div class="controls">
            <form:input path="elbowQualificationResult" htmlEscape="false" maxlength="64" class="input-xlarge " readonly="true"/>
        </div>
    </div>
    <div class="control-group">
        <label class="control-label">髋关节鉴定结果：</label>
        <div class="controls">
            <form:input path="hipQualificationResult" htmlEscape="false" maxlength="255" class="input-xlarge " readonly="true"/>
        </div>
    </div>
    <div class="control-group" style="float: left">
        <label class="control-label">繁殖资格：</label>
        <div class="controls">
            <form:input path="breedQualification" htmlEscape="false" maxlength="64" class="input-xlarge " readonly="true"/>
        </div>
    </div>
    <div class="control-group">
        <label class="control-label">繁殖禁止：</label>
        <div class="controls">
            <form:select path="businessBan" class="input-xlarge ">
                <form:options items="${fns:getDictList('business_ban')}" itemLabel="label" itemValue="value" htmlEscape="false"/>
            </form:select>
        </div>
    </div>
    <div class="control-group" style="float: left">
        <label class="control-label">失格次数：</label>
        <div class="controls">
            <form:input path="disqualificationNumber" htmlEscape="false" maxlength="11" class="input-xlarge digits" readonly="true"/>
        </div>
    </div>
    <div class="control-group">
        <label class="control-label">犬展禁止：</label>
        <div class="controls">
            <form:select path="showBan" class="input-xlarge ">
                <form:options items="${fns:getDictList('business_ban')}" itemLabel="label" itemValue="value" htmlEscape="false"/>
            </form:select>
        </div>
    </div>
    <div class="control-group">
        <label class="control-label">裁判评价：</label>
        <div class="controls">
            <form:textarea path="refereeEvaluation" htmlEscape="false" rows="4" maxlength="500" class="input-xxlarge " readonly="true"/>
        </div>
    </div>

    <div class="control-group">
        <label class="control-label">备注信息：</label>
        <div class="controls">
            <form:textarea path="remarks" htmlEscape="false" rows="4" maxlength="255" class="input-xxlarge " readonly="true"/>
        </div>
    </div>
    <div class="form-actions">
        <input id="btnSubmit" class="btn btn-primary" type="submit" value="保 存"/>
        <input id="btnCancel" class="btn" type="button" value="返 回" onclick="history.go(-1)"/>
    </div>
</form:form>
</body>
</html>