<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp" %>
<html>
<head>
    <title>犬只芯片号对调</title>
    <meta name="decorator" content="default"/>
    <script src="${ctxStatic}/jquery-validation/1.11.0/lib/jquery.form.js" type="text/javascript"></script>
    <script type="text/javascript">
        $(document).ready(function () {
            //保存事件
            $("#btnSubmit").click(function () {
                let birthCodeA = $("#birthCodeA").val().trim();
                if (birthCodeA == '') {
                    alert("请先输入出生纸编号A");
                    return;
                }
                let birthCodeB = $("#birthCodeB").val().trim();
                if (birthCodeB == '') {
                    alert("请先输入出生纸编号B");
                    return;
                }
                if (birthCodeA == birthCodeB) {
                    alert("输入的两个出生纸编号一致，请重新输入");
                    return;
                }
                let chipCodeA = $("#chipCodeA").val().trim();
                if (chipCodeA == "") {
                    alert("请先查询出生证明" + birthCodeA + "的芯片号！");
                    return;
                }
                let chipCodeB = $("#chipCodeB").val().trim();
                if (chipCodeB == "") {
                    alert("请先查询出生证明" + birthCodeB + "的芯片号！");
                    return;
                }
                $("#inputForm").ajaxSubmit({
                    dataType: 'json',
                    beforeSubmit: function () {
                        if (!$("#inputForm").valid() || $(".error:visible").length > 0) {
                            return false;
                        } else {
                            return true;
                        }
                    },
                    success: function (json) {
                        let data = eval(json);
                        if (data.rc == 0) {
                            layer.msg(data.data);
                            parent.isYes = true;
                            parent.layer.closeAll();
                        } else {
                            layer.msg(data.msg);
                        }
                    },
                    error: function (err) {
                        layer.msg("操作失败!");
                    }
                })

            });
        });

        function searchBirthCode(index) {
            let birthCode;
            let chipCodeInput;
            if (index == 1) {
                birthCode = $("#birthCodeA").val().trim();
                chipCodeInput = $("#chipCodeA");
            } else if (index == 2) {
                birthCode = $("#birthCodeB").val().trim();
                chipCodeInput = $("#chipCodeB");
            } else {
                alert("参数有误！");
            }
            $.post('${ctx}/birthcertificate/dogBirthCertificate/getBirthCerRegByCode', {
                birthCerRegCode: birthCode
            }, function (data) {
                if (data.result == "success") {
                    chipCodeInput.val(data.identificationFlag);
                } else {
                    alert(birthCode + "出生证明编号无效！");
                }
            });
        }

        function closeLayer() {
            parent.layer.closeAll();
        }

        setTimeout(function () {
            $("#inputForm").parent().css('min-height', 'auto')
            $('.form-actions').css({
                'position': 'absolute',
                'bottom': '0',
                'left': '0',
                'width': '100%',
                'box-sizing': 'border-box'
            })
        }, 100)

    </script>
</head>

<body>
<form:form id="inputForm" modelAttribute="dogChipNoSwap" method="post" action="${ctx}/dog/dog/chipNoSwap/birthCode"
           class="form-horizontal">
    <div class="control-group" style="margin-top: 30px">
        <label class="control-label">出生纸编号A：</label>
        <div class="controls">
            <form:input path="birthCodeA" htmlEscape="false" maxlength="64" class="input-xlarge required"/>
            <font color="#FF0000">* </font>
            <input id="search" class="btn btn-primary" type="button" value="查" onclick="searchBirthCode(1)"/>
            </br>
            <input id="chipCodeA" type="text" readonly="readonly"/>
        </div>
    </div>
    <div class="control-group">
        <label class="control-label">出生纸编号B：</label>
        <div class="controls">
            <form:input path="birthCodeB" htmlEscape="false" maxlength="64" class="input-xlarge required"/>
            <font color="#FF0000">* </font>
            <input id="search" class="btn btn-primary" type="button" value="查" onclick="searchBirthCode(2)"/>
            </br>
            <input id="chipCodeB" type="text" readonly="readonly"/>
        </div>
    </div>
    <div class="form-actions">
        <input id="btnSubmit" class="btn btn-primary" type="button" value="保 存"/>&nbsp
        <input id="btnCancel" class="btn" type="button" value="返 回" onclick="closeLayer()"/>
    </div>
</form:form>
</body>
</html>
