<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp" %>
<html>
<head>
    <title>DNA信息管理</title>
    <meta name="decorator" content="default"/>
    <script type="text/javascript">
        $(document).ready(function () {
        });

        function activeDna(id) {
            $.ajax({
                url: '${ctx}/dna/dogDna/active?id='+id,
                type: 'GET',
                async: false,
                success: function (json) {
                    if (json.rc == 0) {
                        layer.msg(json.data);
                        window.location = "${ctx}/dna/dogDna?dogId=${dogDna.dogId}"
                    } else {
                        layer.msg(json.msg);
                    }
                }
            });
        }

        function page(n, s) {
            $("#pageNo").val(n);
            $("#pageSize").val(s);
            $("#searchForm").submit();
            return false;
        }
    </script>
</head>
<body>
<ul class="nav nav-tabs">
    <li class="active"><a href="${ctx}/dna/dogDna?dogId=${dogDna.dogId}">DNA信息列表</a></li>
    <shiro:hasPermission name="dna:dogDna:add">
        <li><a href="${ctx}/dna/dogDna/editForm?dogId=${dogDna.dogId}">DNA信息添加</a></li>
    </shiro:hasPermission>
</ul>
<form:form id="searchForm" modelAttribute="dogDna" action="${ctx}/dna/dogDna/" method="post"
           class="breadcrumb form-search">
    <form:hidden path="dogId"/>
    <input id="pageNo" name="pageNo" type="hidden" value="${page.pageNo}"/>
    <input id="pageSize" name="pageSize" type="hidden" value="${page.pageSize}"/>
    <ul class="ul-form">
        <li><label>检测类型：</label>
            <form:select path="detectionType" class="input-medium">
                <form:option value="" label="全部"/>
                <form:options items="${fns:getDictList('detection_type')}" itemLabel="label" itemValue="value" htmlEscape="false"/>
            </form:select>
        </li>
        <li><label>采样包编号：</label>
            <form:input path="samplingCode" htmlEscape="false" maxlength="64" class="input-medium"/>
        </li>
        <li><label>DNA编码：</label>
            <form:input path="dnaCode" htmlEscape="false" maxlength="64" class="input-medium"/>
        </li>
        <li><label>激活状态：</label>
            <form:select path="activeState" class="input-medium">
                <form:option value="" label="全部"/>
                <form:options items="${fns:getDictList('active_state')}" itemLabel="label" itemValue="value" htmlEscape="false"/>
            </form:select>
        </li>
        <li class="btns"><input id="btnSubmit" class="btn btn-primary" type="submit" value="查询"/></li>
        <li class="clearfix"></li>
    </ul>
</form:form>
<sys:message content="${message}"/>
<table id="contentTable" class="table table-striped table-bordered table-condensed">
    <thead>
    <tr>
        <th>检测类型</th>
        <th>采样包</th>
        <th>DNA编码</th>
        <th>激活状态</th>
        <th>创建时间</th>
        <th>修改时间</th>
        <shiro:hasPermission name="dna:dogDna:edit">
            <th>操作</th>
        </shiro:hasPermission>
    </tr>
    </thead>
    <tbody>
    <c:forEach items="${page.list}" var="dogDna">
        <tr>
            <td>
                    ${fns:getDictLabel(dogDna.detectionType, 'detection_type', '')}
            </td>
            <td>
                    ${fns:escapeHtml(dogDna.samplingCode)}
            </td>
            <td>
                    ${fns:escapeHtml(dogDna.dnaCode)}
            </td>
            <td>
                <c:if test="${dogDna.activeState==1}">
                    <font color="green">${fns:getDictLabel(dogDna.activeState, 'active_state', '')}</font>
                </c:if>
                <c:if test="${dogDna.activeState==0}">
                    <shiro:hasPermission name="dna:dogDna:active">
                        <a href="#" onclick="activeDna('${dogDna.id}')">
                            <font color="red">${fns:getDictLabel(dogDna.activeState, 'active_state', '')}</font>
                        </a>
                    </shiro:hasPermission>
                </c:if>
            </td>
            <td>
                <fmt:formatDate value="${dogDna.createDate}" pattern="yyyy-MM-dd HH:mm:ss"/>
            </td>
            <td>
                <fmt:formatDate value="${dogDna.updateDate}" pattern="yyyy-MM-dd HH:mm:ss"/>
            </td>
            <td>
                <a href="${ctx}/dna/dogDna/viewForm?id=${dogDna.id}">查看</a>
                <shiro:hasPermission name="dna:dogDna:edit">
                    <a href="${ctx}/dna/dogDna/editForm?id=${dogDna.id}">修改</a>
                </shiro:hasPermission>
                <shiro:hasPermission name="dna:dogDna:del">
                    <a href="${ctx}/dna/dogDna/delete?id=${dogDna.id}">删除</a>
                </shiro:hasPermission>
            </td>
        </tr>
    </c:forEach>
    </tbody>
</table>
<div class="pagination">${page}</div>
</body>
</html>