<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
	<title>合作机构、合作医院管理</title>
	<meta name="decorator" content="default"/>
	<script type="text/javascript">
		$(document).ready(function() {
			
		});
		function page(n,s){
			$("#pageNo").val(n);
			$("#pageSize").val(s);
			$("#searchForm").submit();
        	return false;
        }
	</script>
</head>
<body>
	<ul class="nav nav-tabs">
		<li class="active"><a href="${ctx}/sys/club/">俱乐部列表</a></li>
	</ul>
	<form:form id="searchForm" modelAttribute="org" action="${ctx}/sys/club/" method="post" class="breadcrumb form-search">
		<input id="pageNo" name="pageNo" type="hidden" value="${page.pageNo}"/>
		<input id="pageSize" name="pageSize" type="hidden" value="${page.pageSize}"/>
		<ul class="ul-form">
			<li><label>地方俱乐部名称：</label>
				<form:input path="name" htmlEscape="false" maxlength="50" class="input-medium"/>
			</li>
			<li><label>合作编号：</label>
				<form:input path="memberCode" htmlEscape="false" maxlength="64" class="input-medium"/>
			</li>
			<li><label>启用状态：</label>
				<form:select path="state" class="input-small">
					<form:option value="all">全部</form:option>
					<form:option value="0">开放</form:option>
					<form:option value="1">关闭</form:option>
				</form:select>
			</li>
			<li class="btns"><input id="btnSubmit" class="btn btn-primary" type="submit" value="查询"/></li>
			<li class="clearfix"></li>
		</ul>
	</form:form>
	<sys:message content="${message}"/>
	<table id="contentTable" class="table table-striped table-bordered table-condensed">
		<thead>
			<tr>
				<th>机构名称</th>
				<th>合作编号</th>
				<th>状态</th>
				<th>押金</th>
				<th>余额</th>
				<th>操作</th>
			</tr>
		</thead>
		<tbody>
		<c:forEach items="${page.list}" var="org">
			<tr>
				<td><a href="${ctx}/sys/club/form?id=${org.id}">
					${org.name}
				</a></td>
				<td>
						${org.memberCode }
				</td>
				<td>
					<c:if test="${org.endDate gt currentDate}" > <font color="green">开放</font></c:if> 
					<c:if test="${org.endDate lt currentDate}" > <font color="red">关闭</font> </c:if> 
					<c:if test="${org.endDate eq currentDate}" > 今天关闭 </c:if> 
				</td>
				<td>
					${org.deposit}
				</td>
				<td>
					${org.member.accountBalance }
				</td>
				<td>
					<shiro:hasPermission name="sys:club:edit">
    					<a href="${ctx}/sys/club/form?id=${org.id}">修改</a>
    				</shiro:hasPermission>
    				<shiro:hasPermission name="sys:club:delete">
						<a href="${ctx}/sys/club/delete?id=${org.id}" onclick="return confirmx('确认要删除该地方俱乐部吗？', this.href)">删除</a>
					</shiro:hasPermission>
				</td>
			</tr>
		</c:forEach>
		</tbody>
	</table>
	<div class="pagination">${page}</div>
</body>
</html>