<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp" %>
<html>
<head>
    <title>轮播图管理</title>
    <meta name="decorator" content="default"/>
    <script type="text/javascript">
        $(document).ready(function () {

        });
        function page(n, s) {
            $("#pageNo").val(n);
            $("#pageSize").val(s);
            $("#searchForm").submit();
            return false;
        }
    </script>
</head>
<body>
<ul class="nav nav-tabs">
    <li class="active"><a href="${ctx}/breeder/banner/">轮播图列表</a></li>
    <shiro:hasPermission name="breeder:banner:edit">
        <li><a href="${ctx}/breeder/banner/form">轮播图添加</a></li>
    </shiro:hasPermission>
</ul>
<form:form id="searchForm" modelAttribute="banner" action="${ctx}/breeder/banner/" method="post"
           class="breadcrumb form-search">
    <input id="pageNo" name="pageNo" type="hidden" value="${page.pageNo}"/>
    <input id="pageSize" name="pageSize" type="hidden" value="${page.pageSize}"/>
    <ul class="ul-form">
        <li><label>模块：</label>
            <form:input path="module" htmlEscape="false" maxlength="50" class="input-medium"/>
        </li>
        <li><label>标题：</label>
            <form:input path="title" htmlEscape="false" maxlength="100" class="input-medium"/>
        </li>
        <li><label>跳转地址：</label>
            <form:input path="url" htmlEscape="false" maxlength="300" class="input-medium"/>
        </li>
        <li><label>跳转类型：</label>
            <form:select path="type" class="input-medium">
                <form:option value="" label="全部"/>
                <form:option value="0" label="URL跳转"/>
                <form:option value="1" label="小程序跳转"/>
            </form:select>
        </li>
        <li><label>是否可见：</label>
            <form:select path="visibleFlag" class="input-medium">
                <form:option value="" label="全部"/>
                <form:option value="1" label="可见"/>
                <form:option value="0" label="不可见"/>
            </form:select>
        </li>
        <li class="btns"><input id="btnSubmit" class="btn btn-primary" type="submit" value="查询"/></li>
        <li class="clearfix"></li>
    </ul>
</form:form>
<sys:message content="${message}"/>
<table id="contentTable" class="table table-striped table-bordered table-condensed">
    <thead>
    <tr>
        <th>模块</th>
        <th>标题</th>
        <th>跳转地址</th>
        <th>跳转类型</th>
        <th>是否可见</th>
        <th>显示开始时间</th>
        <th>显示结束时间</th>
        <th>修改时间</th>
        <th>备注信息</th>
        <shiro:hasPermission name="breeder:banner:edit">
            <th>操作</th>
        </shiro:hasPermission>
    </tr>
    </thead>
    <tbody>
    <c:forEach items="${page.list}" var="banner">
        <tr>
            <td>
                    ${banner.module}
            </td>
            <td>
                    ${banner.title}
            </td>
            <td>
                <a href="${banner.url}" target="_blank">${banner.url}</a>
            </td>
            <td>
                <c:if test="${banner.type==0}">URL跳转</c:if>
                <c:if test="${banner.type==1}">小程序跳转</c:if>
            </td>
            <td>
                <c:if test="${banner.visibleFlag==0}">不可见</c:if>
                <c:if test="${banner.visibleFlag==1}">可见</c:if>
            </td>
            <td>
                <fmt:formatDate value="${banner.startTime}" pattern="yyyy-MM-dd HH:mm:ss"/>
            </td>
            <td>
                <fmt:formatDate value="${banner.endTime}" pattern="yyyy-MM-dd HH:mm:ss"/>
            </td>
            <td>
                <fmt:formatDate value="${banner.updateDate}" pattern="yyyy-MM-dd HH:mm:ss"/>
            </td>
            <td>
                    ${banner.remarks}
            </td>
            <shiro:hasPermission name="breeder:banner:edit">
                <td>
                    <a href="${ctx}/breeder/banner/form?id=${banner.id}">修改</a>
                    <a href="${ctx}/breeder/banner/delete?id=${banner.id}"
                       onclick="return confirmx('确认要删除该轮播图吗？', this.href)">删除</a>
                </td>
            </shiro:hasPermission>
        </tr>
    </c:forEach>
    </tbody>
</table>
<div class="pagination">${page}</div>
</body>
</html>