<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
	<title>开屏广告配置管理</title>
	<meta name="decorator" content="default"/>
	<script type="text/javascript">
		$(document).ready(function() {
			
		});
		function page(n,s){
			$("#pageNo").val(n);
			$("#pageSize").val(s);
			$("#searchForm").submit();
        	return false;
        }
	</script>
</head>
<body>
	<ul class="nav nav-tabs">
		<li class="active"><a href="${ctx}/banner/appSplashAds/">开屏广告配置列表</a></li>
		<shiro:hasPermission name="banner:appSplashAds:edit"><li><a href="${ctx}/banner/appSplashAds/form">开屏广告配置添加</a></li></shiro:hasPermission>
	</ul>
	<form:form id="searchForm" modelAttribute="appSplashAds" action="${ctx}/banner/appSplashAds/" method="post" class="breadcrumb form-search">
		<input id="pageNo" name="pageNo" type="hidden" value="${page.pageNo}"/>
		<input id="pageSize" name="pageSize" type="hidden" value="${page.pageSize}"/>
		<ul class="ul-form">
			<li><label>广告位名称：</label>
				<form:input path="adName" htmlEscape="false" maxlength="64" class="input-medium"/>
			</li>
			<li><label>是否上架：</label>
				<form:select path="status" class="input-medium">
					<form:option value="" label="全部"/>
					<form:options items="${fns:getDictList('on_off_sale')}" itemLabel="label" itemValue="value" htmlEscape="false"/>
				</form:select>
			</li>
			<li><label>起止时间 ：</label>
				<input name="startDate" type="text" readonly="readonly" maxlength="20" class="input-medium Wdate"
					value="<fmt:formatDate value="${appSplashAds.startDate}" pattern="yyyy-MM-dd HH:mm:ss"/>"
					onclick="WdatePicker({dateFmt:'yyyy-MM-dd 00:00:00',isShowClear:true});"/> - 
				<input name="endDate" type="text" readonly="readonly" maxlength="20" class="input-medium Wdate"
					value="<fmt:formatDate value="${appSplashAds.endDate}" pattern="yyyy-MM-dd HH:mm:ss"/>"
					onclick="WdatePicker({dateFmt:'yyyy-MM-dd 23:59:59',isShowClear:true});"/>
			</li>
			<li class="btns"><input id="btnSubmit" class="btn btn-primary" type="submit" value="查询"/></li>
			<li class="clearfix"></li>
		</ul>
	</form:form>
	<sys:message content="${message}"/>
	<table id="contentTable" class="table table-striped table-bordered table-condensed">
		<thead>
			<tr>
				<th>广告位名称</th>
				<th>是否上架</th>
				<th>跳转类型</th>
				<th>开屏保留时间(s)</th>
				<th>开始时间</th>
				<th>结束时间</th>
				<th>优先级</th>
				<th>弹窗频率</th>
				<th>创建时间</th>
				<shiro:hasPermission name="banner:appSplashAds:edit"><th>操作</th></shiro:hasPermission>
			</tr>
		</thead>
		<tbody>
		<c:forEach items="${page.list}" var="appSplashAds">
			<tr>
				<td><a href="${ctx}/banner/appSplashAds/form?id=${appSplashAds.id}">
					${appSplashAds.adName}
				</a></td>
				<td>
					${fns:getDictLabel(appSplashAds.status, 'on_off_sale', '')}
				</td>
				<td>
					${fns:getDictLabel(appSplashAds.jumpType, 'jump_type', '')}
				</td>
				<td>
					${appSplashAds.residentSeconds}
				</td>
				<td>
					<fmt:formatDate value="${appSplashAds.startDate}" pattern="yyyy-MM-dd HH:mm:ss"/>
				</td>
				<td>
					<fmt:formatDate value="${appSplashAds.endDate}" pattern="yyyy-MM-dd HH:mm:ss"/>
				</td>
				<td>
					${appSplashAds.priority}
				</td>
				<td>
					${fns:getDictLabel(appSplashAds.frequency, 'ads_frequency', '')}
				</td>
				<td>
					<fmt:formatDate value="${appSplashAds.createDate}" pattern="yyyy-MM-dd HH:mm:ss"/>
				</td>
				<shiro:hasPermission name="banner:appSplashAds:edit"><td>
    				<a href="${ctx}/banner/appSplashAds/form?id=${appSplashAds.id}">修改</a>
					<a href="${ctx}/banner/appSplashAds/delete?id=${appSplashAds.id}" onclick="return confirmx('确认要删除该开屏广告配置吗？', this.href)">删除</a>
				</td></shiro:hasPermission>
			</tr>
		</c:forEach>
		</tbody>
	</table>
	<div class="pagination">${page}</div>
</body>
</html>