package com.subscription.restful.utils;

import java.io.InputStream;

import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Configuration;

import com.github.wxpay.sdk.WXPayConfig;

/**
 * 生产用狗账户 测试用猫账户
 * 
 * @author xx
 *
 */

@Configuration
public class MyWXPayConfig implements WXPayConfig {

	@Value("${H5wxPayNotifyUrl}")
	private String H5wxPayNotifyUrl;

	@Value("${H5wxAppID}")
	private String appID;

	@Value("${H5wxMchID}")
	private String mchID;

	@Value("${H5wxKey}")
	private String key;

	public String getPayNotifyUrl() {
		return H5wxPayNotifyUrl + "subscription/notifyUrlWeixin";
	}

	@Override
	public String getAppID() {
		return appID;
	}

	@Override
	public String getMchID() {
		return mchID;
	}

	@Override
	public String getKey() {
		return key;
	}

	@Override
	public InputStream getCertStream() {
		return null;
	}

	/**
	 * HTTP(S) 连接超时时间，单位毫秒
	 *
	 * @return
	 */
	@Override
	public int getHttpConnectTimeoutMs() {
		return 30 * 1000;
	}

	/**
	 * HTTP(S) 读数据超时时间，单位毫秒
	 *
	 * @return
	 */
	@Override
	public int getHttpReadTimeoutMs() {
		return 30 * 1000;
	}

}
