package com.cku.restful.v1.sys.model;

import java.io.Serializable;
import java.math.BigDecimal;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

@Data
@ApiModel
public class RestCouponGroup implements Serializable {

	private static final long serialVersionUID = 7930372561794322761L;

	@ApiModelProperty(value = "优惠券组ID")
	private String groupId;

	@ApiModelProperty(value = "优惠劵名称")
	private String couponName;

	@ApiModelProperty(value = "优惠劵类型 1代金券 2抵扣券 3参赛券 4满减券")
	private String couponType;

	@ApiModelProperty(value = "券类型描述")
	private String couponTypeDesc;

	@ApiModelProperty(value = "优惠券数量")
	private Integer couponNum;

	@ApiModelProperty(value = "面值")
	private BigDecimal facePrice;

	@ApiModelProperty(value = "说明")
	private String explains;

	@ApiModelProperty(value = " 面向折扣对象")
	private String target;

	@ApiModelProperty(value = "可用状态 0：可用，1：不可用")
	private String state = "0";

	@ApiModelProperty(value = "优惠券使用数量")
	private Integer useNum;

}