package com.cku.restful.v1.show.web;

import com.cku.core.PageBeanResult;
import com.cku.core.RESTResponse;
import com.cku.core.ZAErrorCode;
import com.cku.core.ZAException;
import com.cku.oa.show.dao.ShowResultsDao;
import com.cku.oa.show.dao.ShowScoreDao;
import com.cku.oa.show.dao.ShowScoreTitleDao;
import com.cku.oa.show.entity.ShowResults;
import com.cku.oa.show.entity.ShowScore;
import com.cku.oa.show.entity.ShowScoreTitle;
import com.cku.restful.v1.show.model.CkuShowScore;
import com.cku.restful.v1.show.model.RestMainShows;
import com.cku.restful.v1.show.service.CkuShowsService;
import com.cku.restful.v1.sys.web.BaseRestController;
import com.cku.util.ServletUtils;
import net.sf.json.JSONObject;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

/**
 * <p>
 * Title:RestShowsController
 * </p>
 * <p>
 * Description: CKU官网赛事部分接口
 * </p>
 * <p>
 * Company:
 * </p>
 *
 * @author zhuoHeng
 * @date 2016年9月23日 上午10:15:42
 */
@Controller
@RequestMapping(value = "/cku/v1/shows")
public class CkuShowsController extends BaseRestController {

    @Autowired
    public CkuShowsService restShowsService;
    @Autowired
    private ShowScoreDao showScoreDao;
    @Autowired
    private ShowResultsDao showResultsDao;
    @Autowired
    private ShowScoreTitleDao showScoreTitleDao;

    /**
     * @throws IOException
     * @Description：按报名截止时间倒叙查询近期3场赛事（CKU官网快速报名通道使用）
     * @author: zhuoHeng
     * @version: 2016年9月23日 上午10:18:45
     */
    @RequestMapping(value = "/shows", method = RequestMethod.GET)
    @ResponseBody
    public void getShows(HttpServletRequest request,
                         HttpServletResponse response) throws IOException {
        RESTResponse result = null;
        try {
            List<RestMainShows> mainShowsList = restShowsService.getMainShows();
            result = new RESTResponse("list",
                    new PageBeanResult<RestMainShows>(mainShowsList,
                            (long) mainShowsList.size()));
        } catch (Exception e) {
            result = new RESTResponse(e);
        }
        ServletUtils.writeResponse(response, result);
    }

    /**
     * @description: 全犬种1.按照积分排序查询积分 2.按照血统证书、类型查询、年份查询，可设置显示条数或者不限制 3.不需要分页
     * @author: laiguanglong
     * @date: 2016年9月25日 下午5:19:52
     */
    @RequestMapping(value = "/score/rank", method = RequestMethod.GET)
    @ResponseBody
    public void getScore(HttpServletRequest request,
                         HttpServletResponse response) throws IOException {
        String year = request.getParameter("year");
        String name = request.getParameter("name");
        String scoreType = request.getParameter("scoreType");
        String pedigreeCertified = request.getParameter("pedigreeCertified");
        String pageSize = request.getParameter("pageSize");
        String pageNo = request.getParameter("pageNo");
        String flag = request.getParameter("flag");
        Integer pageSizeInt = null;
        Integer pageNoInt = null;
        if (StringUtils.isBlank(year) && !scoreType.equals("bbe")) {
            throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "年份为空");
        }
        if (StringUtils.isNotBlank(pageSize)) {
            try {
                pageSizeInt = Integer.valueOf(pageSize);
                pageNoInt = ( Integer.valueOf(pageNo) - 1) * pageSizeInt ;
            } catch (Exception e) {
                throw new ZAException(ZAErrorCode.ZA_VALID_FAILED,
                        "pageSize必须为整数");
            }
        }
        String ageGroup = getAgeGroup(year, scoreType);
        List<ShowScore> showScoreList = null;
        List<ShowResults> resultsList = null;
        List pedigreeCertifiedList = new ArrayList();
        if("2020".equals(year)){
//            2020年五月一号起没有中国冠军登录的犬不能上榜
            pedigreeCertifiedList = showResultsDao.getDogAgeGroups();
        }
        HashMap<String,Object> result = new HashMap<String,Object>();
        if (StringUtils.isBlank(scoreType) || "1".equals(scoreType) || "2".equals(scoreType) ) {
            showScoreList = showScoreDao.getScoreRank123(year, scoreType,
                    pedigreeCertified, pageSizeInt, ageGroup, null);
        }else if ( "3".equals(scoreType)) {
            showScoreList = showScoreDao.getScoreRank123(year, scoreType,
                    pedigreeCertified,pageSizeInt, ageGroup,pedigreeCertifiedList);
        } else if ("20".equals(scoreType)) {
            showScoreList = showScoreDao.getScoreRank20(year, scoreType,
                    pedigreeCertified,pageSizeInt,pedigreeCertifiedList);

        } else if ("30".equals(scoreType)) {
            showScoreList = showScoreDao.getScoreRank30(year, scoreType,
                    pedigreeCertified, pageSizeInt, ageGroup);
        } else if ("4".equals(scoreType)) {
            showScoreList = showScoreDao.getScoreRank4(year, scoreType,
                    pedigreeCertified, pageSizeInt, ageGroup);
        } else if ("6".equals(scoreType) || "7".equals(scoreType)
                || "8".equals(scoreType)) {
            showScoreList = showScoreDao.getScoreRank678(year, scoreType,
                    pedigreeCertified, pageSizeInt, ageGroup);
        } else if ("ohc".equals(scoreType)) {
            resultsList = showResultsDao.getOHCScore(year, name,pageSizeInt);
        } else if ("bbe".equals(scoreType)) {
            resultsList = showResultsDao.getBBEScore(year, name,pageSizeInt,flag);

        }
        List<CkuShowScore> list = new ArrayList<CkuShowScore>();
        if (showScoreList != null && showScoreList.size() > 0) {
            for (ShowScore showScore : showScoreList) {
                list.add(new CkuShowScore(showScore));
            }
        }
        if (resultsList != null && resultsList.size() > 0) {
            for (ShowResults data : resultsList) {
                list.add(new CkuShowScore(data));
            }
        }
        result.put("list",list);
        result.put("scoreTitle",getScoreTitle(year,scoreType));
        ServletUtils.writeResponse(response, new RESTResponse("data",result));
    }

//    private List<ShowScore> getDogAgeGroups(List<ShowScore> showScoreList) {
//        List<ShowScore> list = new ArrayList<>();
//        for (ShowScore showScore : showScoreList) {
//            showResultsDao.getDogAgeGroups(showScore.getPedigreeCertified());
//            if(ageGroups.contains("12") || ageGroups.contains("13") || ageGroups.contains("14")){
//                list.add(showScore);
//            }
//        }
//        return list;
//    }

    private String getScoreTitle(String year, String scoreType) {
        ShowScoreTitle scoreTitle = showScoreTitleDao.getByYearAndGroup(year, scoreType);
        if(scoreTitle != null ){
            return scoreTitle.getTitle();
        }else{
            return  "";
        }
    }
    private String getAgeGroup(String year, String scoreType) {
        String result = "";
        if ("2013".equals(year) || "2014".equals(year) || "2015".equals(year)
                || "2016".equals(year) || "2017".equals(year) || "2018".equals(year)
                || "2019".equals(year) || "2020".equals(year) || "2021".equals(year)) {
            if ("1".equals(scoreType) || "8".equals(scoreType)) {
                result = "AND age_group IN (1,2)";
            }
            if ("2".equals(scoreType) || "7".equals(scoreType)) {
                result = "AND age_group IN (3,4)";
            }
            if ( "6".equals(scoreType) ||  "30".equals(scoreType)) {
                result = "AND age_group > 4";
            }
            if ( "3".equals(scoreType) ||  "20".equals(scoreType)) {
                if("2020".equals(year)){
                    result = "AND (\n" +
                            "\t\t\t(\n" +
                            "\t\t\t\tsr.age_group IN ('12', '13', '14')\n" +
                            "\t\t\t\tAND scd.start_time >= '2020-05-01 00:00:00'\n" +
                            "\t\t\t)\n" +
                            "\t\t\tOR scd.start_time < '2020-05-01 00:00:00'\n" +
                            "\t\t)";
                }else{
                    result = "AND age_group IN ('12','13','14')";
                }
            }
        } else {
            if ("1".equals(scoreType)) {
                result = "AND age_group < 5";
            }
            if ("2".equals(scoreType)) {
                result = "AND age_group >4";
            }
        }
        return result;
    }

    /**
     * @description: 单独展1.按照积分排序查询积分 2.按照血统证书、类型查询、年份查询，可设置显示条数或者不限制 3.不需要分页
     * @author: laiguanglong
     * @date: 2016年9月25日 下午5:19:52
     */
    @RequestMapping(value = "/score/rankBov", method = RequestMethod.GET)
    @ResponseBody
    public void getScoreBov(HttpServletRequest request,
                            HttpServletResponse response) throws IOException {
        String year = request.getParameter("year");
        String pedigreeCertified = request.getParameter("pedigreeCertified");
        String formatCode = request.getParameter("formatCode");
        if (StringUtils.isBlank(formatCode)) {
            formatCode = "11";
        }
        Integer formatCodeInt = null;
        if (StringUtils.isBlank(year)) {
            throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "年份为空");
        }
        if (StringUtils.isNotBlank(formatCode)) {
            try {
                formatCodeInt = Integer.valueOf(formatCode);
            } catch (Exception e) {
                throw new ZAException(ZAErrorCode.ZA_VALID_FAILED,
                        "formatCode必须为整数");
            }
        }
        List<ShowScore> showScoreList1 = showScoreDao.getScoreRankBov(year,
                "age_group > 4", pedigreeCertified, formatCodeInt);
        List<ShowScore> showScoreList2 = new ArrayList<ShowScore>();
        List<ShowScore> showScoreList3 = new ArrayList<ShowScore>();
        if ("1".equals(formatCode) || "2".equals(formatCode) || "3".equals(formatCode) || "4".equals(formatCode)) {
            showScoreList2 = showScoreDao.getScoreRankBov(year,
                    "age_group IN (3,4)", pedigreeCertified, formatCodeInt);
            showScoreList3 = showScoreDao.getScoreRankBov(year,
                    "age_group IN (1,2)", pedigreeCertified, formatCodeInt);
        } else {
            showScoreList2 = showScoreDao.getScoreRankBov(year,
                    "age_group <= 4", pedigreeCertified, formatCodeInt);
        }

        List<CkuShowScore> list1 = new ArrayList<CkuShowScore>();
        for (ShowScore showScore : showScoreList1) {
            list1.add(new CkuShowScore(showScore));
        }
        List<CkuShowScore> list2 = new ArrayList<CkuShowScore>();
        for (ShowScore showScore : showScoreList2) {
            list2.add(new CkuShowScore(showScore));
        }
        List<CkuShowScore> list3 = new ArrayList<CkuShowScore>();
        for (ShowScore showScore : showScoreList3) {
            list3.add(new CkuShowScore(showScore));
        }
        JSONObject jo = new JSONObject();
        jo.put("list1", list1);
        jo.put("list2", list2);
        jo.put("list3", list3);
        ServletUtils.writeResponse(response, new RESTResponse(jo));
    }

    /**
     * @throws IOException
     * @Description：CKU官网赛事介绍接口
     * @author: laiguanglong
     * @version: 2017年8月1日
     */
    @RequestMapping(value = "/introduce", method = RequestMethod.GET)
    @ResponseBody
    public void introduce(HttpServletRequest request, HttpServletResponse response) throws IOException {
        RESTResponse result = restShowsService.introduce(request);
        ServletUtils.writeResponse(response, result);
    }

    /**
     * @throws IOException
     * @Description：CKU官网赛事回顾接口
     * @author: laiguanglong
     * @version: 2017年8月1日
     */
    @RequestMapping(value = "/review", method = RequestMethod.GET)
    @ResponseBody
    public void review(HttpServletRequest request, HttpServletResponse response) throws IOException {
        RESTResponse result = restShowsService.review(request);
        ServletUtils.writeResponse(response, result);
    }
    
    
    /**
     * @throws IOException
     * @Description：CKU官网培训活动介绍接口
     * @author: laiguanglong
     * @version: 2017年8月1日
     */
    @RequestMapping(value = "/handlerIntroduce", method = RequestMethod.GET)
    @ResponseBody
    public void handlerIntroduce(HttpServletRequest request, HttpServletResponse response) throws IOException {
        RESTResponse result = restShowsService.handlerIntroduce(request);
        ServletUtils.writeResponse(response, result);
    }

    /**
     * @throws IOException
     * @Description：CKU官网培训活动回顾接口
     * @author: laiguanglong
     * @version: 2017年8月1日
     */
    @RequestMapping(value = "/handlerReview", method = RequestMethod.GET)
    @ResponseBody
    public void handlerReview(HttpServletRequest request, HttpServletResponse response) throws IOException {
        RESTResponse result = restShowsService.handlerReview(request);
        ServletUtils.writeResponse(response, result);
    }

    /**
     * @throws IOException
     * @Description：CKU官网主赛事信息接口
     * @author: laiguanglong
     * @version: 2017年8月1日
     */
    @RequestMapping(value = "/mainShowInfo", method = RequestMethod.GET)
    @ResponseBody
    public void mainShowInfo(HttpServletRequest request, HttpServletResponse response) throws IOException {
        RESTResponse result = restShowsService.mainShowInfo(request);
        ServletUtils.writeResponse(response, result);
    }

    /**
     * @throws IOException
     * @Description：CKU官网赛事裁判信息接口
     * @author: laiguanglong
     * @version: 2017年8月1日
     */
    @RequestMapping(value = "/judgeInfo", method = RequestMethod.GET)
    @ResponseBody
    public void judgeInfo(HttpServletRequest request, HttpServletResponse response) throws IOException {
        RESTResponse result = restShowsService.judgeInfo(request);
        ServletUtils.writeResponse(response, result);
    }

    /**
     * @throws IOException
     * @Description：CKU官网赛事场馆信息接口
     * @author: laiguanglong
     * @version: 2017年8月1日
     */
    @RequestMapping(value = "/venueInfo", method = RequestMethod.GET)
    @ResponseBody
    public void venueInfo(HttpServletRequest request, HttpServletResponse response) throws IOException {
        RESTResponse result = restShowsService.venueInfo(request);
        ServletUtils.writeResponse(response, result);
    }

    /**
     * @throws IOException
     * @Description：CKU官网赛事酒店信息接口
     * @author: laiguanglong
     * @version: 2017年8月1日
     */
    @RequestMapping(value = "/hotelInfo", method = RequestMethod.GET)
    @ResponseBody
    public void hotelInfo(HttpServletRequest request, HttpServletResponse response) throws IOException {
        RESTResponse result = restShowsService.hotelInfo(request);
        ServletUtils.writeResponse(response, result);
    }

    /**
     * @Description：CKU官网赛事积分信息接口
     * @author: cuihuaiyu
     * @version: 2018年01月22日
     */
    @RequestMapping(value = "/getShowScore", method = RequestMethod.GET)
    @ResponseBody
    public void getShowScore(HttpServletRequest request, HttpServletResponse response) throws IOException {
        RESTResponse result = restShowsService.getShowScoreWebsite(request);
        ServletUtils.writeResponse(response, result);
    }
}
