/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.restful.v1.show.service;

import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.cku.core.PageBeanResult;
import com.cku.core.RESTResponse;
import com.cku.core.ZAErrorCode;
import com.cku.core.ZAException;
import com.cku.oa.dog.entity.Dog;
import com.cku.oa.dog.service.DogDnaService;
import com.cku.oa.dog.service.DogService;
import com.cku.oa.show.dao.ChampionLoginDao;
import com.cku.oa.show.entity.ChampionLogin;
import com.cku.oa.show.service.ChampionLoginService;
import com.cku.restful.v1.show.model.CkuChampionLogin;
import com.cku.restful.v1.show.model.CkuChampionLoginDogSummary;
import com.cku.util.Debugger;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.utils.StringUtils;

/**
 * 冠军登录Service
 *
 * @author zhuoHeng
 * @version 2016-07-14
 */
@Service
@Transactional(readOnly = true)
public class CkuChampionLoginService {

	@Autowired
	public ChampionLoginDao championLoginDao;

	@Autowired
	public ChampionLoginService championLoginService;

	@Autowired
	public DogService dogService;

	@Autowired
	public DogDnaService dogDnaService;

	/**
	 *
	 * @Description：根据冠军登录类型、血统证书号分页查询登录犬只信息（CKU官网使用） @author: zhuoHeng
	 * @version: 2016年9月23日 下午3:42:08
	 */
	public RESTResponse getChampionLogin(String loginType, String pedigreeCertifiedCode, String reviewState,
			// loginType1 普通冠军登录 2 铜质冠军 3银质冠军 4金质冠军 5 超级冠军登录 6 世界冠军登录 7 青年冠军登录
			Integer pageNo, Integer pageSize) {
		if (pageNo != null && pageSize != null) {
			Debugger.doAssert(pageNo > 0, ZAErrorCode.ZA_ERC_PARAM_ERROR, "起始页数应大于0");
			Debugger.doAssert(pageSize > 0, ZAErrorCode.ZA_ERC_PARAM_ERROR, "每页展示条数应大于0");
			pageNo = (pageNo - 1) * pageSize;
		}
		// 设置审核状态默认值为1,审核状态只为4和1
		reviewState = StringUtils.isBlank(reviewState) || !"4".equals(reviewState) ? "1" : reviewState;
		List<CkuChampionLogin> list = championLoginDao.getChampionLogin(loginType, pedigreeCertifiedCode, reviewState,
				pageNo, pageSize);
		if ("1".equals(reviewState)) {
			String code;
			for (CkuChampionLogin model : list) {
				code = model.getLoginCode();
				// 对展示编号进行截取
				if ("6".equals(model.getLoginType())) {// 世界冠军登录
					model.setCode(code.split("-")[1].split("/")[0]);
				} else {// 非世界冠军登录
					model.setCode(code.substring(code.length() - 4, code.length()));
				}
			}
		}
		Long count = championLoginDao.getChampionLoginCount(loginType, pedigreeCertifiedCode, reviewState);
		return new RESTResponse("list", new PageBeanResult<>(list, count));
	}

	/**
	 *
	 * @Description：按年度查询冠军登录的犬只+图片+犬舍信息
	 * @author: zhuoHeng
	 * @version: 2016年9月23日 下午6:05:33
	 */
	public RESTResponse championLogin(String loginType, Integer pageNo, Integer pageSize, String annual) {
		if (pageNo != null && pageSize != null) {
			Debugger.doAssert(pageNo > 0, ZAErrorCode.ZA_ERC_PARAM_ERROR, "起始页数应大于0");
			Debugger.doAssert(pageSize > 0, ZAErrorCode.ZA_ERC_PARAM_ERROR, "每页展示条数应大于0");
			pageNo = (pageNo - 1) * pageSize;
		}
		List<CkuChampionLogin> list = championLoginDao.championLogin(loginType, pageNo, pageSize, annual);
		Long count = championLoginDao.championLoginCount(loginType, annual);
		return new RESTResponse("list", new PageBeanResult<CkuChampionLogin>(list, count));
	}

	// loginType 1 普通冠军登录 5 超级冠军登录 6 世界冠军登录 7 青年冠军登录
	public RESTResponse getAppChampionLogin(HttpServletRequest request, HttpServletResponse response) {
		String loginType = request.getParameter("loginType");
		if (StringUtils.isBlank(loginType)) {
			throw new ZAException(ZAErrorCode.ZA_ERC_MEMBER_INVALID, "冠军类型不为空！");
		}
		Set<String> set = new HashSet<>(Arrays.asList("1", "2", "3", "4", "5", "6", "7"));
		if (!set.contains(loginType)) {
			throw new ZAException(ZAErrorCode.ZA_ERC_MEMBER_INVALID, "冠军类型不正确！");
		}
		Page<ChampionLogin> page = new Page<ChampionLogin>(request, response);
		page.setOrderBy("review_time desc ");
		ChampionLogin championLogin = new ChampionLogin();
		championLogin.setDelFlag("0");
		championLogin.setPaymentState("2");
		championLogin.setReviewState("1");
		championLogin.setLoginType(loginType);
		championLogin.setPage(page);
		Page<ChampionLogin> result = championLoginService.findPageNotDogBreed(page, championLogin);
		List<CkuChampionLogin> list = result.getList().stream().map(a -> {
			CkuChampionLogin vo = new CkuChampionLogin();
			BeanUtils.copyProperties(a, vo);
			vo.setDogOwner(a.getDog().getDogOwner());
			vo.setNameEn(a.getDog().getNameEn());
			return vo;
		}).collect(Collectors.toList());
		// 只显示五十条
		if (result.getCount() > 50)
			result.setCount(50L);
		return new RESTResponse("data", new PageBeanResult<CkuChampionLogin>(list, result.getCount()));
	}

	// loginType 1 普通冠军登录 5 超级冠军登录 6 世界冠军登录 7 青年冠军登录
	public RESTResponse getAppChampionLoginDetail(String pedigreeCertified) {
		Dog dog = dogService.getByPedigreeCertifiedCode(pedigreeCertified);
		if (dog == null)
			throw new ZAException(ZAErrorCode.ZA_ERC_MEMBER_INVALID, "没有查到记录！");
		// 查询犬只信息
		CkuChampionLoginDogSummary vo = new CkuChampionLoginDogSummary();
		vo.setDogOwner(dog.getDogOwner());
		vo.setNameEn(dog.getNameEn());
		vo.setDnaPayState(dogDnaService.isHaveDogDna(dog.getId()) ? "已存" : "未存");
		vo.setPedigreeCertified(dog.getPedigreeCertifiedCode());
		// 查询登录信息
		ChampionLogin championLogin = new ChampionLogin();
		championLogin.setDelFlag("0");
		championLogin.setPaymentState("2");
		championLogin.setReviewState("1");
		championLogin.setPedigreeCertified(pedigreeCertified);
		championLogin.setLoginTypes(Arrays.asList("1", "5", "6", "7"));
		// 1 普通冠军登录 5 超级冠军登录 6 世界冠军登录 7 青年冠军登录
		List<ChampionLogin> list = championLoginDao.findList(championLogin);
		if (list == null || list.size() == 0)
			throw new ZAException(ZAErrorCode.ZA_ERC_MEMBER_INVALID, "该犬只未申请冠军登录！");
		// 6 5 1 7
		List<CkuChampionLogin> list2 = list.stream().sorted(Comparator.comparing(ChampionLogin::getLoginTypeOrder))
				.map(a -> {
					CkuChampionLogin vo2 = new CkuChampionLogin();
					BeanUtils.copyProperties(a, vo2);
					return vo2;
				}).collect(Collectors.toList());
		vo.setLogins(list2);
		return new RESTResponse("data", vo);
	}

}