/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.restful.v1.show.model;

import com.cku.oa.show.entity.ShowResults;
import com.thinkgem.jeesite.modules.sys.utils.DictUtils;
import org.apache.commons.lang3.StringUtils;

import java.text.SimpleDateFormat;

/**
 * 赛事成绩Entity
 *
 * @author lgl
 * @version 2016-07-13
 */
public class RestShowResults {
	private String referee; // 裁判
	private String ageGroup; // 年龄组别
	private String showResult; // 本场积分
	private String orderCode; // 秩序号
	private String resultCc; // cc项成绩
	private String rankings; // 小组排名
	private String startTime; // 开始时间
	private String endTime; // 结束时间
	private String showName; // 赛事名称
	private String resultCacib; // cacib项成绩
	private String resultBow; // BOW项成绩
	private String resultBoj; // BOW项成绩
	private String resultBis; // BIS项成绩
	private String resultBig; // BIG项成绩
	private String resultBob; // bob项成绩
	private String remarksCc; // CC备注
	private String resultApaccc;//亚太CC
	private String resultOhc;//犬主人成绩
	private String ohcScore;//成绩
	public RestShowResults(ShowResults vo) {
		SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
		if (vo.getStartTime() != null) {
			this.startTime = sdf.format(vo.getStartTime());
			if (vo.getEndTime() != null) {
				this.startTime = this.startTime ;
			}
		}
		this.showName = vo.getShowName();
		this.resultOhc = vo.getResultOhc();
		this.ohcScore = vo.getOhcScore();
		this.orderCode = vo.getOrderCode();
		this.resultCc = vo.getResultCc();
		this.showResult = (StringUtils.isNotBlank(vo.getShowResult())?vo.getShowResult():"0")+"/"+(StringUtils.isNotBlank(vo.getShowBreedResult())?vo.getShowBreedResult():"0");
		this.resultCacib = vo.getResultCacib();
		this.resultBow = vo.getResultBow();
		this.resultBoj = vo.getResultBoj();
		this.resultApaccc=vo.getResultApaccc();
		if(StringUtils.isBlank(vo.getResultJbis())){
			this.resultBis = vo.getResultBis();
		}else{
			if(StringUtils.isBlank(vo.getResultBis())){
				this.resultBis = vo.getResultJbis();
			}else{
				this.resultBis = vo.getResultJbis()+"/"+vo.getResultBis();
			}
		}
		if(StringUtils.isBlank(vo.getResultJbig())){
			this.resultBig = vo.getResultBig();
		}else{
			if(StringUtils.isBlank(vo.getResultBig())){
				this.resultBig = vo.getResultJbig();
			}else{
				this.resultBig = vo.getResultJbig()+"/"+vo.getResultBig();
			}
		}
		this.resultBob = vo.getResultBob();
		this.ageGroup = DictUtils.getDictLabel(vo.getAgeGroup(),
				"show_age_group", "");
		this.referee = vo.getReferee();
		this.remarksCc = vo.getRemarksCc();
		if (StringUtils.isBlank(vo.getResultBis())) {
			if (StringUtils.isBlank(vo.getResultBig())) {
				if (StringUtils.isBlank(vo.getResultBob())) {
					if (StringUtils.isNotBlank(vo.getResultBow())) {
						this.rankings = vo.getResultBow();
					}
				} else {
					this.rankings = vo.getResultBob();
				}
			} else {
				this.rankings = vo.getResultBig();
			}
		} else {
			this.rankings = vo.getResultBis();
		}
		//如果cc成绩备注为成绩取消作为前缀，以下成绩不显示
		if(StringUtils.isNotBlank(vo.getRemarksCc())&&vo.getRemarksCc().startsWith("成绩取消")){
			this.resultCc = "";
			this.resultCacib = "";
			this.resultBow = "";
			this.resultBoj = "";
			this.resultBob = "";
			this.resultBig = "";
			this.resultBis = "";
			this.showResult = "";
			this.resultApaccc="";
		}
	}

	public String getResultOhc() {
		return resultOhc;
	}

	public void setResultOhc(String resultOhc) {
		this.resultOhc = resultOhc;
	}

	public String getOhcScore() {
		return ohcScore;
	}

	public void setOhcScore(String ohcScore) {
		this.ohcScore = ohcScore;
	}

	public String getReferee() {
		return referee;
	}

	public void setReferee(String referee) {
		this.referee = referee;
	}

	public String getAgeGroup() {
		return ageGroup;
	}

	public void setAgeGroup(String ageGroup) {
		this.ageGroup = ageGroup;
	}

	public String getShowResult() {
		return showResult;
	}

	public void setShowResult(String showResult) {
		this.showResult = showResult;
	}

	public String getOrderCode() {
		return orderCode;
	}

	public void setOrderCode(String orderCode) {
		this.orderCode = orderCode;
	}

	public String getResultCc() {
		return resultCc;
	}

	public void setResultCc(String resultCc) {
		this.resultCc = resultCc;
	}

	public String getRankings() {
		return rankings;
	}

	public void setRankings(String rankings) {
		this.rankings = rankings;
	}

	public String getStartTime() {
		return startTime;
	}

	public void setStartTime(String startTime) {
		this.startTime = startTime;
	}

	public String getEndTime() {
		return endTime;
	}

	public void setEndTime(String endTime) {
		this.endTime = endTime;
	}

	public String getShowName() {
		return showName;
	}

	public void setShowName(String showName) {
		this.showName = showName;
	}

	public String getResultCacib() {
		return resultCacib;
	}

	public void setResultCacib(String resultCacib) {
		this.resultCacib = resultCacib;
	}

	public String getResultBow() {
		return resultBow;
	}

	public void setResultBow(String resultBow) {
		this.resultBow = resultBow;
	}

	public String getResultBoj() {
		return resultBoj;
	}

	public void setResultBoj(String resultBoj) {
		this.resultBoj = resultBoj;
	}

	public String getResultBis() {
		return resultBis;
	}

	public void setResultBis(String resultBis) {
		this.resultBis = resultBis;
	}

	public String getResultBig() {
		return resultBig;
	}

	public void setResultBig(String resultBig) {
		this.resultBig = resultBig;
	}

	public String getResultBob() {
		return resultBob;
	}

	public void setResultBob(String resultBob) {
		this.resultBob = resultBob;
	}

	public String getRemarksCc() {
		return remarksCc;
	}

	public void setRemarksCc(String remarksCc) {
		this.remarksCc = remarksCc;
	}

	public String getResultApaccc() {
		return resultApaccc;
	}

	public void setResultApaccc(String resultApaccc) {
		this.resultApaccc = resultApaccc;
	}
}