package com.cku.restful.v1.partner.club;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.ConstraintViolationException;

import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;

import com.cku.core.PageBeanResult;
import com.cku.core.RESTResponse;
import com.cku.core.ZAErrorCode;
import com.cku.core.ZAException;
import com.cku.oa.sys.entity.Appraiser;
import com.cku.oa.sys.entity.BaseFile;
import com.cku.oa.sys.service.FileService;
import com.cku.oa.sys.util.FnsUtils;
import com.cku.partner.club.entity.CompanionDogAppraisal;
import com.cku.partner.club.entity.RestCompanionDogAppraisal;
import com.cku.partner.club.service.CompanionDogAppraisalService;
import com.cku.restful.v1.sys.model.RestArea;
import com.cku.restful.v1.sys.utils.BeanUtil;
import com.cku.restful.v1.sys.web.BaseRestController;
import com.cku.util.ServletUtils;
import com.thinkgem.jeesite.common.beanvalidator.BeanValidators;
import com.thinkgem.jeesite.modules.sys.entity.Area;
import com.thinkgem.jeesite.modules.sys.entity.User;
import com.thinkgem.jeesite.modules.sys.utils.UserUtils;

import net.sf.json.JSONObject;

/**
 * Created by lyyz on 2019/7/10.
 */
@Controller
@RequestMapping(value = "/api/v1/open")
public class RestCompanionDogAppraisalController extends BaseRestController {

    @Autowired
    private CompanionDogAppraisalService companionDogAppraisalService;
    @Autowired
    private FileService fileService;

    /**
     * 犬芯片号校验
     *
     * @param request
     * @param response
     * @return
     */
    @ResponseBody
    @RequestMapping(value = "h5CompanionDogAppraisal/verChipNo")
    public Object verChipNo(HttpServletRequest request, HttpServletResponse response) {
//        return companionDogAppraisalService.verChipNo(request);

        return companionDogAppraisalService.verCatDogChipNo(request);
    }

    /**
     * 猫芯片号校验
     *
     * @param request
     * @param response
     * @return
     */
    @ResponseBody
    @RequestMapping(value = "h5CompanionDogAppraisal/verCatChipNo")
    public Object verCatChipNo(HttpServletRequest request, HttpServletResponse response) {
//        return companionDogAppraisalService.verCatChipNo(request);

        return companionDogAppraisalService.verCatDogChipNo(request);
    }

    /**
     * 获取犬毛色
     *
     * @param request
     * @param response
     * @return
     */
    @ResponseBody
    @RequestMapping(value = "h5CompanionDogAppraisal/getPetColor")
    public void getPetColor(HttpServletRequest request, HttpServletResponse response) throws IOException {
        ServletUtils.writeResponse(response, new RESTResponse("list", companionDogAppraisalService.getDogClorMark()));
    }

    /**
     * 获取猫毛色
     *
     * @param request
     * @param response
     * @return
     */
    @ResponseBody
    @RequestMapping(value = "h5CompanionDogAppraisal/getPetCatColor")
    public void getPetCatColor(HttpServletRequest request, HttpServletResponse response) throws IOException {
        ServletUtils.writeResponse(response, new RESTResponse("list", companionDogAppraisalService.getCatClorMark()));
    }

    /**
     * 获取省份
     *
     * @param response
     * @throws IOException
     */
    @RequestMapping(value = "h5CompanionDogAppraisal/getProvince", method = RequestMethod.GET)
    @ResponseBody
    public void getProvince(HttpServletResponse response) throws IOException {
        List<Area> result = UserUtils.getProvince();
        List<RestArea> list = new ArrayList<RestArea>();
        for (Area area : result) {
            RestArea vo = new RestArea();
            BeanUtil.copyProperties(vo, area, "yyyy-MM-dd");
            list.add(vo);
        }
        Long totalCount = (long) list.size();
        ServletUtils.writeResponse(response, new RESTResponse("list",
                new PageBeanResult<RestArea>(list, totalCount)));
    }

    /**
     * 获取省份对应的市
     *
     * @param request
     * @param response
     * @throws IOException
     */
    @RequestMapping(value = "h5CompanionDogAppraisal/getCity", method = RequestMethod.GET)
    @ResponseBody
    public void getCity(HttpServletRequest request, HttpServletResponse response)
            throws IOException {
        String provinceName = request.getParameter("provinceName");
        if (StringUtils.isBlank(provinceName)) {
            throw new ZAException(ZAErrorCode.ZA_VALID_FAILED,
                    "provinceName省名称为空");
        }
        List<Area> result = UserUtils.getCityByProvince(provinceName);
        List<RestArea> list = new ArrayList<RestArea>();
        for (Area area : result) {
            RestArea vo = new RestArea();
            BeanUtil.copyProperties(vo, area, "yyyy-MM-dd");
            list.add(vo);
        }
        Long totalCount = (long) list.size();
        ServletUtils.writeResponse(response, new RESTResponse("list",
                new PageBeanResult<RestArea>(list, totalCount)));
    }

    /**
     * 通用上传图片
     *
     * @param file
     * @param request
     * @param response
     * @throws IOException
     */
    @RequestMapping(value = "h5CompanionDogAppraisal/layupload")
    @ResponseBody
    public void layupload(@RequestParam MultipartFile file, HttpServletRequest request, HttpServletResponse response) throws IOException {
        BaseFile baseFile = fileService.uploadFile(file, "ShowPic", "1");
        JSONObject fileObject = new JSONObject();
        fileObject.put("id", baseFile.getId());
        fileObject.put("fileName", baseFile.getName());
        fileObject.put("realName", baseFile.getOrginalname());
        String path = request.getContextPath();
        String imgPath = request.getScheme() + "://" + request.getServerName() + ":" + request.getServerPort() + path + "/api/v1/open/image/" + baseFile.getId();
        fileObject.put("url", imgPath);
        response.setContentType("text/html;charset=UTF-8");//ie 浏览器使用layui 需设置头为html
        response.getWriter().write(fileObject.toString());
    }

    @ResponseBody
    @RequestMapping(value = "h5CompanionDogAppraisal/clientSave")
    public void clientSave(@RequestBody String json, HttpServletRequest request, HttpServletResponse response) throws IOException, InvocationTargetException, IllegalAccessException {
        RestCompanionDogAppraisal companionDogAppraisal = BeanUtil.toBean(json, RestCompanionDogAppraisal.class);
        if (StringUtils.isNotEmpty(companionDogAppraisal.getIdentificationFlag())) {
            Object o = companionDogAppraisalService.verCatDogChipNo(companionDogAppraisal.getIdentificationFlag(), companionDogAppraisal.getRemarks(), "", companionDogAppraisal.getChipType());
            Map<String, String> m = (Map<String, String>) o;
            if (!m.get("rc").equals("0")) {
                ServletUtils.writeResponse(response, new RESTResponse(-1, m.get("msg")));
                return;
            }
        }
        try {
            BeanValidators.validateWithException(validator, companionDogAppraisal);
        } catch (Exception ex) {
            String ss = (((ConstraintViolationException) ex).getConstraintViolations().toArray()[0]).toString();
            ss = ss.split("'")[1].split("'")[0];
            RESTResponse result = new RESTResponse(1, ss.toString());
            ServletUtils.writeResponse(response, result);
            return;
        }

        if (!Pattern.matches("1\\d{10}", companionDogAppraisal.getPetOwnerMobile())) {
            ServletUtils.writeResponse(response, new RESTResponse(1, "宠主手机号验证失败"));
            return;
        }
//        if ("1".equals(companionDogAppraisal.getAppraisalResult())) {
//            companionDogAppraisal.setAppraisalDate(new Date());
//            int random = (int) (Math.random() * 1000000);
//            companionDogAppraisal.setPassportNo(String.valueOf(random));
//        }
        CompanionDogAppraisal c = new CompanionDogAppraisal();
        BeanUtils.copyProperties(c, companionDogAppraisal);
        c.setAppraisalResult("0");
        if (StringUtils.isEmpty(c.getChipType()))
            c.setChipType(null);
        c.setOrgId(c.getRemarks());
        c.setCreateBy(new User(c.getRemarks()));
        List<Appraiser> appraiserList = FnsUtils.getAppraiserListByOrgId(c.getRemarks());
        if(!CollectionUtils.isEmpty(appraiserList)) {
        	c.setAppraisal(appraiserList.get(0).getName());
        }
        companionDogAppraisalService.save(c);
        // companionDogAppraisalService.customSql("update new_pet_passport.companion_dog_appraisal  SET org_id = '" + companionDogAppraisal.getRemarks() + "' WHERE id = '" + c.getId() + "'");
        ServletUtils.writeResponse(response, new RESTResponse());
    }

}
