package com.cku.restful.v1.open;

import com.cku.core.RESTResponse;
import com.cku.core.ZAErrorCode;
import com.cku.core.ZAException;
import com.cku.oa.sys.dao.user.MemberDao;
import com.cku.oa.sys.entity.user.Member;
import com.cku.oa.sys.util.IPLimitUtil;
import com.cku.restful.v1.sys.web.BaseRestController;
import com.cku.util.ServletUtils;
import com.thinkgem.jeesite.common.utils.StringUtils;
import com.thinkgem.jeesite.modules.sys.entity.Dict;
import com.thinkgem.jeesite.modules.sys.utils.DictUtils;
import net.sf.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.List;

@Controller
@RequestMapping(value = "/api/v1/open/petpricing")
public class PetpricingController extends BaseRestController {

    @Autowired
    private MemberDao memberDao;

    @RequestMapping(value = "/kennelStar", method = RequestMethod.GET)
    public void kennelStar(HttpServletRequest request,
                           HttpServletResponse response) throws IOException {
        validateIp(request);
        String memberCode = request.getParameter("memberCode");
        JSONObject data = new JSONObject();
        if (StringUtils.isNotBlank(memberCode)) {
            Member member = memberDao.getByMemberCode(memberCode);
            if (member != null) {
                data.put("province", getString(member.getProvince()));
                data.put("city", getString(member.getCity()));
            }
        }
        RESTResponse rESTResponse = new RESTResponse("data", data);
        ServletUtils.writeResponse(response, rESTResponse);
    }

    private void validateIp(HttpServletRequest request) {
        String ip = IPLimitUtil.getIpAddr(request);
        System.out.println("ip========" + ip);
        List<Dict> dictList = DictUtils.getDictList("petpricing_system_ip");
        boolean flag = false;
        for (Dict dict : dictList) {
            if (ip.equals(dict.getValue())) {
                flag = true;
                break;
            }
        }
        if (!flag) {
            throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "您的ip" + ip + "不在允许列表中");
        }
    }

    private String getString(String str) {
        return str == null ? "" : str;
    }
}
