package com.cku.restful.v1.open;

import java.io.IOException;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import com.cku.core.RESTResponse;
import com.cku.restful.v1.show.service.CkuChampionLoginService;
import com.cku.restful.v1.sys.web.BaseRestController;
import com.cku.util.ServletUtils;

import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;

/**
 * @Description： 公开的冠军登陆接口
 * 
 * @author: yuanshuai
 * @date: 2018/12/24 10:54
 */
@Controller
@RequestMapping(value = "/api/v1/open/championLogin")
public class OpenChampionLoginController extends BaseRestController {

	@Autowired
	private CkuChampionLoginService restChampionLoginService;

	/**
	 * 
	 * @Description：按冠军登录类型查询登录犬只数据（CKU官网使用） @author: zhuoHeng
	 * @version: 2016年9月23日 下午3:40:51
	 */
	@RequestMapping(value = "/getChampionLogin", method = RequestMethod.GET)
	@ResponseBody
	public void getChampionLogin(HttpServletRequest request, HttpServletResponse response) throws IOException {
		String loginType = ServletUtils.getParameter(request, "loginType");// 冠军登录类型
		String pedigreeCertifiedCode = ServletUtils.getParameter(request, "pedigreeCertifiedCode", null);// 血统证书号
		String reviewState = ServletUtils.getParameter(request, "reviewState", null);// 血统证书号
		Integer pageNo = ServletUtils.getParameterInt(request, "pageNo", null);// 页数
		Integer pageSize = ServletUtils.getParameterInt(request, "pageSize", null);// 页码
		RESTResponse result = restChampionLoginService.getChampionLogin(loginType, pedigreeCertifiedCode, reviewState,
				pageNo, pageSize);
		ServletUtils.writeResponse(response, result);
	}

	/**
	 * 
	 * @Description：按冠军登录类型查询登录犬只数据（手机使用）
	 */
	@ApiOperation(value = "APP-赛事板块-冠军登陆展示-list", tags = { "APP-赛事板块-冠军登陆展示-list-xuxue" }, notes = "不需要登录")
	@ApiImplicitParams({
			@ApiImplicitParam(name = "loginType ", value = "查询类型 1 普通冠军登录 5 超级冠军登录 6 世界冠军登录 7 青年冠军登录", paramType = "query"),
			@ApiImplicitParam(name = "pageNo ", value = "pageNo ", paramType = "query"),
			@ApiImplicitParam(name = "pageSize ", value = "pageSize ", paramType = "query") })
	@ApiResponses({ @ApiResponse(code = 200, message = "{\r\n" + "    \"rc\": 0,\r\n" + "    \"msg\": \"OK\",\r\n"
			+ "    \"data\": [\r\n" + "        {\r\n"
			+ "      \"nameEn\": \"CN GCH,INT,CN CH Fu You Yuan  Nasser”, — 犬名\r\n"
			+ "       \"dogOwner\": \"明子华”, — 犬主\r\n" + "       \"loginCode\": \"INT.CH-20/0504”,  — 登录序号\r\n"
			+ "       \"loginType\": \"6”,  — 冠军类型\r\n" + "            \"pedigreeCertified\": \"CKU-297018082/15\",\r\n"
			+ "            \"code\": \"\",\r\n" + "            \"breedCnName\": \"\",\r\n"
			+ "            \"memberName\": \"\",\r\n" + "            \"dnaPayState\": \"\",\r\n"
			+ "            \"dogImg\": \"\",\r\n" + "            \"reviewState\": \"1\",\r\n"
			+ "            \"kennelName\": \"\",\r\n" + "            \"breedEnName\": \"\",\r\n"
			+ "            \"createDate\": \"\"\r\n" + "        }\r\n" + "    ],\r\n" + "    \"total\": 50\r\n"
			+ "}\r\n" + "") })
	@RequestMapping(value = "/app/getChampionLoginList", method = RequestMethod.GET)
	@ResponseBody
	public void getAppChampionLogin(HttpServletRequest request, HttpServletResponse response) throws IOException {
		ServletUtils.writeResponse(response, restChampionLoginService.getAppChampionLogin(request, response));
	}

	@ApiOperation(value = "APP-赛事板块-冠军登陆展示-查询", tags = { "APP-赛事板块-冠军登陆展示-查询-xuxue" }, notes = "不需要登录")
	@ApiImplicitParams({ @ApiImplicitParam(name = "pedigreeCertified ", value = "血统证书号", paramType = "query") })
	@ApiResponses({ @ApiResponse(code = 200, message = "{\r\n" + "   \"rc\": 0,\r\n" + "   \"msg\": \"OK\",\r\n"
			+ "   \"data\": {\r\n" + "       \"dogOwner\": \"刘云龙”, — 犬主\r\n"
			+ "       \"nameEn\": \"INT,CN CH JWW'19 Tong Tong Jiang Hai Waldi”, — 犬名\r\n"
			+ "       \"pedigreeCertified\": \"CKU-332398184/18\", -- 血统证书\r\n"
			+ "       \"dnaPayState\": \"已存”, — dna存档\r\n" + "       \"loginCode\": \"\",\r\n"
			+ "       \"logins\": [   -- 登录冠军列表\r\n" + "           {\r\n"
			+ "               \"loginType\": \"1”,  — 类型 1 普通冠军登录 5 超级冠军登录 6 世界冠军登录 7 青年冠军登录\r\n"
			+ "               \"loginCode\": \"NO.CKU CH./20-6481”,  — 登录序号\r\n"
			+ "               \"pedigreeCertified\": \"CKU-332398184/18\",\r\n" + "               \"code\": \"\",\r\n"
			+ "               \"breedCnName\": \"\",\r\n" + "               \"memberName\": \"\",\r\n"
			+ "               \"dogOwner\": \"\",\r\n" + "               \"nameEn\": \"\",\r\n"
			+ "               \"dnaPayState\": \"\",\r\n" + "               \"dogImg\": \"\",\r\n"
			+ "               \"reviewState\": \"1\",\r\n" + "               \"kennelName\": \"\",\r\n"
			+ "               \"breedEnName\": \"\",\r\n" + "               \"createDate\": \"\"\r\n"
			+ "           }\r\n" + "       ]\r\n" + "   }\r\n" + "}\r\n" + "") })
	@RequestMapping(value = "/app/getChampionLogin", method = RequestMethod.GET)
	@ResponseBody
	public void getAppChampionLoginDetail(HttpServletRequest request, HttpServletResponse response) throws IOException {
		ServletUtils.writeResponse(response,
				restChampionLoginService.getAppChampionLoginDetail(request.getParameter("pedigreeCertified")));
	}

}
