package com.cku.restful.v1.groomer.web;

import com.cku.core.RESTResponse;
import com.cku.restful.v1.groomer.service.AppGroomerCourseService;
import com.cku.restful.v1.groomer.service.RestGroomerCourseApplicationService;
import com.cku.restful.v1.sys.web.BaseRestController;
import com.cku.util.ServletUtils;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;

/**
 * 课程管理Controller
 *
 * @author wangjie
 * @version 2020-09-17
 */
@Controller
@RequestMapping(value = "/app/v1/groomer")
public class AppGroomerCourseController extends BaseRestController {

	@Autowired
	private AppGroomerCourseService appGroomerCourseService;

	@Autowired
	private RestGroomerCourseApplicationService restGroomerCourseApplicationService;

	@RequestMapping(value = "/getCourseList", method = RequestMethod.GET)
	@ResponseBody
	public void getCourseList(HttpServletRequest request, HttpServletResponse response) throws IOException {
		RESTResponse result = appGroomerCourseService.getCourseList(request);
		ServletUtils.writeResponse(response, result);
	}

	@RequestMapping(value = "/getCourseDetail", method = RequestMethod.GET)
	@ResponseBody
	public void getCourseDetail(HttpServletRequest request, HttpServletResponse response) throws IOException {
		RESTResponse result = appGroomerCourseService.getCourseDetail(request);
		ServletUtils.writeResponse(response, result);
	}

	@RequestMapping(value = "/getMyCourseList", method = RequestMethod.GET)
	@ResponseBody
	public void getMyCourseList(HttpServletRequest request, HttpServletResponse response) throws IOException {
		RESTResponse result = appGroomerCourseService.getMyCourseList(request);
		ServletUtils.writeResponse(response, result);
	}

	@RequestMapping(value = "/getOneCourseDetail", method = RequestMethod.GET)
	@ResponseBody
	public void getOneCourseDetail(HttpServletRequest request, HttpServletResponse response) throws IOException {
		RESTResponse result = appGroomerCourseService.getOneCourseDetail(request);
		ServletUtils.writeResponse(response, result);
	}

	@ApiOperation(value = "美容课程-报名", tags = { "" })
	@RequestMapping(value = "/apply", method = RequestMethod.POST)
	@ResponseBody
	public void apply(@RequestBody String json, HttpServletRequest request, HttpServletResponse response)
			throws IOException {
		RESTResponse result = restGroomerCourseApplicationService.post(json);
		ServletUtils.writeResponse(response, result);
	}
	@RequestMapping(value = "/study", method = RequestMethod.POST)
	@ResponseBody
	public void study(@RequestBody String json, HttpServletResponse response)
			throws IOException {
		RESTResponse result = appGroomerCourseService.study(json);
		ServletUtils.writeResponse(response, result);
	}
	@RequestMapping(value = "/play", method = RequestMethod.POST)
	@ResponseBody
	public void play(@RequestBody String json, HttpServletResponse response)
			throws IOException {
		RESTResponse result = appGroomerCourseService.play(json);
		ServletUtils.writeResponse(response, result);
	}

}