/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.restful.v1.finance.service;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.cku.core.RESTResponse;
import com.cku.oa.finance.entity.PaymentChargingItem;
import com.cku.oa.finance.service.PaymentChargingItemService;
import com.cku.restful.v1.finance.entity.RestPaymentChargingItem;
import com.cku.restful.v1.sys.utils.BeanUtil;

import net.sf.json.JSONObject;

/**
 * 
 * <p>Title:RestPaymentChargingItemService </p>
 * <p>Description: 收费项</p>
 * <p>Company: </p> 
 * @author zhuoHeng
 * @date 2016年12月7日 上午10:18:52
 */
@Service
@Transactional(readOnly = true)
public class RestPaymentChargingItemService {

	@Autowired
	private PaymentChargingItemService paymentChargingItemService;
	
	
	/**
	 * 
	 * @Description：根据shortName查询收费项
	 * @author: zhuoHeng
	 * @version: 2016年12月7日 上午10:18:29
	 */
	public RESTResponse get(String shortName) {
		
		PaymentChargingItem model = paymentChargingItemService.getByShortName(shortName);
		RestPaymentChargingItem vo = new RestPaymentChargingItem();
		BeanUtil.copyProperties(vo, model, "yyyy-MM-dd");
		
		return new RESTResponse("data", JSONObject.fromObject(vo));
	}
}